/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.GelEpreuveFactory;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class EpreuveFactory {
    @VisibleForTesting
    public Epreuve createEpreuve() {
        return this.createEpreuve((Balise)null);
    }

    public abstract Epreuve createEpreuve(Balise var1);

    public Epreuve createEpreuve(GlobalSettings globalSettings) {
        return this.createEpreuve(globalSettings.getBaliseModel());
    }

    public Epreuve createEpreuve(Epreuve oldEpreuve) {
        Epreuve newEpreuve = this.createEpreuve(oldEpreuve.getGlobalBaliseModel());
        newEpreuve.setLocalBaliseModel(oldEpreuve.getLocalBaliseModel());
        newEpreuve.setBaliseVector(new BaliseVector(oldEpreuve.getBaliseVector()));
        newEpreuve.setName(oldEpreuve.getName());
        newEpreuve.setLimitType(oldEpreuve.getLimitType());
        newEpreuve.setTimeLimit((Date)oldEpreuve.getTimeLimit().clone());
        newEpreuve.setDurationLimit((Date)oldEpreuve.getDurationLimit().clone());
        newEpreuve.setTimeMultiplier(oldEpreuve.getTimeMultiplier());
        newEpreuve.setPenaltyIntervalInMn(oldEpreuve.getPenaltyIntervalInMn());
        newEpreuve.setPenaltyPoints(oldEpreuve.getPenaltyPoints());
        newEpreuve.setPenaltyTimeInMn(oldEpreuve.getPenaltyTimeInMn());
        newEpreuve.setTimed(oldEpreuve.isTimed());
        newEpreuve.setEnLigne(oldEpreuve.isEnLigne());
        newEpreuve.setStartTheLastBaliseOfPreviousEpreuve(oldEpreuve.isStartTheLastBaliseOfPreviousEpreuve());
        newEpreuve.setFinishTheFirstBaliseOfNextEpreuve(oldEpreuve.isFinishTheFirstBaliseOfNextEpreuve());
        newEpreuve.setToBeDoneAfterFinish(oldEpreuve.isToBeDoneAfterFinish());
        newEpreuve.setToBeDoneBeforeNextEpreuve(oldEpreuve.isToBeDoneBeforeNextEpreuve());
        newEpreuve.setToBeDoneAfterPreviousEpreuve(oldEpreuve.isToBeDoneAfterPreviousEpreuve());
        newEpreuve.setExclusiveWithNextEpreuve(oldEpreuve.isExclusiveWithNextEpreuve());
        newEpreuve.setVariante(oldEpreuve.isVariante());
        newEpreuve.setBackAndForth(oldEpreuve.isBackAndForth());
        newEpreuve.setAscenseur(oldEpreuve.isAscenseur());
        return newEpreuve;
    }

    public static EpreuveFactory getFactoryFromType(EpreuveType type) {
        if (Objects.requireNonNull(type) == EpreuveType.GEL) {
            return new GelEpreuveFactory();
        }
        return new StandardEpreuveFactory();
    }

    public abstract Epreuve createBackEpreuve(Epreuve var1);
}

