/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.PuceResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

public final class EpreuveVector {
    private final Vector<Epreuve> _epreuveVector = new Vector();

    public EpreuveVector() {
    }

    public EpreuveVector(EpreuveVector epreuveVector) {
        for (Epreuve epreuve : epreuveVector._epreuveVector) {
            this._epreuveVector.add(epreuve.getFactory().createEpreuve(epreuve));
        }
    }

    public Vector<Epreuve> getEpreuveVector() {
        return this._epreuveVector;
    }

    public void moveUpEpreuve(Epreuve epreuve) {
        int index = this._epreuveVector.indexOf(epreuve);
        if (index > 0) {
            this._epreuveVector.add(index - 1, epreuve);
            this._epreuveVector.remove(index + 1);
        }
    }

    public void moveDownEpreuve(Epreuve epreuve) {
        int index = this._epreuveVector.indexOf(epreuve);
        if (index < this._epreuveVector.size() - 1) {
            this._epreuveVector.add(index + 2, epreuve);
            this._epreuveVector.remove(index);
        }
    }

    public void addEpreuve(Epreuve epreuve) {
        if (this._notExistsWithSameName(epreuve)) {
            this._epreuveVector.add(epreuve);
        }
    }

    public void removeEpreuve(Epreuve epreuve) {
        this._epreuveVector.remove(epreuve);
    }

    public int getSize() {
        return this._epreuveVector.size();
    }

    public int getHigherBaliseNumber() {
        int max = 30;
        for (Epreuve epreuve : this._epreuveVector) {
            if (epreuve.getHigherBaliseNumber() <= max) continue;
            max = epreuve.getHigherBaliseNumber();
        }
        return max;
    }

    public Map<Integer, List<Date>> getExtraCodes(PuceResult puceResult) {
        HashMap<Integer, List<Date>> result = new HashMap<Integer, List<Date>>();
        List<Partiel> partiels = puceResult.getPuce().getPartiels();
        for (Partiel partiel : partiels) {
            if (this._existsCode(partiel.getCode())) continue;
            result.putIfAbsent(partiel.getCode(), new ArrayList());
            ((List)result.get(partiel.getCode())).add(partiel.getTimeAsDate());
        }
        return result;
    }

    public int getTotalPoints() {
        int count = 0;
        for (Epreuve epreuve : this._epreuveVector) {
            count += epreuve.getTotalPoints();
        }
        return count;
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder("<ul>");
        for (Epreuve epreuve : this._epreuveVector) {
            html.append(epreuve.toHtml(this));
        }
        html.append("</ul>");
        return html.toString();
    }

    private boolean _existsCode(int code) {
        for (Epreuve epreuve : this._epreuveVector) {
            for (int j = 0; j < epreuve.getBaliseVector().getSize(); ++j) {
                if (epreuve.getBaliseVector().getBaliseVector().get(j).getNumber() != code) continue;
                return true;
            }
        }
        return false;
    }

    boolean isFirstEpreuve(Epreuve epreuve) {
        if (!this._epreuveVector.isEmpty()) {
            return epreuve == this._epreuveVector.get(0);
        }
        return false;
    }

    boolean isLastEpreuveBeforeFinish(Epreuve epreuve) {
        if (epreuve == this._epreuveVector.lastElement() && !epreuve.isToBeDoneAfterFinish()) {
            return true;
        }
        if (this._getEpreuveIndex(epreuve) < this._epreuveVector.size() - 1) {
            return !epreuve.isToBeDoneAfterFinish() && this._epreuveVector.get(this._getEpreuveIndex(epreuve) + 1).isToBeDoneAfterFinish();
        }
        return false;
    }

    int getLastCodeOfPreviousEpreuve(Epreuve epreuve) {
        for (int i = 0; i < this._epreuveVector.size(); ++i) {
            if (epreuve != this._epreuveVector.get(i)) continue;
            return this._epreuveVector.get(i - 1).getLastBaliseNumber();
        }
        return 30;
    }

    int getFirstCodeOfNextEpreuve(Epreuve epreuve) {
        for (int i = 0; i < this._epreuveVector.size(); ++i) {
            if (epreuve != this._epreuveVector.get(i)) continue;
            return this._epreuveVector.get(i + 1).getFirstBaliseNumber();
        }
        return 30;
    }

    @VisibleForTesting
    int _getEpreuveIndex(Epreuve epreuve) {
        for (int i = 0; i < this._epreuveVector.size(); ++i) {
            if (epreuve != this._epreuveVector.get(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean existsWithSameName(String name, Epreuve epreuve) {
        String trimmedUpperCaseName = name.trim().toUpperCase();
        for (Epreuve epreuve1 : this._epreuveVector) {
            if (epreuve1 == epreuve || !epreuve1.getName().toUpperCase().equals(trimmedUpperCaseName)) continue;
            return true;
        }
        return false;
    }

    public boolean existsWithSameName(String name) {
        String trimmedUpperCase = name.trim().toUpperCase();
        for (Epreuve epreuve : this._epreuveVector) {
            if (!epreuve.getName().toUpperCase().equals(trimmedUpperCase)) continue;
            return true;
        }
        return false;
    }

    Epreuve _getSameNameEpreuve(String name) {
        String trimmedUpperCase = name.trim().toUpperCase();
        for (Epreuve epreuve : this._epreuveVector) {
            if (!epreuve.getName().toUpperCase().equals(trimmedUpperCase)) continue;
            return epreuve;
        }
        return null;
    }

    @VisibleForTesting
    boolean _notExistsWithSameName(Epreuve epreuve) {
        String trimmedUpperCase = epreuve.getName().trim().toUpperCase();
        for (Epreuve epreuve1 : this._epreuveVector) {
            if (epreuve1 != epreuve || !epreuve1.getName().toUpperCase().equals(trimmedUpperCase)) continue;
            return false;
        }
        return true;
    }

    public EpreuveVector createVariante() {
        EpreuveVector varianteVector = new EpreuveVector();
        for (Epreuve epreuve : this._epreuveVector) {
            if (epreuve.isVariante()) {
                varianteVector._epreuveVector.add(epreuve.getFactory().createEpreuve(epreuve));
                continue;
            }
            varianteVector._epreuveVector.add(epreuve);
        }
        return varianteVector;
    }

    public boolean existsEpreuve(Epreuve epreuve) {
        return this._epreuveVector.contains(epreuve);
    }

    public void replaceEpreuve(Epreuve oldEpreuve, Epreuve newEpreuve) {
        this._epreuveVector.replaceAll(element -> element == oldEpreuve ? newEpreuve : element);
    }

    public void cloneEpreuves(EpreuveVector otherEpreuves) {
        ArrayList<Epreuve> epreuves = new ArrayList<Epreuve>(this._epreuveVector);
        for (Epreuve epreuve : epreuves) {
            Epreuve otherEpreuve = otherEpreuves._getSameNameEpreuve(epreuve.getName());
            if (otherEpreuve == null || epreuve.isVariante() || otherEpreuve.isVariante()) continue;
            int index = this._epreuveVector.indexOf(epreuve);
            this._epreuveVector.remove(epreuve);
            this._epreuveVector.add(index, otherEpreuve);
        }
    }

    public void replaceBalise(int oldCode, int newCode) {
        for (Epreuve epreuve : this._epreuveVector) {
            epreuve.replaceBalise(oldCode, newCode);
        }
    }
}

