/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.equipe;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVector;
import fr.geraidv3.result.puce.PucesSpecificationsHandler;
import fr.geraidv3.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.VisibleForTesting;

public final class CsvEquipeHelper {
    private static final String NOT_ENOUGH_PUCE = "csv_equipe_helper.specific_error.not_enough_puce";
    private static final String ERROR_FILE_WRITING = "csv_equipe_helper.error1";
    private static final String ERROR_FIND = "csv_equipe_helper.error5";
    private static final String ERROR_READ = "csv_equipe_helper.error4";
    private static final String ERROR_FORMAT = "csv_equipe_helper.error6";
    private static final String ERROR_MEMORY = "csv_equipe_helper.specific_error.puce_memory";

    public static void exportEquipesTemplate(String file) {
        File absoluteFilename = new File(file);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(absoluteFilename.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = L10n.getString("csv_equipe_helper.csv_export_header1");
            writer.write(csvHeader);
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    public static void exportPucesTemplate(String file) {
        File absoluteFilename = new File(file);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(absoluteFilename.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = "Puce";
            writer.write("Puce");
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    public static void _exportEquipes(Raid raid, String filename) {
        File file = new File(filename);
        int option = 0;
        if (file.exists()) {
            option = JOptionPane.showConfirmDialog(GeRaidV3.getRootFrame(), L10n.getString("confirm_file_overwrite", filename), L10n.getString("confirmation_title"), 0, 2);
        }
        if (option == 0) {
            CsvEquipeHelper._exportEquipes(raid, file);
        }
    }

    public static void importEquipesAndPuces(Raid raid, String equipeFile, String puceFile, Map<String, Integer> vacantEquipeParcours, int numberOfPucesPerEquipe) throws IOException {
        List<String> puces = CsvEquipeHelper._readPuces(puceFile);
        Map<ParcoursVariante, Map<Equipe, Integer>> equipeInParcours = CsvEquipeHelper._readEquipesInParcours(equipeFile, raid);
        CsvEquipeHelper._assignEquipesToParcours(raid, equipeInParcours, puces, vacantEquipeParcours, numberOfPucesPerEquipe);
    }

    public static void importEquipesUniqueFile(Raid raid, String filename) throws IOException {
        List<String[]> rows = CsvEquipeHelper._extractDataRowsFromCsvFile(filename);
        CsvEquipeHelper._createEquipesFromDataRows(raid, rows);
    }

    @VisibleForTesting
    static void _exportEquipes(Raid raid, File file) {
        ParcoursVector parcoursVector = raid.getParcoursVector();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = L10n.getString("csv_equipe_helper.csv_export_header2");
            writer.write(csvHeader);
            writer.write(System.lineSeparator());
            for (Parcours parcours : parcoursVector.getParcoursVector()) {
                for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                    EquipeVector equipeVector = variante.getEquipeVector();
                    for (int i = 0; i < equipeVector.getSize(); ++i) {
                        String row = equipeVector.getEquipeVector().get(i).toCSV(variante.getName());
                        writer.write(row);
                        writer.write(System.lineSeparator());
                    }
                }
            }
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    @VisibleForTesting
    static List<String> _readPuces(String puceFile) throws IOException {
        String puce = "";
        ArrayList<String> puces = new ArrayList<String>();
        try (BufferedReader file = new BufferedReader(new FileReader(puceFile, StandardCharsets.UTF_8));){
            String line = file.readLine();
            int lineNumber = 0;
            String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            while ((line = file.readLine()) != null) {
                ++lineNumber;
                String[] row = line.trim().split(delimiter);
                if (row.length == 0) {
                    throw new IllegalArgumentException(L10n.getString(ERROR_FORMAT, puceFile));
                }
                puce = row[0];
                if (puce.isEmpty()) {
                    throw new NullPointerException(L10n.getString("csv_equipe_helper.specific_error.puce_vide", lineNumber));
                }
                if (puces.contains(puce)) {
                    throw new IllegalArgumentException(L10n.getString("csv_equipe_helper.specific_error.puce_double", puce));
                }
                puces.add(puce);
                Integer.parseInt(puce);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(L10n.getString(ERROR_FIND, puceFile));
        }
        catch (IOException e) {
            throw new IOException(L10n.getString(ERROR_READ, puceFile));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(L10n.getString("csv_equipe_helper.specific_error.puce_format", puce));
        }
        return puces;
    }

    @VisibleForTesting
    static Map<ParcoursVariante, Map<Equipe, Integer>> _readEquipesInParcours(String equipeFile, Raid raid) throws IOException {
        LinkedHashMap<ParcoursVariante, Map<Equipe, Integer>> equipesInVariante = new LinkedHashMap<ParcoursVariante, Map<Equipe, Integer>>();
        ParcoursVector parcoursVector = raid.getParcoursVector();
        try (BufferedReader file = new BufferedReader(new FileReader(equipeFile));){
            String line = file.readLine();
            String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            while ((line = file.readLine()) != null) {
                String[] row = line.trim().split(delimiter, -1);
                if (row.length <= 3) {
                    throw new IllegalArgumentException(L10n.getString(ERROR_FORMAT, equipeFile));
                }
                if (row[1].isEmpty()) {
                    throw new NullPointerException(L10n.getString("csv_equipe_helper.specific_error.team_name_null"));
                }
                ParcoursVariante variante = CsvEquipeHelper._getVarianteFromName(parcoursVector, row[3]);
                equipesInVariante.putIfAbsent(variante, new LinkedHashMap());
                CsvEquipeHelper._createEquipeInParcoursTwoFiles(raid, variante, row, equipesInVariante);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(L10n.getString(ERROR_FIND, equipeFile));
        }
        catch (IOException e) {
            throw new IOException(L10n.getString(ERROR_READ, equipeFile));
        }
        return equipesInVariante;
    }

    @VisibleForTesting
    static Equipe _createEquipeInParcoursFromFileRow(Raid raid, String[] row) {
        Equipe equipe = new Equipe(raid.getPuceResultVector());
        equipe.setBib(row[0]);
        equipe.setName(row[1]);
        equipe.setPhone(row[5]);
        if (raid.notExistsCategorieWithShortName(row[3])) {
            throw new IllegalArgumentException(L10n.getString("csv_equipe_helper.specific_error.invalid_category", row[3]));
        }
        equipe.setCategorie(raid.getCategorieVector().getCategorieFromShortName(row[3]));
        int EQUIPIER_COLUMN_START = 6;
        int numberOfEquipiers = (row.length - 6) / 2;
        for (int i = 0; i < numberOfEquipiers; ++i) {
            int firstEquipier = 6 + i * 2;
            int secondEquipier = 6 + i * 2 + 1;
            equipe.getEquipierVector().addEquipier(new Equipier(row[firstEquipier], row[secondEquipier]));
        }
        return equipe;
    }

    private static void _createEquipesFromDataRows(Raid raid, List<String[]> rows) {
        LinkedHashMap newEquipes = new LinkedHashMap();
        ParcoursVector parcoursVector = raid.getParcoursVector();
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        for (String[] stringArray : rows) {
            Equipe equipe;
            String equipeName = stringArray[1];
            if (equipeName.isEmpty()) {
                throw new NullPointerException(L10n.getString("csv_equipe_helper.specific_error.team_name_null"));
            }
            String varianteName = stringArray[4];
            ParcoursVariante variante = CsvEquipeHelper._getVarianteFromName(parcoursVector, varianteName);
            newEquipes.putIfAbsent(variante, new LinkedHashMap());
            String bib = stringArray[0];
            if (!((Map)newEquipes.get(variante)).containsKey(bib)) {
                equipe = CsvEquipeHelper._createEquipeInParcoursFromFileRow(raid, stringArray);
                ((Map)newEquipes.get(variante)).put(equipe.getBib(), equipe);
            } else {
                equipe = (Equipe)((Map)newEquipes.get(variante)).get(bib);
            }
            String puceId = stringArray[2];
            StringBuilder errorMessage = new StringBuilder();
            if (pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puceId, variante, errorMessage)) {
                throw new IllegalArgumentException(L10n.getString(ERROR_MEMORY, puceId, varianteName));
            }
            equipe.addPuceId(puceId);
        }
        for (Map.Entry entry : newEquipes.entrySet()) {
            ParcoursVariante variante = (ParcoursVariante)entry.getKey();
            Map value = (Map)entry.getValue();
            for (Equipe equipe : value.values()) {
                variante.getEquipeVector().addEquipeIfNotExistSameBibAndName(equipe);
            }
        }
    }

    private static List<String[]> _extractDataRowsFromCsvFile(String filename) throws IOException {
        String csvDelimiter;
        File absoluteFilename = new File(filename);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader file = new BufferedReader(new FileReader(absoluteFilename));){
            String line = file.readLine();
            csvDelimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            while ((line = file.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (FileNotFoundException ignored) {
            throw new FileNotFoundException(L10n.getString(ERROR_FIND, filename));
        }
        catch (IOException ignored) {
            throw new IOException(L10n.getString(ERROR_READ, filename));
        }
        for (String s : lines) {
            String[] row = s.trim().split(csvDelimiter, -1);
            if (row.length <= 5) {
                throw new IllegalArgumentException(L10n.getString(ERROR_FORMAT, filename));
            }
            rows.add(row);
        }
        return rows;
    }

    private static int _addVacantEquipesToParcours(Raid raid, int totalEquipe, ParcoursVariante variante, List<String> puces, int selectedPuce, Map<ParcoursVariante, List<Equipe>> newEquipes) {
        int bib;
        try {
            bib = Integer.parseInt(variante.getEquipeVector().getMaxBibNumber());
        }
        catch (Exception ignored) {
            bib = 1000;
        }
        StringBuilder errorMessage = new StringBuilder();
        int currentPuce = selectedPuce;
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        for (int i = 0; i < totalEquipe; ++i) {
            String puce;
            Equipe equipe = new Equipe(raid.getPuceResultVector());
            equipe.setName("Vacant-" + i);
            equipe.setBib(String.valueOf(++bib));
            equipe.setCategorie(raid.getCategorieVector().getCategorieVector().get(0));
            if (currentPuce >= puces.size()) {
                throw new IndexOutOfBoundsException(L10n.getString(NOT_ENOUGH_PUCE));
            }
            if (pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce = puces.get(currentPuce++), variante, errorMessage)) {
                throw new IllegalArgumentException(L10n.getString(ERROR_MEMORY, puce, variante.getName()));
            }
            equipe.setPuceIds(puce);
            newEquipes.computeIfAbsent(variante, v -> new ArrayList()).add(equipe);
        }
        return currentPuce;
    }

    private static String _selectPuceIds(int puceCount, int currentPuceIndex, List<String> puces, ParcoursVariante variante) {
        StringBuilder puceBuilder = new StringBuilder();
        StringBuilder errorMessage = new StringBuilder();
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        while (puceCount > 0) {
            String puce;
            if (currentPuceIndex >= puces.size()) {
                throw new IndexOutOfBoundsException(L10n.getString(NOT_ENOUGH_PUCE));
            }
            if (pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce = puces.get(currentPuceIndex++), variante, errorMessage)) {
                throw new IllegalArgumentException(L10n.getString(ERROR_MEMORY, puce, variante.getName()));
            }
            puceBuilder.append(puce).append(",");
            --puceCount;
        }
        int index = puceBuilder.lastIndexOf(",");
        puceBuilder.delete(index, index + 1);
        return puceBuilder.toString();
    }

    private static void _assignEquipesToParcours(Raid raid, Map<ParcoursVariante, Map<Equipe, Integer>> equipeInParcours, List<String> puces, Map<String, Integer> vacantEquipeParcours, int maxNumberOfPucesPerEquipe) {
        ParcoursVariante variante;
        LinkedHashMap<ParcoursVariante, List<Equipe>> newEquipes = new LinkedHashMap<ParcoursVariante, List<Equipe>>();
        int currentPuceIndex = 0;
        for (Map.Entry<ParcoursVariante, Map<Equipe, Integer>> entry : equipeInParcours.entrySet()) {
            variante = entry.getKey();
            Map<Equipe, Integer> equipes = entry.getValue();
            if (equipes.size() > puces.size()) {
                throw new IndexOutOfBoundsException(L10n.getString(NOT_ENOUGH_PUCE));
            }
            for (Map.Entry<Equipe, Integer> subEntry : equipes.entrySet()) {
                Equipe equipe = subEntry.getKey();
                int numberOfPucePerEquipe = subEntry.getValue();
                int numberOfPuces = maxNumberOfPucesPerEquipe == 0 ? numberOfPucePerEquipe : Math.min(numberOfPucePerEquipe, maxNumberOfPucesPerEquipe);
                String puceIds = CsvEquipeHelper._selectPuceIds(numberOfPuces, currentPuceIndex, puces, variante);
                equipe.setPuceIds(puceIds);
                currentPuceIndex += numberOfPuces;
                newEquipes.computeIfAbsent(variante, v -> new ArrayList()).add(equipe);
            }
            currentPuceIndex = CsvEquipeHelper._addVacantEquipesToParcours(raid, vacantEquipeParcours.get(variante.getName()), variante, puces, currentPuceIndex, newEquipes);
        }
        for (Map.Entry<ParcoursVariante, Map<Equipe, Integer>> entry : newEquipes.entrySet()) {
            variante = entry.getKey();
            for (Equipe equipe : (List)((Object)entry.getValue())) {
                variante.getEquipeVector().addEquipeIfNotExistSameBibAndName(equipe);
            }
        }
    }

    private static void _createEquipeInParcoursTwoFiles(Raid raid, ParcoursVariante variante, String[] row, Map<ParcoursVariante, Map<Equipe, Integer>> equipesInParcours) {
        Equipe equipe = new Equipe(raid.getPuceResultVector());
        equipe.setBib(row[0]);
        equipe.setName(row[1]);
        equipe.setPhone(row[4]);
        if (raid.notExistsCategorieWithShortName(row[2])) {
            throw new IllegalArgumentException(L10n.getString("csv_equipe_helper.specific_error.invalid_category", row[2]));
        }
        equipe.setCategorie(raid.getCategorieVector().getCategorieFromShortName(row[2]));
        int MEMBER_START_COLUMN = 5;
        int puceCount = 1;
        int numberOfEquipiers = (row.length - 5) / 2;
        for (int i = 0; i < numberOfEquipiers; ++i) {
            int lastnameColumn = 5 + i * 2;
            int firstnameColumn = lastnameColumn + 1;
            if (row[lastnameColumn].isEmpty() && row[firstnameColumn].isEmpty()) continue;
            equipe.getEquipierVector().addEquipier(new Equipier(row[lastnameColumn], row[firstnameColumn]));
            if (i + 1 <= puceCount) continue;
            ++puceCount;
        }
        equipesInParcours.get(variante).put(equipe, puceCount);
    }

    private static ParcoursVariante _getVarianteFromName(ParcoursVector parcoursVector, String parcoursName) {
        ParcoursVariante variante = parcoursVector.getVarianteParcoursFromNameWithoutDiacritic(parcoursName);
        if (variante == null) {
            Parcours parcours = parcoursVector.getParcoursFromNameWithoutDiacritic(parcoursName);
            if (parcours == null) {
                throw new NullPointerException(L10n.getString("csv_equipe_helper.specific_error.parcours_null", parcoursName));
            }
            if (parcours.getVarianteVector().getSize() == 0) {
                throw new NullPointerException(L10n.getString("csv_equipe_helper.specific_error.parcours_empty", parcoursName));
            }
            variante = parcours.getVarianteVector().getVarianteParcoursVector().firstElement();
        }
        return variante;
    }
}

