/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.equipe;

import fr.geraidv3.model.SortType;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeComparator;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

public final class EquipeVector {
    private final Vector<Equipe> _equipeVector = new Vector();

    public Vector<Equipe> getEquipeVector() {
        return this._equipeVector;
    }

    public int getSize() {
        return this._equipeVector.size();
    }

    public boolean addEquipeIfNotExistWithSamePuceAndBib(Equipe equipe) {
        if (!this.existsPuceFor(equipe) && !this.existsAnotherEquipeWithSameBib(equipe.getBib(), equipe)) {
            this._equipeVector.add(equipe);
            this._equipeVector.sort(new EquipeComparator(SortType.DOSSARD));
            return true;
        }
        return false;
    }

    public boolean existsAnotherEquipeWithSameBib(String bib, Equipe equipe) {
        if (bib.isEmpty()) {
            return false;
        }
        for (Equipe equipe1 : this._equipeVector) {
            if (!equipe1.getBib().equals(bib) || equipe1 == equipe || equipe.getName().equals(equipe1.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addEquipeIfNotExistSameBibAndName(Equipe equipe) {
        if (!this._existsAnotherEquipeWithSameBibAndName(equipe)) {
            this._equipeVector.add(equipe);
            this._equipeVector.sort(new EquipeComparator(SortType.DOSSARD));
            return true;
        }
        return false;
    }

    public void removeEquipe(Equipe equipe) {
        equipe.removePuceResult();
        this._equipeVector.remove(equipe);
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        for (Equipe equipe : this._equipeVector) {
            if (!equipe.getPuceIdsAsString().contains(puceId.trim())) continue;
            return equipe;
        }
        return null;
    }

    public void sortEquipes(SortType sortType) {
        this._equipeVector.sort(new EquipeComparator(sortType));
    }

    public void renumberEquipeBibs(String prefix, int firstNumber, String suffix) {
        for (int i = 0; i < this._equipeVector.size(); ++i) {
            this._equipeVector.get(i).setBib(prefix + (firstNumber + i) + suffix);
        }
    }

    public String getMaxBibNumber() {
        String maxBib = "-1";
        for (Equipe equipe : this._equipeVector) {
            if (Integer.parseInt(maxBib) >= Integer.parseInt(equipe.getBib())) continue;
            maxBib = equipe.getBib();
        }
        return maxBib;
    }

    public List<Equipe> getAllEquipesThatNameContains(String partOfLowercaseName) {
        ArrayList<Equipe> result = new ArrayList<Equipe>();
        for (Equipe equipe : this._equipeVector) {
            if (!equipe.getName().toLowerCase().contains(partOfLowercaseName)) continue;
            result.add(equipe);
        }
        return result;
    }

    public List<Equipe> getAllEquipeThatPuceIdContains(String pattern) {
        ArrayList<Equipe> result = new ArrayList<Equipe>();
        for (Equipe equipe : this._equipeVector) {
            if (!equipe.getPuceIdsAsString().contains(pattern)) continue;
            result.add(equipe);
        }
        return result;
    }

    public List<Equipe> getEquipeVectorThatEquipierNameContains(String partOfEquipierName) {
        ArrayList<Equipe> result = new ArrayList<Equipe>();
        for (Equipe equipe : this._equipeVector) {
            if (!equipe.containsEquipier(partOfEquipierName)) continue;
            result.add(equipe);
        }
        return result;
    }

    public int getNotArrivedEquipes(Parcours parcours, Etape etape) {
        int count = 0;
        Vector<Equipe> equipes = this.getEquipeVector();
        for (Equipe equipe : equipes) {
            if (equipe.isAbsent() || equipe.isArrived(parcours, etape)) continue;
            ++count;
        }
        return count;
    }

    public boolean existsPuceFor(String puceId, Equipe equipe) {
        for (Equipe equipe1 : this._equipeVector) {
            if (equipe1 == equipe || !this._existsPuceForEquipe(puceId, equipe1)) continue;
            return true;
        }
        return false;
    }

    public boolean existsPuceFor(String puceId) {
        for (Equipe equipe : this._equipeVector) {
            if (!this._existsPuceForEquipe(puceId, equipe)) continue;
            return true;
        }
        return false;
    }

    public boolean existsEquipe(Equipe equipe) {
        for (Equipe equipe1 : this._equipeVector) {
            if (equipe1 != equipe) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    Equipe getEquipeFromBib(String bib) {
        for (Equipe equipe : this._equipeVector) {
            if (!equipe.getBib().equals(bib)) continue;
            return equipe;
        }
        return null;
    }

    private boolean _existsAnotherEquipeWithSameBibAndName(Equipe equipe) {
        if (equipe.getBib().isEmpty()) {
            return false;
        }
        for (Equipe equipe1 : this._equipeVector) {
            if (!equipe1.getBib().equals(equipe.getBib()) || equipe1 == equipe || !equipe.getName().equals(equipe1.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _existsPuceForEquipe(String puceId, Equipe equipe) {
        for (String puceId1 : equipe.getPuceIds()) {
            if (puceId1.isEmpty() || !puceId1.equals(puceId.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean _existsPuceForEquipe(Equipe equipe1, Equipe equipe) {
        for (String comparedPuceId : equipe1.getPuceIds()) {
            if (!this._existsPuceForEquipe(comparedPuceId, equipe)) continue;
            return true;
        }
        return false;
    }

    private boolean existsPuceFor(Equipe equipe) {
        for (Equipe equipe1 : this._equipeVector) {
            if (equipe1 == equipe || !this._existsPuceForEquipe(equipe1, equipe)) continue;
            return true;
        }
        return false;
    }
}

