/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.parcours;

import fr.geraidv3.L10n;
import fr.geraidv3.model.SortType;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVarianteVector;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.Vector;

public final class Parcours {
    private ParcoursVarianteVector _varianteVector = new ParcoursVarianteVector();
    private EtapeEpreuveMap _etapeEpreuveMap = new EtapeEpreuveMap();
    private boolean _hasVariantes = false;
    private String _name;

    public Parcours(String name) {
        this._name = name;
    }

    public Parcours(Parcours parcours) {
        long timeInMilliseconds = DateTimeUtils.getLocaleDateInMs();
        this._name = parcours._name + "-" + timeInMilliseconds;
        this._hasVariantes = parcours._hasVariantes;
        this._etapeEpreuveMap = parcours._etapeEpreuveMap.deepCopy();
        this._varianteVector = new ParcoursVarianteVector(parcours._varianteVector);
        this.cloneEpreuves();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean hasVariantes() {
        return this._hasVariantes;
    }

    public void setHasVariantes(boolean value) {
        this._hasVariantes = value;
    }

    public ParcoursVarianteVector getVarianteVector() {
        return this._varianteVector;
    }

    public EtapeEpreuveMap getEtapeEpreuveMap() {
        return this._etapeEpreuveMap;
    }

    public void setEtapeEpreuveMap(EtapeEpreuveMap etapeEpreuveMap) {
        this._etapeEpreuveMap = etapeEpreuveMap;
    }

    public void addVariante(ParcoursVariante variante) {
        if (variante.getEtapeEpreuveMap().getSize() == 0) {
            variante.setEtapeEpreuveMap(this._etapeEpreuveMap.createVariante());
        }
        this._varianteVector.getVarianteParcoursVector().add(variante);
        this._hasVariantes = this._varianteVector.getSize() > 1;
    }

    public ParcoursVariante getVarianteFromPuceId(String idPuce) {
        return this._varianteVector.getVarianteParcoursFromPuceId(idPuce);
    }

    public boolean hasSameNameAs(Parcours parcours) {
        return this._name.equals(parcours.getName());
    }

    public ParcoursVariante getVarianteFromEquipe(Equipe equipe) {
        return this._varianteVector.getVarianteParcoursOfEquipe(equipe);
    }

    public int getIndexOfEtape(Etape etape) {
        return this._etapeEpreuveMap.getEtapeVector().indexOf(etape);
    }

    public Vector<Etape> getEtapeVector() {
        return this._etapeEpreuveMap.getEtapeVector();
    }

    public void addEtape(Etape etape) {
        this._etapeEpreuveMap.addEtape(etape);
        this._varianteVector.addEtape(etape);
    }

    public void removeEtape(Etape etape) {
        this._etapeEpreuveMap.removeEtape(etape);
        this._varianteVector.removeEtape(etape);
    }

    public EquipeVector getEquipeVector() {
        EquipeVector totalEquipeVector = new EquipeVector();
        for (ParcoursVariante variante : this._varianteVector.getVarianteParcoursVector()) {
            EquipeVector equipeVector = variante.getEquipeVector();
            totalEquipeVector.getEquipeVector().addAll(equipeVector.getEquipeVector());
        }
        return totalEquipeVector;
    }

    public int getTotalNumberOfEquipes() {
        int totalNumberOfEquipes = 0;
        for (ParcoursVariante variante : this._varianteVector.getVarianteParcoursVector()) {
            totalNumberOfEquipes += variante.getNumberOfEquipes();
        }
        return totalNumberOfEquipes;
    }

    public Etape getEtape(String name) {
        return this._etapeEpreuveMap.getEtapeFromName(name);
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        return this._varianteVector.getEquipeFromPuceId(puceId);
    }

    public String toString() {
        return this._name;
    }

    public boolean existsAnotherVarianteWithSameName(String varianteName, ParcoursVariante variante) {
        return this._varianteVector.existsAnotherVarianteParcoursWithSameName(varianteName, variante);
    }

    public void removeVariante(ParcoursVariante variante) {
        this._varianteVector.removeVarianteParcours(variante);
    }

    public boolean existsAnotherEtapeWithSameName(String name, Etape etape) {
        return this._etapeEpreuveMap.existsAnotherEtapeWithSameName(name, etape);
    }

    public void removeEquipe(Equipe equipe) {
        ParcoursVariante variante = this._varianteVector.getVarianteParcoursOfEquipe(equipe);
        assert (variante != null);
        variante.getEquipeVector().removeEquipe(equipe);
    }

    public void sortEquipes(SortType currentSelectedType) {
        for (ParcoursVariante variante : this._varianteVector.getVarianteParcoursVector()) {
            variante.getEquipeVector().sortEquipes(currentSelectedType);
        }
    }

    public EpreuveVector getEpreuvesOfEtape(Etape etape) {
        return this._etapeEpreuveMap.getEpreuvesOfEtape(etape);
    }

    public boolean existsEpreuve(Epreuve epreuve) {
        return this._etapeEpreuveMap.existsEpreuve(epreuve);
    }

    public boolean existsEpreuveName(Etape etape, String string) {
        return this._etapeEpreuveMap.existsEpreuveName(etape, string);
    }

    public void addEpreuveToEtape(Etape etape, Epreuve epreuve) {
        if (!epreuve.isVariante()) {
            this._etapeEpreuveMap.getEpreuvesOfEtape(etape).addEpreuve(epreuve);
        }
        this._varianteVector.addEpreuveToEtape(etape, epreuve);
    }

    public void removeEpreuveOfEtapeGlobally(Etape etape, Epreuve epreuve) {
        this._etapeEpreuveMap.getEpreuvesOfEtape(etape).removeEpreuve(epreuve);
        this._varianteVector.removeEpreuveOfEtapeGlobally(etape, epreuve);
    }

    public void dissociateEpreuveOfEtape(Etape etape, Epreuve epreuve) {
        this._etapeEpreuveMap.getEpreuvesOfEtape(etape).removeEpreuve(epreuve);
        this._varianteVector.dissociateEpreuveOfEtape(etape, epreuve);
    }

    public void cloneEpreuves() {
        this._varianteVector.cloneEtapesToVariantes(this._etapeEpreuveMap);
    }

    public void replaceBalise(int oldCode, int newCode) {
        this._etapeEpreuveMap.replaceBalise(oldCode, newCode);
        this._varianteVector.replaceBalise(oldCode, newCode);
    }

    public void swapBalises(int code1, int code2) {
        this._etapeEpreuveMap.replaceBalise(code1, -1);
        this._varianteVector.replaceBalise(code1, -1);
        this._etapeEpreuveMap.replaceBalise(code2, code1);
        this._varianteVector.replaceBalise(code2, code1);
        this._etapeEpreuveMap.replaceBalise(-1, code2);
        this._varianteVector.replaceBalise(-1, code2);
    }

    boolean existsEtape(Etape etape) {
        return this._etapeEpreuveMap.existsEtape(etape);
    }

    String toHtml() {
        StringBuilder html = new StringBuilder(L10n.getString("parcours_vector.html.parcours", this._name));
        html.append("<ul>");
        for (Etape etape : this.getEtapeVector()) {
            html.append("<li>");
            html.append(etape.toHtml());
            html.append(this._varianteVector.toHtml(etape));
            html.append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }
}

