/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.parcours;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.DiacriticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

public final class ParcoursVarianteVector {
    private final Vector<ParcoursVariante> _parcoursVarianteVector = new Vector();

    public ParcoursVarianteVector() {
    }

    public ParcoursVarianteVector(ParcoursVarianteVector varianteVector) {
        for (ParcoursVariante variante : varianteVector.getVarianteParcoursVector()) {
            this._parcoursVarianteVector.add(new ParcoursVariante(variante));
        }
    }

    public Vector<ParcoursVariante> getVarianteParcoursVector() {
        return this._parcoursVarianteVector;
    }

    public ParcoursVariante getVarianteParcoursFromName(String name) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            if (!variante.getName().equals(name)) continue;
            return variante;
        }
        return null;
    }

    public ParcoursVariante getVarianteParcoursFromNameWithoutDiacritic(String name) {
        String nameWithoutDiacritic = DiacriticUtils.removeDiacritic(name);
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            String parcoursNameWithoutDiacritic = DiacriticUtils.removeDiacritic(variante.getName());
            if (!parcoursNameWithoutDiacritic.equals(nameWithoutDiacritic)) continue;
            return variante;
        }
        return null;
    }

    public int getSize() {
        return this._parcoursVarianteVector.size();
    }

    public ParcoursVariante getVarianteParcoursOfEquipe(Equipe equipe) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            if (!variante.containsEquipe(equipe)) continue;
            return variante;
        }
        return null;
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        for (ParcoursVariante parcours : this._parcoursVarianteVector) {
            Equipe equipe = parcours.getEquipeFromPuceId(puceId);
            if (equipe == null) continue;
            return equipe;
        }
        return null;
    }

    public void addEtape(Etape etape) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.addEtape(etape);
        }
    }

    public void removeEtape(Etape etape) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.removeEtape(etape);
        }
    }

    public void addEpreuveToEtape(Etape etape, Epreuve epreuve) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            if (epreuve.isVariante()) {
                variante.addEpreuveToEtape(etape, epreuve.getFactory().createEpreuve(epreuve));
                continue;
            }
            variante.addEpreuveToEtape(etape, epreuve);
        }
    }

    public void removeEpreuveOfEtapeGlobally(Etape etape, Epreuve epreuve) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.removeEpreuveToEtape(etape, epreuve);
        }
    }

    public void dissociateEpreuveOfEtape(Etape etape, Epreuve epreuve) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.dissociateEpreuve(etape, epreuve);
        }
    }

    public void cloneEtapesToVariantes(EtapeEpreuveMap etapeEpreuveMapParcours) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.cloneEpreuves(etapeEpreuveMapParcours);
        }
    }

    public void replaceBalise(int oldCode, int newCode) {
        for (ParcoursVariante variante : this._parcoursVarianteVector) {
            variante.replaceBalise(oldCode, newCode);
        }
    }

    public String toHtml(Etape etape) {
        boolean hasVariantes;
        StringBuilder html = new StringBuilder();
        List<ParcoursVariante> varianteParcoursFromEtape = this.getVarianteParcoursFromEtape(etape);
        boolean bl = hasVariantes = varianteParcoursFromEtape.size() > 1;
        if (hasVariantes) {
            html.append("<ul>");
            for (ParcoursVariante variante : varianteParcoursFromEtape) {
                html.append("<li><b>Variante:").append(variante.getName()).append("</b>");
                html.append(variante.toHtml(etape));
                html.append("</li>");
            }
            html.append("</ul>");
        } else {
            for (ParcoursVariante variante : varianteParcoursFromEtape) {
                html.append(variante.toHtml(etape));
            }
        }
        return html.toString();
    }

    @VisibleForTesting
    void addVarianteParcours(ParcoursVariante parcours) {
        if (this._notExistsWithSameName(parcours.getName())) {
            this._parcoursVarianteVector.add(parcours);
        }
    }

    boolean existsAnotherVarianteParcoursWithSameName(String name, ParcoursVariante variante) {
        String trimmedName = name.trim();
        for (ParcoursVariante parcours1 : this._parcoursVarianteVector) {
            if (!parcours1.getName().equals(trimmedName) || parcours1 == variante) continue;
            return true;
        }
        return false;
    }

    void removeVarianteParcours(ParcoursVariante parcours) {
        this._parcoursVarianteVector.remove(parcours);
    }

    ParcoursVariante getVarianteParcoursFromPuceId(String puceId) {
        for (ParcoursVariante parcours : this._parcoursVarianteVector) {
            if (!parcours.existsPuceId(puceId)) continue;
            return parcours;
        }
        return null;
    }

    @VisibleForTesting
    ParcoursVariante getVarianteParcoursFromEpreuve(Epreuve epreuve) {
        for (ParcoursVariante parcours : this._parcoursVarianteVector) {
            if (!parcours.existsEpreuve(epreuve)) continue;
            return parcours;
        }
        return null;
    }

    @VisibleForTesting
    List<ParcoursVariante> getVarianteParcoursFromEtape(Etape etape) {
        ArrayList<ParcoursVariante> result = new ArrayList<ParcoursVariante>();
        for (ParcoursVariante parcours : this._parcoursVarianteVector) {
            if (!parcours.existsEtape(etape)) continue;
            result.add(parcours);
        }
        return result;
    }

    @VisibleForTesting
    boolean _notExistsWithSameName(String name) {
        String trimmedName = name.trim().toLowerCase();
        for (ParcoursVariante parcours : this._parcoursVarianteVector) {
            if (!parcours.getName().toLowerCase().equals(trimmedName)) continue;
            return false;
        }
        return true;
    }
}

