/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.List;

final class EpreuveAuScoreStrategy
implements IPunchValidatorStrategy {
    private final List<Integer> _punchedBaliseCodes;
    private final List<Long> _balisePunchTimesInMs;
    private final int[] _expectedBaliseCodes;
    private boolean[] _punchState;
    private long[] _punchTimesInMs;

    EpreuveAuScoreStrategy(int[] epreuveBaliseCodes, List<Integer> punchedBaliseCodes, List<Long> balisePunchTimesInMs) {
        this._expectedBaliseCodes = epreuveBaliseCodes;
        this._punchedBaliseCodes = punchedBaliseCodes;
        this._balisePunchTimesInMs = balisePunchTimesInMs;
        this._computePunchStatusAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchState;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    private void _computePunchStatusAndPunchTimes() {
        boolean[] alreadyUsed = new boolean[this._punchedBaliseCodes.size()];
        this._punchState = new boolean[this._expectedBaliseCodes.length];
        this._punchTimesInMs = new long[this._expectedBaliseCodes.length];
        for (int i = 0; i < this._expectedBaliseCodes.length; ++i) {
            int index = this._getIndexOfUnusedCode(this._expectedBaliseCodes[i], alreadyUsed);
            if (index >= 0) {
                this._punchState[i] = true;
                this._punchTimesInMs[i] = this._balisePunchTimesInMs.get(index);
                continue;
            }
            this._punchState[i] = false;
            this._punchTimesInMs[i] = -1L;
        }
    }

    private int _getIndexOfUnusedCode(int code, boolean[] alreadyUsed) {
        for (int i = 0; i < this._punchedBaliseCodes.size(); ++i) {
            if (code != this._punchedBaliseCodes.get(i) || alreadyUsed[i]) continue;
            alreadyUsed[i] = true;
            return i;
        }
        return -1;
    }
}

