/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.Arrays;
import java.util.List;

public final class EpreuveEnAscenseurStrategy
implements IPunchValidatorStrategy {
    private final List<Integer> _punchedBaliseCodes;
    private final List<Long> _balisePunchTimesInMs;
    private final int[] _epreuveBaliseCodes;
    private final boolean _backAndForth;
    private boolean[] _punchState;
    private long[] _punchTimesInMs;

    public EpreuveEnAscenseurStrategy(int[] epreuveBaliseCodes, List<Integer> punchedBaliseCodes, List<Long> balisePunchTimesInMs, boolean backAndForth) {
        this._epreuveBaliseCodes = epreuveBaliseCodes;
        this._punchedBaliseCodes = punchedBaliseCodes;
        this._balisePunchTimesInMs = balisePunchTimesInMs;
        this._backAndForth = backAndForth;
        this._computePunchStatusAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchState;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    private void _computePunchStatusAndPunchTimes() {
        this._punchState = new boolean[this._epreuveBaliseCodes.length];
        this._punchTimesInMs = new long[this._epreuveBaliseCodes.length];
        if (this._epreuveBaliseCodes.length == 0) {
            return;
        }
        int indexOfResult = this._checkIsOk();
        if (indexOfResult > -1) {
            if (this._backAndForth) {
                this._fillPVFrom(indexOfResult);
            } else {
                this._fillAllBalisesWithPV();
            }
        } else {
            this._fillAllBalisesWithPM();
        }
    }

    private void _fillPVFrom(int indexOfResult) {
        Arrays.fill(this._punchState, true);
        for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
            this._punchTimesInMs[i] = this._balisePunchTimesInMs.get(indexOfResult + i);
        }
    }

    private void _fillAllBalisesWithPM() {
        Arrays.fill(this._punchState, false);
        Arrays.fill(this._punchTimesInMs, -1L);
    }

    private void _fillAllBalisesWithPV() {
        Arrays.fill(this._punchState, true);
        for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
            int index = this._punchedBaliseCodes.indexOf(this._epreuveBaliseCodes[i]);
            this._punchTimesInMs[i] = this._balisePunchTimesInMs.get(index);
        }
    }

    private int _checkIsOk() {
        if (this._backAndForth) {
            for (int i = 0; i < this._punchedBaliseCodes.size(); ++i) {
                if (this._punchedBaliseCodes.get(i) != this._epreuveBaliseCodes[0] || this._checkIsOkNormal(i) != this._epreuveBaliseCodes.length) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._punchedBaliseCodes.size(); ++i) {
                if (this._punchedBaliseCodes.get(i) == this._epreuveBaliseCodes[0] && this._checkIsOkNormal(i) == this._epreuveBaliseCodes.length) {
                    return i;
                }
                if (this._punchedBaliseCodes.get(i) != this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1] || this._checkIsOkInverted(i) != this._epreuveBaliseCodes.length) continue;
                return i;
            }
        }
        return -1;
    }

    private int _checkIsOkInverted(int indexToStart) {
        int nbOk = 1;
        int j = 1;
        while (indexToStart + j < this._punchedBaliseCodes.size() && this._epreuveBaliseCodes.length - 1 - j > -1) {
            if (this._punchedBaliseCodes.get(indexToStart + j) == this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1 - j]) {
                ++nbOk;
            } else {
                return nbOk;
            }
            ++j;
        }
        return nbOk;
    }

    private int _checkIsOkNormal(int indexToStart) {
        int nbOk = 1;
        for (int j = 1; indexToStart + j < this._punchedBaliseCodes.size() && j < this._epreuveBaliseCodes.length; ++j) {
            if (this._punchedBaliseCodes.get(indexToStart + j) == this._epreuveBaliseCodes[j]) {
                ++nbOk;
                continue;
            }
            return nbOk;
        }
        return nbOk;
    }
}

