/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.List;

final class EpreuveEnLigneStrategy
implements IPunchValidatorStrategy {
    private final int[] _epreuveBaliseCodes;
    private final List<Integer> _punchedBaliseCodes;
    private final List<Long> _balisePunchTimesInMs;
    private boolean[] _punchState;
    private long[] _punchTimesInMs;

    EpreuveEnLigneStrategy(int[] epreuveBaliseCodes, List<Integer> punchedBaliseCodes, List<Long> balisePunchTimesInMs) {
        this._epreuveBaliseCodes = epreuveBaliseCodes;
        this._punchedBaliseCodes = punchedBaliseCodes;
        this._balisePunchTimesInMs = balisePunchTimesInMs;
        this._removeWrongCodesFromValidatedCodes();
        this._computePunchStatusAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchState;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    private void _removeWrongCodesFromValidatedCodes() {
        for (int i = this._punchedBaliseCodes.size() - 1; i >= 0; --i) {
            if (this._isExpectedCodeValidated(this._punchedBaliseCodes.get(i))) continue;
            this._punchedBaliseCodes.remove(i);
            this._balisePunchTimesInMs.remove(i);
        }
    }

    private void _computePunchStatusAndPunchTimes() {
        int[][] dMatrix = this._initDMatrix();
        int levenshteinDistance = this._levenshteinDistance(dMatrix);
        this._punchState = new boolean[this._epreuveBaliseCodes.length];
        this._punchTimesInMs = new long[this._epreuveBaliseCodes.length];
        int i = 0;
        int j = 0;
        while (i < this._epreuveBaliseCodes.length && j < this._punchedBaliseCodes.size()) {
            if (dMatrix[i + 1][j + 1] == dMatrix[i][j]) {
                this._punchState[i] = true;
                this._punchTimesInMs[i] = this._balisePunchTimesInMs.get(j);
                ++i;
                ++j;
                continue;
            }
            if (!this._existCodeAfter(this._epreuveBaliseCodes[i], j + 1)) {
                this._punchState[i] = false;
                this._punchTimesInMs[i] = -1L;
                ++i;
                continue;
            }
            if (!this._existCodeAfter(this._epreuveBaliseCodes[i], j + 1)) continue;
            if (dMatrix[i][j + 1] > levenshteinDistance) {
                this._punchState[i] = false;
                this._punchTimesInMs[i] = -1L;
                ++i;
                --j;
                continue;
            }
            ++j;
        }
    }

    private int[][] _initDMatrix() {
        int[][] dMatrix = new int[this._epreuveBaliseCodes.length + 1][this._punchedBaliseCodes.size() + 1];
        for (int i = 0; i < dMatrix.length; ++i) {
            dMatrix[i][0] = i;
        }
        for (int j = 0; j < dMatrix[0].length; ++j) {
            dMatrix[0][j] = j;
        }
        return dMatrix;
    }

    private int _levenshteinDistance(int[][] dMatrix) {
        for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
            for (int j = 0; j < this._punchedBaliseCodes.size(); ++j) {
                int cost = this._epreuveBaliseCodes[i] == this._punchedBaliseCodes.get(j) ? 0 : 1;
                dMatrix[i + 1][j + 1] = this._minimum(1 + dMatrix[i + 1][j], 1 + dMatrix[i][j + 1], cost + dMatrix[i][j]);
            }
        }
        return dMatrix[this._epreuveBaliseCodes.length][this._punchedBaliseCodes.size()];
    }

    private int _minimum(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    private boolean _isExpectedCodeValidated(int validatedCode) {
        for (int codeToValidate : this._epreuveBaliseCodes) {
            if (validatedCode != codeToValidate) continue;
            return true;
        }
        return false;
    }

    private boolean _existCodeAfter(int code, int index) {
        for (int j = index; j < this._punchedBaliseCodes.size(); ++j) {
            if (this._punchedBaliseCodes.get(j) != code) continue;
            return true;
        }
        return false;
    }
}

