/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.epreuve;

import fr.geraidv3.L10n;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.EpreuveVisualizationLevel;
import fr.geraidv3.result.RankingComparator;
import fr.geraidv3.result.ResultCalculationTraits;
import fr.geraidv3.result.data.EquipeHelper;
import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.puce.PuceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public final class EpreuveResult
implements ResultCalculationTraits {
    private final Raid _raid;
    private final Categorie _categorie;
    private final Etape _etape;
    private final ParcoursVariante _variante;
    private final Epreuve _epreuve;
    private final List<EtapePuceResult> _tableRowData;
    private final EpreuveVisualizationLevel _visualizationLevel;
    private final String[] _tableColumnsHeaders;
    private final String[] _columnTooltips;

    @VisibleForTesting
    EpreuveResult() {
        this._raid = null;
        this._epreuve = null;
        this._etape = null;
        this._variante = null;
        this._categorie = null;
        this._visualizationLevel = null;
        this._tableColumnsHeaders = null;
        this._columnTooltips = null;
        this._tableRowData = null;
    }

    public EpreuveResult(Raid raid, Epreuve epreuve, Etape etape, ParcoursVariante variante, Categorie categorie, EpreuveVisualizationLevel visualizationLevel, boolean useWorstEquipePuce, boolean useCumulativePenalites) {
        this._raid = raid;
        this._epreuve = epreuve;
        this._etape = etape;
        this._variante = variante;
        this._categorie = categorie;
        this._visualizationLevel = visualizationLevel;
        String[][] columnHeaders = this._createTableColumnsHeaders(visualizationLevel);
        this._tableColumnsHeaders = columnHeaders[0];
        this._columnTooltips = columnHeaders[1];
        this._tableRowData = epreuve != null ? this._createTableRowData(useWorstEquipePuce, useCumulativePenalites) : new ArrayList<EtapePuceResult>();
    }

    public Raid getRaid() {
        return this._raid;
    }

    public Etape getEtape() {
        return this._etape;
    }

    public Epreuve getEpreuve() {
        return this._epreuve;
    }

    public Categorie getCategorie() {
        return this._categorie;
    }

    public String[] getTableColumnHeaders() {
        return this._tableColumnsHeaders;
    }

    public Object[][] getTableRowData() {
        int headerSize = this._tableColumnsHeaders.length;
        Object[][] result = new Object[this._tableRowData.size()][headerSize];
        for (int i = 0; i < this._tableRowData.size(); ++i) {
            List<Object> dataColumns = this._tableRowData.get(i).getDataColumns(this._epreuve, this._visualizationLevel);
            for (int j = 0; j < dataColumns.size(); ++j) {
                result[i][j] = dataColumns.get(j);
            }
        }
        return result;
    }

    public String[] getTableColumnTooltips() {
        return this._columnTooltips;
    }

    private String[][] _createTableColumnsHeaders(EpreuveVisualizationLevel visualizationType) {
        ArrayList<String> columnHeaders = new ArrayList<String>();
        ArrayList<String> columnTooltips = new ArrayList<String>();
        columnHeaders.add(L10n.getString("table_header.column.rank.title"));
        columnTooltips.add(L10n.getString("table_header.column.rank.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.dossard.title"));
        columnTooltips.add(L10n.getString("table_header.column.dossard.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.puce.title"));
        columnTooltips.add(L10n.getString("table_header.column.puce.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.equipe.title"));
        columnTooltips.add(L10n.getString("table_header.column.equipe.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.categorie.title"));
        columnTooltips.add(L10n.getString("table_header.column.categorie.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.points.title"));
        columnTooltips.add(L10n.getString("table_header.column.points.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps_course.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps_course.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps_bonus.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps_bonus.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps_malus.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps_malus.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps_overrun.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps_overrun.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.duree_gel.title"));
        columnTooltips.add(L10n.getString("table_header.column.duree_gel.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.points_bonus.title"));
        columnTooltips.add(L10n.getString("table_header.column.points_bonus.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.points_malus.title"));
        columnTooltips.add(L10n.getString("table_header.column.points_malus.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.points_overrun.title"));
        columnTooltips.add(L10n.getString("table_header.column.points_overrun.tooltip"));
        if (visualizationType != EpreuveVisualizationLevel.SIMPLE && this._epreuve != null) {
            for (int j = 0; j < this._epreuve.getBaliseVector().getSize(); ++j) {
                columnHeaders.add(L10n.getString("table_header.column.code.title"));
                columnTooltips.add(L10n.getString("table_header.column.code.tooltip"));
                columnHeaders.add(L10n.getString("table_header.column.ok_pm.title"));
                columnTooltips.add(L10n.getString("table_header.column.ok_pm.tooltip"));
                columnHeaders.add(L10n.getString("table_header.column.points.title"));
                columnTooltips.add(L10n.getString("table_header.column.points.tooltip"));
                columnHeaders.add(L10n.getString("table_header.column.temps.title"));
                columnTooltips.add(L10n.getString("table_header.column.temps.tooltip"));
            }
        }
        return new String[][]{columnHeaders.toArray(new String[0]), columnTooltips.toArray(new String[0])};
    }

    private List<EtapePuceResult> _createTableRowData(boolean useWorstEquipePuce, boolean useCumulativePenalites) {
        List<EtapePuceResult> data = this._createResultsFromPuceResults();
        if (useCumulativePenalites) {
            Map<String, List<EtapePuceResult>> equipes = EquipeHelper.groupByEquipes(data);
            for (Map.Entry<String, List<EtapePuceResult>> equipe : equipes.entrySet()) {
                List<EtapePuceResult> results = equipe.getValue();
                long penalitesTimeInS = 0L;
                int penalitesPoints = 0;
                for (EtapePuceResult result : results) {
                    penalitesTimeInS += result.getBaliseMalusTimeInS();
                    penalitesPoints += result.getBaliseMalusPoints();
                }
                for (EtapePuceResult result : results) {
                    result.recalculateTotalResults(penalitesTimeInS, penalitesPoints);
                }
            }
        }
        this._sortEquipesFromPointsThenTime(data);
        this.moveNonClassifiedEquipesAtTheEnd(data);
        if (useWorstEquipePuce) {
            this.keepOnlyWorstResultForEquipe(data);
        }
        this.rankClassifiedEquipes(data);
        return data;
    }

    private List<EtapePuceResult> _createResultsFromPuceResults() {
        ArrayList<EtapePuceResult> data = new ArrayList<EtapePuceResult>();
        List<PuceResult> puceResultVector = this._raid.getPuceResultVector().getPuceResultVector();
        Parcours parcoursForEtape = this._raid.getParcoursFromEtape(this._etape);
        for (PuceResult puceResult : puceResultVector) {
            boolean varianteMatch;
            if (!puceResult.getParcours().hasSameNameAs(parcoursForEtape) || puceResult.getEtape() != this._etape) continue;
            boolean categoryMatch = !this._raid.getCategorieVector().getCategorieVector().contains(this._categorie) || puceResult.getEquipe().getCategorie() == this._categorie;
            boolean bl = varianteMatch = this._variante == null || this._variante.existsEquipe(puceResult.getEquipe());
            if (!categoryMatch || !varianteMatch || puceResult.getEquipe().isAbsent()) continue;
            EtapePuceResult etapePuceResult = this._createPuceEtapeResultFromPuceResult(puceResult);
            data.add(etapePuceResult);
        }
        return data;
    }

    private void _sortEquipesFromPointsThenTime(List<EtapePuceResult> data) {
        data.sort(new RankingComparator());
    }

    private EtapePuceResult _createPuceEtapeResultFromPuceResult(PuceResult puceResult) {
        String puceId = puceResult.getPuce().getId();
        Parcours parcours = this._raid.getParcoursFromEtape(this._etape);
        int sanctionPointPenalty = this._raid.getPenaliteVector().getSanctionPoints(parcours, this._etape, puceId);
        int sanctionTimePenalty = this._raid.getPenaliteVector().getSanctionTimeInS(parcours, this._etape, puceId);
        return new EtapePuceResult(puceResult, sanctionPointPenalty, sanctionTimePenalty, this._raid.withTeammates());
    }
}

