/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.parcours;

import fr.geraidv3.L10n;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.parcours.PuceParcoursResult;
import fr.geraidv3.result.parcours.PuceParcoursResultVector;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.List;
import java.util.Vector;

final class ParcoursHtmlHelper {
    ParcoursHtmlHelper() {
    }

    static String getTableColumnHeaders(Parcours parcours) {
        StringBuilder html = new StringBuilder("<tr align=center style='font-weight: bold;text-align:center'><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.rank.title") + "</td><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.dossard.title") + "</td><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.equipe.title") + "</td><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.categorie.title") + "</td><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.points.title") + "</td><td style=background-color:#000;color:#FFF;padding:5px 3px 5px 3px;>" + L10n.getString("table_header.column.temps.title") + "</td>");
        if (parcours != null) {
            for (int i = 0; i < parcours.getEtapeVector().size(); ++i) {
                html.append("<td style=").append("background-color:#000;color:#FFF;padding:5px 3px 5px 3px;").append(">").append(L10n.getString("table_header.column.etape.title")).append("</td>");
                html.append("<td style=").append("background-color:#000;color:#FFF;padding:5px 3px 5px 3px;").append(">").append(L10n.getString("table_header.column.points.title")).append("</td>");
                html.append("<td style=").append("background-color:#000;color:#FFF;padding:5px 3px 5px 3px;").append(">").append(L10n.getString("table_header.column.temps.title")).append("</td>");
            }
        }
        html.append("</tr>");
        return html.toString();
    }

    static String getTableRowData(Parcours parcours, PuceParcoursResultVector dataColumns, boolean enabledDisplayTeammate) {
        StringBuilder html = new StringBuilder();
        List<PuceParcoursResult> results = dataColumns.getPuceParcoursResults();
        for (int i = 0; i < results.size(); ++i) {
            html.append("<tr style=");
            if (i % 2 == 0) {
                html.append("background-color:#FFF;");
            } else {
                html.append("background-color:#EAEAEA;");
            }
            html.append(" align=center>");
            PuceParcoursResult result = results.get(i);
            if (result.getRank() < 0) {
                html.append("<td style='").append("background-color:#008000;color:#FFF;").append("'>NC</td>");
            } else {
                html.append("<td style='").append("background-color:#008000;color:#FFF;").append("'>").append(result.getRank()).append("</td>");
            }
            html.append("<td>").append(result.getEquipe().getBib()).append("</td>");
            String equipe = enabledDisplayTeammate ? result.getEquipe().getEquipierNames() : result.getEquipe().getName();
            html.append("<td>").append(equipe).append("</td>");
            html.append("<td>").append(result.getEquipe().getCategorie().getShortName()).append("</td>");
            html.append("<td>").append(result.getTotalPoints()).append("</td>");
            html.append("<td>").append(DateTimeUtils.millisecondsToString(result.getTotalTime())).append("</td>");
            Vector<Etape> etapeVector = parcours.getEtapeVector();
            for (int j = 0; j < etapeVector.size(); ++j) {
                Etape etape = etapeVector.get(j);
                html.append("<td>").append(etape.getName()).append("</td>");
                html.append("<td>").append(result.getEtapePoints(j)).append("</td>");
                html.append("<td>").append(result.getEtapeTemps(j)).append("</td>");
            }
            html.append("</tr>");
        }
        return html.toString();
    }
}

