/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.puce;

import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.List;

public final class PuceResult {
    private final Puce _puce = new Puce();
    private Parcours _parcours = null;
    private Etape _etape = null;
    private Equipe _equipe = null;

    public Parcours getParcours() {
        return this._parcours;
    }

    public void setParcours(Parcours parcours) {
        this._parcours = parcours;
    }

    public Etape getEtape() {
        return this._etape;
    }

    public void setEtape(Etape etape) {
        this._etape = etape;
    }

    public Equipe getEquipe() {
        return this._equipe;
    }

    public void setEquipe(Equipe equipe) {
        this._equipe = equipe;
    }

    public Puce getPuce() {
        return this._puce;
    }

    public String toCSV() {
        StringBuilder tampon = new StringBuilder(this._parcours.getName()).append(";").append(this._etape.getName()).append(";").append(this._equipe.getBib()).append(";").append(this._equipe.getName()).append(";").append(this._equipe.getCategorie().getShortName()).append(";").append(this._equipe.getPuceIdsAsString()).append(";").append(DateTimeUtils.millisecondsToString(this._puce.getStartTime().getTime())).append(";").append(DateTimeUtils.millisecondsToString(this._puce.getFinishTime().getTime()));
        List<Partiel> partiels = this._puce.getPartiels();
        for (Partiel partiel : partiels) {
            tampon.append(";").append(partiel.getCode()).append(";").append(DateTimeUtils.dateToString(partiel.getTimeAsDate()));
        }
        return tampon.toString();
    }

    public int getPuceIndex(int code) {
        return this._puce.getPartielIndex(code);
    }

    public List<Long> getTimeInMilliseconds() {
        return this._puce.getTimesInMilliseconds();
    }

    public List<Integer> getCodes() {
        return this._puce.getCodes();
    }

    public String getCodesToHtml() {
        StringBuilder builder = new StringBuilder("<b>Ordre de validation</b>&nbsp;:");
        for (int number : this._puce.getCodes()) {
            builder.append(" ").append(number);
        }
        return builder.toString();
    }
}

