/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.utils;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.desktop.setting_menu.PlatformSettingsHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;

public class SoftwareUpdater {
    private static final String UPDATE_SERVER = "https://vikazim.fr/wp-content/geraid/tarballs/";
    private static final String TEMP_DIR_PREFIX = "geraid_update_";
    private static final String LINUX_ZIP_FILENAME = "geraidv3-%s-linux.zip";
    private static final String MACOS_ZIP_FILENAME = "geraidv3-%s-mac.zip";
    private static final String WINDOWS_ZIP_FILENAME = "geraidv3-%s-windows.zip";

    public static void update(String version) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        String updateUrl = SoftwareUpdater._getUpdateUrl(version);
        String checkSumUrl = updateUrl + ".sha256";
        String expectedChecksum = SoftwareUpdater._downloadChecksum(checkSumUrl);
        Path zipPath = Files.createTempFile("update", ".zip", new FileAttribute[0]);
        SoftwareUpdater._downloadFile(updateUrl, zipPath);
        if (!SoftwareUpdater.verifyChecksum(zipPath, expectedChecksum)) {
            throw new IOException("Le fichier t\u00e9l\u00e9charg\u00e9 semble corrompu.");
        }
        Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
        SoftwareUpdater._unzip(zipPath, tempDir);
        SoftwareUpdater._runUpdateCommand(tempDir);
        System.exit(0);
    }

    private static String _getUpdateUrl(String version) {
        String updateUrl = PlatformSettingsHandler.platformIsLinux() ? UPDATE_SERVER + String.format(LINUX_ZIP_FILENAME, version) : (PlatformSettingsHandler.platformIsWindows() ? UPDATE_SERVER + String.format(WINDOWS_ZIP_FILENAME, version) : UPDATE_SERVER + String.format(MACOS_ZIP_FILENAME, version));
        return updateUrl;
    }

    private static String _downloadChecksum(String urlStr) throws IOException {
        URL url = URI.create(urlStr).toURL();
        try (InputStream in = url.openStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                string = reader.readLine().trim();
            }
            return string;
        }
    }

    private static void _downloadFile(String urlString, Path destination) throws IOException {
        URL url = URI.create(urlString).toURL();
        try (InputStream in = url.openStream();){
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static boolean verifyChecksum(Path file, String expectedChecksum) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString().equalsIgnoreCase(expectedChecksum);
    }

    private static void _unzip(Path zipFilePath, Path destinationDirectory) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath.toFile()));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Path filePath = destinationDirectory.resolve(entry.getName());
                if (!entry.isDirectory()) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath.toFile()));){
                        int read;
                        byte[] bytesIn = new byte[4096];
                        while ((read = zipIn.read(bytesIn)) != -1) {
                            bos.write(bytesIn, 0, read);
                        }
                    }
                } else {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void _runUpdateCommand(Path newFilesDir) throws IOException, URISyntaxException {
        File currentJar = new File(SoftwareUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        File appDir = currentJar.getParentFile();
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String source = newFilesDir.toAbsolutePath().toString();
        String destination = appDir.getAbsolutePath();
        String jarPath = currentJar.getAbsolutePath();
        if (PlatformSettingsHandler.platformIsWindows()) {
            String[] command = new String[]{"cmd", "/c", String.format("start \"\" /min cmd /c \"timeout /t 2 > NUL & xcopy /E /Y \"%s\\geraidv3\" \"%s\" & start /min \"\" \"%s\" -jar \"%s\"\"", source, destination, javaBin, jarPath)};
            Runtime.getRuntime().exec(command);
        } else if (PlatformSettingsHandler.platformIsLinux()) {
            String[] command = new String[]{"/bin/sh", "-c", String.format("sleep 2; rm -r \"%s/libs/\"; cp -rp \"%s/geraidv3/\"* \"%s\"/; chmod 755 \"%s/geraidv3\"; \"%s\" -jar \"%s\" &", destination, source, destination, destination, javaBin, jarPath)};
            Runtime.getRuntime().exec(command);
        } else if (PlatformSettingsHandler.platformIsMacOs()) {
            Path path = Paths.get(destination, new String[0]);
            String macDestination = path.getParent().getParent().getParent().toString();
            String[] command = new String[]{"/bin/sh", "-c", String.format("sleep 2; setopt rmstarsilent; rm -rf \"%s/Contents\"; cp -rp \"%s/geraidv3.app/\"* \"%s\";  chmod 755 \"%s/Contents/MacOS/universalJavaApplicationStub\"; open \"%s\" &", macDestination, source, macDestination, macDestination, macDestination)};
            Runtime.getRuntime().exec(command);
        } else {
            JOptionPane.showMessageDialog(GeRaidV3.getRootFrame(), "Pas encore impl\u00e9ment\u00e9", "Attention", 1);
        }
    }
}

