/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import net.gecosi.CommStatus;
import net.gecosi.SportIdentListener;
import net.gecosi.adapter.rxtx.RxtxPort;
import net.gecosi.dataframe.SportIdentDataFrame;
import net.gecosi.internal.SportIdentDriver;

public class SportIdentHandler
implements Runnable {
    private final ArrayBlockingQueue<SportIdentDataFrame> _dataQueue = new ArrayBlockingQueue(5);
    private final SportIdentListener _sportIdentListener;
    private long _zeroHourInMilliseconds;
    private SportIdentDriver _driver;
    private Thread _thread;

    public SportIdentHandler(SportIdentListener sportIdentListener) {
        this._sportIdentListener = sportIdentListener;
    }

    public void setZeroHourInMilliseconds(long hour) {
        this._zeroHourInMilliseconds = hour;
    }

    public void connect(String portName) throws IOException, SerialPortInvalidPortException {
        SerialPort port = SerialPort.getCommPort((String)portName);
        port.openPort();
        this.start();
        this._driver = new SportIdentDriver(new RxtxPort(port), this).start();
    }

    public void start() {
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        if (this._driver != null) {
            this._driver.interrupt();
        }
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }

    public void notify(SportIdentDataFrame data) {
        data.startingAt(this._zeroHourInMilliseconds);
        this._dataQueue.offer(data);
    }

    public void notify(CommStatus status) {
        this._sportIdentListener.notify(status);
    }

    public void notifyError(CommStatus errorStatus, String errorMessage) {
        this._sportIdentListener.notify(errorStatus, errorMessage);
    }

    @Override
    public void run() {
        try {
            while (true) {
                SportIdentDataFrame dataFrame = this._dataQueue.take();
                this._sportIdentListener.handleEcard(dataFrame);
            }
        }
        catch (InterruptedException e) {
            this._dataQueue.clear();
            Thread.currentThread().interrupt();
            return;
        }
    }
}

