/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.adapter.rxtx;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import net.gecosi.adapter.rxtx.RxtxCommReader;
import net.gecosi.adapter.rxtx.RxtxCommWriter;
import net.gecosi.internal.CommWriter;
import net.gecosi.internal.SportIdentMessageQueue;
import net.gecosi.internal.SportIdentPort;

public final class RxtxPort
implements SportIdentPort {
    private final SerialPort _port;

    public RxtxPort(SerialPort port) {
        this._port = port;
    }

    @Override
    public SportIdentMessageQueue createMessageQueue() {
        SportIdentMessageQueue messageQueue = new SportIdentMessageQueue(10);
        this._port.addDataListener((SerialPortDataListener)new RxtxCommReader(this._port.getInputStream(), messageQueue));
        return messageQueue;
    }

    @Override
    public CommWriter createWriter() {
        return new RxtxCommWriter(this._port.getOutputStream());
    }

    @Override
    public void setupHighSpeed() {
        this.setSpeed(38400);
    }

    @Override
    public void setupLowSpeed() {
        this.setSpeed(4800);
    }

    public void setSpeed(int baudRate) {
        this._port.setComPortParameters(baudRate, 8, 1, 0);
    }

    @Override
    public void close() {
        this._port.closePort();
    }
}

