/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.dataframe;

import java.util.Arrays;
import net.gecosi.dataframe.SportIdentAbstractDataFrame;
import net.gecosi.dataframe.SportIdentDataFrame;
import net.gecosi.dataframe.SportIdentPunch;
import net.gecosi.internal.SportIdentMessage;

public abstract class SportIdent6PlusAbstractDataFrame
extends SportIdentAbstractDataFrame {
    protected SportIdent6PlusAbstractDataFrame(SportIdentMessage[] dataMessages) {
        this.setDataFrame(this.extractDataFrame(dataMessages));
        this.siNumber = this.extractSiNumber();
    }

    @Override
    public SportIdentDataFrame startingAt(long zeroHour) {
        this.startTime = this.advanceTimePast(this.extractStartTime(), zeroHour);
        this.checkTime = this.advanceTimePast(this.extractCheckTime(), zeroHour);
        long refTime = this.newRefTime(zeroHour, this.startTime);
        this.punches = this.extractPunches(refTime);
        if (this.punches.length > 0) {
            SportIdentPunch lastPunch = this.punches[this.punches.length - 1];
            refTime = this.newRefTime(refTime, lastPunch.timestamp());
        }
        this.finishTime = this.advanceTimePast(this.extractFinishTime(), refTime);
        return this;
    }

    public long advanceTimePast(long timestamp, long refTime) {
        return this.advanceTimePast(timestamp, refTime, 86400000L);
    }

    protected byte[] extractDataFrame(SportIdentMessage[] dataMessages) {
        byte[] dataFrame = Arrays.copyOfRange(dataMessages[0].sequence(), 6, dataMessages.length * 128 + 6);
        for (int i = 1; i < dataMessages.length; ++i) {
            System.arraycopy(dataMessages[i].sequence(), 6, dataFrame, i * 128, 128);
        }
        return dataFrame;
    }

    protected int rawNbPunches() {
        return this.byteAt(this.nbPunchesIndex());
    }

    protected long extractFullTime(int pageStart) {
        int pmFlag = this.byteAt(pageStart) & 1;
        return this.computeFullTime(pmFlag, this.timestampAt(pageStart + 2));
    }

    protected int extractCode(int punchIndex) {
        int codeHigh = (this.byteAt(punchIndex) & 0xC0) << 2;
        return codeHigh + this.byteAt(punchIndex + 1);
    }

    protected abstract int siNumberIndex();

    protected abstract int startTimeIndex();

    protected abstract int finishTimeIndex();

    protected abstract int checkTimeIndex();

    protected abstract int nbPunchesIndex();

    protected abstract SportIdentPunch[] extractPunches(long var1);

    private String extractSiNumber() {
        return Integer.toString(this.block3At(this.siNumberIndex()));
    }

    private long extractStartTime() {
        return this.extractFullTime(this.startTimeIndex());
    }

    private long extractFinishTime() {
        return this.extractFullTime(this.finishTimeIndex());
    }

    private long extractCheckTime() {
        return this.extractFullTime(this.checkTimeIndex());
    }

    private long computeFullTime(int pmFlag, long twelveHoursTime) {
        if (twelveHoursTime == 61166000L) {
            return 61166000L;
        }
        return (long)pmFlag * 43200000L + twelveHoursTime;
    }
}

