/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.dataframe;

import net.gecosi.dataframe.SportIdent6PlusAbstractDataFrame;
import net.gecosi.dataframe.SportIdentPunch;
import net.gecosi.internal.SportIdentMessage;

public final class SportIdent8PlusDataFrame
extends SportIdent6PlusAbstractDataFrame {
    public static final int PAGE_SIZE = 4;
    private static final int SI_NUMBER_PAGE = 24;
    public static final int NB_PUNCHES_INDEX = 22;
    private final SiPlusSeries siSeries = this.extractSiSeries();

    public SportIdent8PlusDataFrame(SportIdentMessage[] dataMessages) {
        super(dataMessages);
    }

    @Override
    public String getSiSeries() {
        return this.siSeries.ident();
    }

    @Override
    protected int siNumberIndex() {
        return 25;
    }

    @Override
    protected int startTimeIndex() {
        return 12;
    }

    @Override
    protected int finishTimeIndex() {
        return 16;
    }

    @Override
    protected int checkTimeIndex() {
        return 8;
    }

    @Override
    protected int nbPunchesIndex() {
        return 22;
    }

    @Override
    protected SportIdentPunch[] extractPunches(long startTime) {
        SportIdentPunch[] punches = new SportIdentPunch[this.rawNbPunches()];
        int punchesStart = this.siSeries.punchesPageStartIndex();
        long refTime = startTime;
        for (int i = 0; i < punches.length; ++i) {
            int punchIndex = (punchesStart + i) * 4;
            long punchTime = this.advanceTimePast(this.extractFullTime(punchIndex), refTime);
            punches[i] = new SportIdentPunch(this.extractCode(punchIndex), punchTime);
            refTime = this.newRefTime(refTime, punchTime);
        }
        return punches;
    }

    private SiPlusSeries extractSiSeries() {
        switch (this.byteAt(24) & 0xF) {
            case 2: {
                return SiPlusSeries.SI8_SERIES;
            }
            case 1: {
                return SiPlusSeries.SI9_SERIES;
            }
            case 4: {
                return SiPlusSeries.PCARD_SERIES;
            }
            case 15: {
                return SiPlusSeries.SI10PLUS_SERIES;
            }
        }
        return SiPlusSeries.UNKNOWN_SERIES;
    }

    public static enum SiPlusSeries {
        SI8_SERIES("SiCard 8", 34),
        SI9_SERIES("SiCard 9", 14),
        SI10PLUS_SERIES("SiCard 10/11/SIAC", 32),
        PCARD_SERIES("pCard", 44),
        UNKNOWN_SERIES("Unknown", 0);

        private final String _ident;
        private final int _punchesPageIndex;

        private SiPlusSeries(String ident, int punchesPageIndex) {
            this._ident = ident;
            this._punchesPageIndex = punchesPageIndex;
        }

        public String ident() {
            return this._ident;
        }

        public int punchesPageStartIndex() {
            return this._punchesPageIndex;
        }
    }
}

