/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

@ExcludeFromJacocoGeneratedReport
public final class LookAndFeelTheme {
    public static final Color ACCENT_COLOR = new Color(0, 128, 0);
    public static final Color ACCENT_COLOR_TRANSPARENT = new Color(0, 128, 0, 25);
    public static final Color BACKGROUND_COLOR = new Color(242, 242, 242);
    public static final Color ABSENCE_COLOR = new Color(137, 81, 41);
    public static final Color SHADOW_COLOR = new Color(0xEEEEEE);
    public static final Color WARNING_COLOR = new Color(254, 126, 0);
    public static final Color SUCCESS_COLOR = new Color(73, 183, 72);
    public static final Color FAILURE_COLOR = new Color(238, 60, 72);
    public static final String HTML_HEADER_COLUMN_STYLE = "background-color:#000;color:#FFF;padding:5px 3px 5px 3px;";
    public static final String HTML_ODD_ROW_STYLE = "background-color:#EAEAEA;";
    public static final String HTML_EVEN_ROW_STYLE = "background-color:#FFF;";
    public static final String HTML_RANK_CELL_STYLE = "background-color:#008000;color:#FFF;";

    public static void setup() {
        try {
            LookAndFeelTheme._loadTheme();
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    private static void _loadTheme() {
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("@background", LookAndFeelTheme._toHexadecimal(BACKGROUND_COLOR));
        extra.put("@accentColor", LookAndFeelTheme._toHexadecimal(ACCENT_COLOR));
        FlatLaf.setGlobalExtraDefaults(extra);
        UIManager.put("TabbedPane.selectedBackground", ACCENT_COLOR_TRANSPARENT);
        FontUIResource fontUIResource = (FontUIResource)UIManager.get("TitledBorder.font");
        UIManager.put("TitledBorder.font", fontUIResource.deriveFont(1));
        UIManager.put("Table.paintOutsideAlternateRows", true);
        UIManager.put("Table.alternateRowColor", SHADOW_COLOR);
        UIManager.put("Component.arrowType", "triangle");
        UIManager.put("RootPane.background", ACCENT_COLOR);
        UIManager.put("MenuBar.background", ACCENT_COLOR);
        UIManager.put("MenuBar.foreground", Color.WHITE);
        UIManager.put("TitlePane.foreground", Color.WHITE);
        UIManager.put("TitlePane.inactiveForeground", Color.LIGHT_GRAY);
        UIManager.put("TitlePane.iconSize", new Dimension(24, 24));
        UIManager.put("MenuBar.selectionBackground", Color.WHITE);
        UIManager.put("MenuBar.selectionForeground", Color.BLACK);
        if (SystemInfo.isWindows) {
            System.setProperty("flatlaf.useWindowDecorations", "true");
        } else if (SystemInfo.isLinux) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            System.setProperty("flatlaf.menuBarEmbedded", "true");
        }
    }

    private static String _toHexadecimal(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

