/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.BackupTask;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.DistributionServerGateway;
import fr.geraidv3.desktop.RecentFileDialog;
import fr.geraidv3.desktop.ReleaseDialog;
import fr.geraidv3.desktop.SavingTask;
import fr.geraidv3.desktop.equipe_panel.SportIdentPuceReaderInEquipePanel;
import fr.geraidv3.desktop.raid_file.RaidFileXmlReader;
import fr.geraidv3.desktop.raid_file.RaidXmlFileWriter;
import fr.geraidv3.desktop.setting_menu.GlobalSettingsDialog;
import fr.geraidv3.desktop.setting_menu.PlatformSettingsHandler;
import fr.geraidv3.desktop.setting_menu.PublicationView;
import fr.geraidv3.desktop.setting_menu.RecentProjectsFileHandler;
import fr.geraidv3.desktop.sportident_panel.SportIdentPuceReaderInResultPanel;
import fr.geraidv3.desktop.sportident_panel.SportIdentPuceResultDialog;
import fr.geraidv3.desktop.sportident_panel.SportIdentPuceView;
import fr.geraidv3.desktop.sportident_panel.SportIdentStationState;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.MyComboBox;
import fr.geraidv3.desktop.tools_menu.QrCodeGenerator;
import fr.geraidv3.desktop.tools_menu.TimeCalculator;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.result.puce.PucesSpecificationsHandler;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.FileUtils;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.VisibleForTesting;

public final class DesktopPresenter {
    private final DesktopView _desktopView;
    private final Raid _raid;
    private final GlobalSettings _globalSettings;
    private final SportIdentPuceReaderInEquipePanel _sportIdentPuceReaderInEquipePanel;
    private final SportIdentPuceReaderInResultPanel _sportIdentPuceReaderInResultPanel;
    private boolean _modified = false;
    private boolean _sportIdentPuceReaderInUse = false;
    private String _lastOpenDirectory;

    DesktopPresenter(DesktopView desktopView) {
        this._desktopView = desktopView;
        this._globalSettings = new GlobalSettings();
        this._raid = new Raid();
        this._sportIdentPuceReaderInResultPanel = new SportIdentPuceReaderInResultPanel(this);
        this._sportIdentPuceReaderInEquipePanel = new SportIdentPuceReaderInEquipePanel(this._raid, this);
    }

    public JFrame getFrame() {
        return this._desktopView;
    }

    public Raid getRaid() {
        return this._raid;
    }

    public GlobalSettings getGlobalSettings() {
        return this._globalSettings;
    }

    public String getRaidFolderPath() {
        if (this._lastOpenDirectory == null) {
            return this._globalSettings.getWorkingDirectoryPath();
        }
        return this._lastOpenDirectory;
    }

    public void setLastOpenDirectory(File path) {
        this._lastOpenDirectory = path.isDirectory() ? path.getAbsolutePath() : path.getParent();
    }

    public JList<Equipe> getEquipeList() {
        return this._desktopView.getEquipeList();
    }

    public JComboBox<Parcours> getParcoursComboBox() {
        return this._desktopView.getParcoursComboBox();
    }

    public boolean getSportIdentPuceReaderInUse() {
        return this._sportIdentPuceReaderInUse;
    }

    public void setSportIdentPuceReaderInUse(boolean value) {
        this._sportIdentPuceReaderInUse = value;
    }

    public void setSportIdentPucePortName(String port) {
        this._sportIdentPuceReaderInEquipePanel.setPortName(port);
    }

    public boolean startSportIdentPuce() {
        return this._sportIdentPuceReaderInEquipePanel.start();
    }

    public void stopSportIdentPuce() {
        this._sportIdentPuceReaderInEquipePanel.stop();
    }

    public int saveCurrentRaidIfNeeded() {
        int choice = this._desktopView.savingCurrentRaidConfirmationDialog();
        if (choice == 0) {
            this.saveCurrentRaid();
        }
        return choice;
    }

    public void createNewRaidWithSavingConfirmation() {
        int choice = this.saveCurrentRaidIfNeeded();
        if (choice == 1 || choice == 0) {
            this._createNewRaid();
        }
    }

    public void openRaidFile() {
        int choice = this.saveCurrentRaidIfNeeded();
        if (choice == 1 || choice == 0) {
            try {
                this._desktopView.selectAndOpenRaidFile();
            }
            catch (Exception e) {
                DesktopView.beep();
                ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("desktop_presenter.error1", e.getMessage()));
            }
        }
    }

    public void update() {
        this._desktopView.update();
    }

    public void updateRaidPanel() {
        this._desktopView.refreshRaidPanel();
    }

    public boolean hasParcours() {
        return this.getParcoursComboBox().getItemCount() > 0;
    }

    public void saveCurrentRaid() {
        if (this._raid.getCurrentFilename().isEmpty()) {
            this.saveAsCurrentRaid();
        } else {
            File file = new File(this._raid.getCurrentFilename());
            if (file.exists()) {
                SavingTask task = new SavingTask(this._desktopView);
                task.execute();
                RaidXmlFileWriter.writeIntoRaidFile(this._raid, this._raid.getCurrentFilename());
                RecentProjectsFileHandler.addVisitedFileToRecentFiles(this._raid.getCurrentFilename());
                this._modified = false;
            } else {
                DesktopView.beep();
                ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("desktop_presenter.error2"));
            }
        }
    }

    public void saveAsCurrentRaid() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("grd_file.description"), "grd");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File(this._globalSettings.getWorkingDirectoryPath()));
        int returnVal = chooser.showSaveDialog(this._desktopView);
        if (returnVal == 0) {
            this._raid.setCurrentFilename(FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".grd"));
            RaidXmlFileWriter.writeIntoRaidFile(this._raid, this._raid.getCurrentFilename());
            this._modified = false;
            RecentProjectsFileHandler.addVisitedFileToRecentFiles(this._raid.getCurrentFilename());
            this._desktopView.update();
        }
    }

    public void backup() {
        String absoluteFilename = this._globalSettings.getBackupDirectoryPath() + File.separator + this._raid.getRaidName() + " " + DateTimeUtils.getLocaleDateTime() + ".grd";
        RaidXmlFileWriter.writeIntoRaidFile(this.getRaid(), absoluteFilename);
    }

    public void quit() {
        int choice = this.saveCurrentRaidIfNeeded();
        if (choice < 2) {
            this._desktopView.quit();
            System.exit(0);
        } else {
            this._desktopView.cancelQuit();
        }
    }

    public void initializeGlobalSettings() {
        this._globalSettings.setDefaultValues();
    }

    public boolean configureGlobalSettings() {
        AtomicBoolean isModified = new AtomicBoolean(false);
        GlobalSettingsDialog dialog = new GlobalSettingsDialog(this._desktopView, this, () -> isModified.set(true));
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
        return isModified.get();
    }

    public void configurePublicationSettings() {
        PublicationView dialog = new PublicationView(this, settings -> this.getGlobalSettings().getPublicationSettings().save((GlobalSettings.PublicationSettings)settings));
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void activateSportIdentButton(SportIdentPuceView panel, boolean isSportIdentReaderEnabled, int hours, int minutes, String portCom) {
        if (isSportIdentReaderEnabled) {
            this._desktopView.setEnabledPuceReaderButton(true);
            this._sportIdentPuceReaderInResultPanel.stop();
            panel.changeStateToStart();
        } else if (portCom != null) {
            this._sportIdentPuceReaderInResultPanel.setZeroTimeInMilliseconds(hours, minutes);
            this._sportIdentPuceReaderInResultPanel.setPortName(portCom);
            if (this._sportIdentPuceReaderInResultPanel.start()) {
                this._desktopView.setEnabledPuceReaderButton(false);
                panel.changeStateToWaitForInitialization();
            } else {
                panel.displayBadPortErrorMessage();
            }
        } else {
            panel.displayNoPortErrorMessage();
        }
    }

    public void setZeroHour(int hours) {
        this._raid.getHourZero().setHours(hours);
    }

    public void setZeroMinute(int minutes) {
        this._raid.getHourZero().setMinutes(minutes);
    }

    public void showSportIdentResulDialog(PuceResult result, boolean isSelectedEquipe, boolean isReadOnly, boolean isReducedResult) {
        SportIdentPuceResultDialog dialog = new SportIdentPuceResultDialog(this, result, isSelectedEquipe, isReadOnly, isReducedResult);
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }

    public boolean backupFolderExists() {
        File dossier = new File(this._globalSettings.getBackupDirectoryPath());
        return dossier.exists();
    }

    public void createEquipe(Equipe equipe, String name, String bib, String puces, boolean isNotClassified, boolean isAbsentOrAbandon, Categorie category, boolean checkPuceCompatibility, String phone) {
        ParcoursVariante variante;
        if (this.getRaid().notExistsPuceId(puces, equipe)) {
            variante = this._desktopView.getSelectedVariante();
            if (checkPuceCompatibility) {
                String[] puceIds = puces.trim().split(",");
                StringBuilder errorMessage = new StringBuilder();
                PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
                for (String puce1 : puceIds) {
                    if (!pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce1, variante, errorMessage)) continue;
                    throw new IllegalArgumentException(L10n.getString("equipe_editor.error2", puce1, errorMessage));
                }
            }
            equipe.setName(name);
            equipe.setBib(bib);
            equipe.setPuceIds(puces);
            equipe.setPhone(phone);
            equipe.setNotClassified(isNotClassified);
            equipe.setAbsent(isAbsentOrAbandon);
            equipe.setCategorie(category);
            if (!this.getRaid().addEquipe(variante, equipe)) {
                throw new IllegalArgumentException(L10n.getString("equipe_editor.error6"));
            }
        } else {
            throw new IllegalArgumentException(L10n.getString("equipe_editor.error7"));
        }
        this._desktopView.getEquipeList().setListData(variante.getEquipeVector().getEquipeVector());
        this._desktopView.getEquipeList().setSelectedValue(equipe, true);
    }

    public void modifyEquipe(Equipe equipe, String name, String bib, String puces, boolean isNotClassified, boolean isAbsentOrAbandon, Categorie category, boolean checkPuceCompatibility, String phone) {
        Parcours parcours;
        if (this.getRaid().notExistsPuceId(puces, equipe)) {
            JComboBox<Parcours> parcoursComboBox = this._desktopView.getParcoursComboBox();
            assert (parcoursComboBox.getSelectedItem() != null);
            parcours = (Parcours)parcoursComboBox.getSelectedItem();
            ParcoursVariante variante = parcours.getVarianteFromEquipe(equipe);
            if (checkPuceCompatibility) {
                String[] puceIds = puces.trim().split(",");
                StringBuilder errorMessage = new StringBuilder();
                PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
                for (String puce1 : puceIds) {
                    if (!pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce1, variante, errorMessage)) continue;
                    throw new IllegalArgumentException(L10n.getString("equipe_editor.error2", puce1, errorMessage));
                }
            }
            if (variante.getEquipeVector().existsAnotherEquipeWithSameBib(bib, equipe)) {
                throw new IllegalArgumentException(L10n.getString("equipe_editor.error6"));
            }
        } else {
            throw new IllegalArgumentException(L10n.getString("equipe_editor.error7"));
        }
        equipe.setName(name);
        equipe.setBib(bib);
        equipe.setPuceIds(puces);
        equipe.setPhone(phone);
        equipe.setNotClassified(isNotClassified);
        equipe.setAbsent(isAbsentOrAbandon);
        equipe.setCategorie(category);
        parcours.sortEquipes(this._desktopView.getCurrentSelectedType());
        this._desktopView.getEquipeList().repaint();
        this._desktopView.getEquipeList().setSelectedValue(equipe, true);
    }

    public void refreshResultTable() {
        this._desktopView.refreshResultTable();
    }

    public void addNewParcours(Parcours parcours) {
        this.getRaid().getParcoursVector().addParcours(parcours);
    }

    public Vector<Parcours> getParcoursList() {
        return this.getRaid().getParcoursVector().getParcoursVector();
    }

    public void updateTeamTotal(int numberOfEquipes) {
        this._desktopView.getEquipePanel().updateEquipeTotal(numberOfEquipes);
    }

    public MyComboBox<ParcoursVariante> getVarianteComboBox() {
        return this._desktopView.getVarianteComboBox();
    }

    public void setButtonEnabledIfNewReleaseAvailable(JMenu releaseMenuItem) {
        Thread t = new Thread(() -> this._displayNotificationIfNewReleaseAvailable(releaseMenuItem));
        t.start();
    }

    public ParcoursVariante getVariante(Equipe equipe) {
        JComboBox<Parcours> parcoursComboBox = this._desktopView.getParcoursComboBox();
        assert (parcoursComboBox.getSelectedItem() != null);
        Parcours selectedParcours = (Parcours)parcoursComboBox.getSelectedItem();
        ParcoursVariante variante = selectedParcours.getVarianteFromEquipe(equipe);
        if (variante == null) {
            return this._desktopView.getSelectedVariante();
        }
        return variante;
    }

    public void showSportIdentResulDialog(PuceResult result, boolean isSelectedEquipe, boolean isReadOnly) {
        this.showSportIdentResulDialog(result, isSelectedEquipe, isReadOnly, this._globalSettings.isShortIndividualResultPrinting());
    }

    public void displayStationStatus(SportIdentStationState status) {
        this._desktopView.displayStationStatus(status);
    }

    public void updateEquipes() {
        this._desktopView.updateEquipeList();
    }

    public void openRaidFileWithConfirmation(String filename) {
        int choice = this.saveCurrentRaidIfNeeded();
        if (choice < 2) {
            this.openRaidFile(filename);
        }
    }

    public void openRaidFile(String filename) {
        this.getRaid().resetData();
        this.getRaid().setCurrentFilename(filename);
        RaidFileXmlReader.readRaidFile(this.getRaid(), this.getRaid().getCurrentFilename(), this._globalSettings);
        RecentProjectsFileHandler.addVisitedFileToRecentFiles(filename);
        this._desktopView.fillCategoryComboBox();
        this._desktopView.refreshResultTable();
        this._desktopView.refreshRaidPanel();
        this._desktopView.refreshParcoursSelection(this.getRaid().getParcoursVector().getSize());
        this.setModified(false);
        this._desktopView.update();
    }

    public String[] getRecentRaidFiles() {
        return RecentProjectsFileHandler.getRecentFilePaths();
    }

    public void backupCurrentRaid() {
        if (this.backupFolderExists()) {
            BackupTask task = new BackupTask(this._desktopView);
            task.execute();
            this.backup();
        } else {
            DesktopView.beep();
            ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("desktop_presenter.error2"));
        }
    }

    public void openTimeCalculator() {
        TimeCalculator timeCalculator = new TimeCalculator();
        timeCalculator.setLocationRelativeTo(this._desktopView);
        timeCalculator.setVisible(true);
    }

    public void openQRCodeGenerator() {
        List<String> parcoursNames = this._getAllParcoursNames();
        QrCodeGenerator codeGenerator = new QrCodeGenerator(this._desktopView, this.getGlobalSettings(), this.getRaid().getRaidName(), parcoursNames);
        codeGenerator.setLocationRelativeTo(this._desktopView);
        codeGenerator.setVisible(true);
    }

    public boolean hasVariantes() {
        Parcours parcours = (Parcours)this.getParcoursComboBox().getSelectedItem();
        return parcours != null && parcours.hasVariantes();
    }

    boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean value) {
        this._modified = value;
    }

    void loadGlobalSettings() {
        PlatformSettingsHandler.loadGlobalSettings(this._globalSettings);
    }

    void displayRecentRaidFiles() {
        try {
            RecentProjectsFileHandler.updateRecentFiles();
            if (RecentProjectsFileHandler.getRecentFilePaths().length != 0) {
                int index = RecentFileDialog.showInputDialog(this._desktopView, L10n.getString("desktop_presenter.recent_raids"), RecentProjectsFileHandler.getFileNamesAndDateFromRecentProjectsFile(), L10n.getString("desktop_presenter.open_raid_button"), L10n.getString("desktop_presenter.new_raid_button"), L10n.getString("desktop_presenter.other_raid_button"));
                if (index >= 0) {
                    this.openRaidFile(RecentProjectsFileHandler.getRecentFilePaths()[index]);
                } else if (index == -1) {
                    this.createNewRaidWithSavingConfirmation();
                } else {
                    this._desktopView.selectAndOpenRaidFile();
                }
            } else {
                this._createNewRaid();
            }
        }
        catch (Exception e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("desktop_presenter.error1", e.getMessage()));
        }
    }

    @VisibleForTesting
    static String _extractVersionNumberFromTarballName(String tarballName) {
        return tarballName.split("-")[1];
    }

    private List<String> _getAllParcoursNames() {
        ArrayList<String> parcoursNames = new ArrayList<String>();
        for (Parcours parcours : this.getRaid().getParcoursVector().getParcoursVector()) {
            parcoursNames.add(parcours.getName());
        }
        return parcoursNames;
    }

    private void _createNewRaid() {
        this._raid.resetData();
        this._raid.setCategorieVector(this._globalSettings.getCategoriesTemplateCopy());
        this._raid.setRaidName(L10n.getString("desktop_presenter.new_raid"));
        this._desktopView.refreshRaidPanel();
        this._desktopView.update();
        this._desktopView.cleanResultTable();
        this.setModified(false);
    }

    private void _displayNotificationIfNewReleaseAvailable(JMenu releaseMenuItem) {
        String tarballName = DistributionServerGateway.getTarballName();
        if (tarballName != null) {
            final String versionNumber = DesktopPresenter._extractVersionNumberFromTarballName(tarballName);
            if (!tarballName.contains(GeRaidV3.SessionLauncher.getVersion())) {
                releaseMenuItem.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ReleaseDialog dialog = new ReleaseDialog(DesktopPresenter.this, versionNumber);
                        dialog.setLocationRelativeTo(DesktopPresenter.this._desktopView);
                        dialog.setVisible(true);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
                releaseMenuItem.setVisible(true);
            }
        }
    }
}

