/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.setting_menu.RecentProjectsFileHandler;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

@ExcludeFromJacocoGeneratedReport
final class RecentFileDialog {
    RecentFileDialog() {
    }

    static int showInputDialog(Frame parent, String title, String[][] namesAndDates, String openLabel, String cancelLabel, String otherLabel) {
        final GDialog dialog = new GDialog(parent, title, true);
        final AtomicReference<Integer> returnValue = new AtomicReference<Integer>(-1);
        String[] names = namesAndDates[0];
        String[] dates = namesAndDates[1];
        Object[] header = new String[]{"", ""};
        Object[][] donnees = new Object[names.length][2];
        for (int i = 0; i < names.length; ++i) {
            donnees[i][0] = names[i];
            donnees[i][1] = dates[i];
        }
        final DefaultTableModel tableModel = new DefaultTableModel(donnees, header){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        final JTable table = RecentFileDialog._createFileTable(tableModel);
        JButton openButton = RecentFileDialog._createOpenButton(openLabel, event -> {
            if (table.getSelectedRow() != -1) {
                returnValue.set(table.getSelectedRow());
            }
            dialog.dispose();
        });
        JButton cancelButton = RecentFileDialog._createCancelButton(cancelLabel, dialog, event -> {
            returnValue.set(-1);
            dialog.dispose();
        });
        ListSelectionModel cellSelectionModel = table.getSelectionModel();
        cellSelectionModel.setSelectionMode(0);
        cellSelectionModel.addListSelectionListener(e -> openButton.setEnabled(table.getSelectedRow() > -1));
        JPanel fileListPanel = new JPanel(new BorderLayout());
        fileListPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        fileListPanel.add((Component)table, "Center");
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = table.getSelectedRow();
                RecentProjectsFileHandler.removeFromRecentFiles(RecentProjectsFileHandler.getRecentFilePaths()[selectedIndex]);
                tableModel.removeRow(selectedIndex);
                tableModel.fireTableDataChanged();
            }
        };
        SwingUtils.addDeleteShortcut(table, deleteAction);
        JMenuItem deleteMenuItem = new JMenuItem(L10n.getString("recent_file_handler.delete_message"));
        deleteMenuItem.addActionListener(deleteAction);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(deleteMenuItem);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                    returnValue.set(table.getSelectedRow());
                    dialog.dispose();
                }
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && table.getSelectedRow() >= 0) {
                    popupMenu.show(table, e.getX(), e.getY());
                }
            }
        });
        JButton otherButton = RecentFileDialog._createOtherButton(otherLabel, event -> {
            returnValue.set(-2);
            dialog.dispose();
        });
        JPanel buttonContainer = new JPanel(new FlowLayout());
        buttonContainer.add(openButton);
        buttonContainer.add(cancelButton);
        buttonContainer.add(otherButton);
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)fileListPanel, "Center");
        container.add((Component)buttonContainer, "South");
        dialog.setContentPane(container);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return returnValue.get();
    }

    private static JButton _createCancelButton(String cancelLabel, GDialog dialog, ActionListener l) {
        JButton cancelButton = new JButton(cancelLabel);
        dialog.setCancelButton(cancelButton);
        cancelButton.addActionListener(l);
        return cancelButton;
    }

    private static JButton _createOtherButton(String cancelLabel, ActionListener l) {
        JButton otherButton = new JButton(cancelLabel);
        otherButton.addActionListener(l);
        return otherButton;
    }

    private static JTable _createFileTable(DefaultTableModel tableModel) {
        JTable table = new JTable();
        table.setModel(tableModel);
        table.setTableHeader(null);
        table.setBorder(BorderFactory.createEtchedBorder(0));
        table.setSelectionMode(0);
        RecentFileDialog._setFixedColumnWidth(table);
        return table;
    }

    private static void _setFixedColumnWidth(JTable table) {
        table.setAutoResizeMode(0);
        for (int column = 0; column < table.getColumnCount(); ++column) {
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            int maxWidth = tableColumn.getMaxWidth();
            int preferredWidth = tableColumn.getMinWidth();
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                Component c = table.prepareRenderer(cellRenderer, row, column);
                int width = c.getPreferredSize().width + table.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            tableColumn.setPreferredWidth(preferredWidth);
        }
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        table.getColumnModel().getColumn(1).setCellRenderer(rightRenderer);
    }

    private static JButton _createOpenButton(String openLabel, ActionListener l) {
        JButton openButton = new JButton(openLabel);
        openButton.setEnabled(false);
        openButton.addActionListener(l);
        return openButton;
    }
}

