/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

@ExcludeFromJacocoGeneratedReport
final class BibNumberingDialog
extends GDialog {
    private final transient Consumer<Object[]> _updateCallback;
    private JSpinner _bibNumberSpinner;
    private JTextField _prefixTextField;
    private JTextField _suffixTextField;

    public BibNumberingDialog(JFrame parent, Consumer<Object[]> updateCallback) {
        super(parent);
        this._updateCallback = updateCallback;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("bib_dialog.title"));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this._createContentPanel(), "North");
        contentPane.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPane);
        this.pack();
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel gridPanel = new JPanel(new GridLayout(0, 2, 3, 3));
        JLabel label1 = new JLabel(L10n.getString("bib_dialog.prefix"));
        label1.setHorizontalAlignment(4);
        gridPanel.add(label1);
        this._prefixTextField = new JTextField(8);
        gridPanel.add(this._prefixTextField);
        JLabel label2 = new JLabel(L10n.getString("bib_dialog.start_number"));
        label2.setHorizontalAlignment(4);
        gridPanel.add(label2);
        this._bibNumberSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10000, 1));
        gridPanel.add(this._bibNumberSpinner);
        JLabel label3 = new JLabel(L10n.getString("bib_dialog.suffix"));
        label3.setHorizontalAlignment(4);
        gridPanel.add(label3);
        this._suffixTextField = new JTextField(8);
        gridPanel.add(this._suffixTextField);
        panel.add(gridPanel);
        return panel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        JButton button = new JButton(L10n.getString("bib_dialog.validate_button"));
        button.addActionListener(event -> {
            String prefix = this._prefixTextField.getText().trim();
            int bibNumber = (Integer)this._bibNumberSpinner.getValue();
            String suffix = this._suffixTextField.getText().trim();
            this._updateCallback.accept(new Object[]{prefix, bibNumber, suffix});
            this.dispose();
        });
        this.setDefaultButton(button);
        return button;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

