/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

@ExcludeFromJacocoGeneratedReport
final class EquipeDisplacementDialog
extends GDialog {
    private final transient Consumer<ParcoursVariante> _updateCallback;
    private JComboBox<Parcours> _comboBoxParcours;
    private JComboBox<ParcoursVariante> _comboBoxVariante;
    private transient ParcoursVariante _destinationParcours;
    private JLabel _errorLabel;

    public EquipeDisplacementDialog(JFrame parent, DesktopPresenter presenter, List<Equipe> equipes, Consumer<ParcoursVariante> updateCallback) {
        super(parent);
        this._updateCallback = updateCallback;
        this._initializeUI(equipes.size());
        this._comboBoxParcours.addItemListener(event -> this._setDataVariante());
        this._comboBoxParcours.setModel(new DefaultComboBoxModel<Parcours>(presenter.getRaid().getParcoursVector().getParcoursVector()));
        if (this._comboBoxParcours.getSelectedIndex() != -1) {
            this._setDataVariante();
        }
        int existingResultsCounter = 0;
        for (Equipe equipe : equipes) {
            if (!presenter.getRaid().existsPuceResult(equipe)) continue;
            ++existingResultsCounter;
        }
        if (existingResultsCounter > 0) {
            DesktopView.beep();
            if (existingResultsCounter == 1) {
                this._errorLabel.setText(L10n.getString("equipe_displacement_singular_dialog.error1", existingResultsCounter));
            } else {
                this._errorLabel.setText(L10n.getString("equipe_displacement_plural_dialog.error1", existingResultsCounter));
            }
        }
        this.pack();
    }

    private void _setDataVariante() {
        assert (this._comboBoxParcours.getSelectedItem() != null);
        Parcours selectedParcours = (Parcours)this._comboBoxParcours.getSelectedItem();
        this._comboBoxVariante.setModel(new DefaultComboBoxModel<ParcoursVariante>(selectedParcours.getVarianteVector().getVarianteParcoursVector()));
        this._comboBoxVariante.setVisible(selectedParcours.hasVariantes() && this._comboBoxVariante.getItemCount() != 0);
    }

    private void _initializeUI(int size) {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(L10n.getString("equipe_displacement_dialog.title"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this._createContentPanel(size), "North");
        this._errorLabel = new JLabel("");
        this._errorLabel.setPreferredSize(new Dimension(215, 65));
        this._errorLabel.setForeground(Color.red);
        panel.add((Component)this._errorLabel, "Center");
        panel.add((Component)this._createButtonPanel(size), "South");
        this.setContentPane(panel);
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumSize(new Dimension(500, preferredSize.height));
    }

    private JComponent _createContentPanel(int size) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel titlePanel = new JPanel(new FlowLayout());
        if (size <= 1) {
            titlePanel.add(new JLabel(L10n.getString("equipe_displacement_singular_dialog.label")));
        } else {
            titlePanel.add(new JLabel(L10n.getString("equipe_displacement_plural_dialog.label")));
        }
        panel.add(titlePanel);
        JPanel equipeListPanel = new JPanel();
        equipeListPanel.setLayout(new BoxLayout(equipeListPanel, 0));
        equipeListPanel.add(this._getParcoursComboBox());
        equipeListPanel.add(this._getVarianteComboBox());
        panel.add(equipeListPanel);
        return panel;
    }

    private JComboBox<ParcoursVariante> _getVarianteComboBox() {
        this._comboBoxVariante = new JComboBox();
        return this._comboBoxVariante;
    }

    private JComboBox<Parcours> _getParcoursComboBox() {
        this._comboBoxParcours = new JComboBox();
        return this._comboBoxParcours;
    }

    private JPanel _createButtonPanel(int size) {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton(size));
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton(int size) {
        JButton button = new JButton(L10n.getString("equipe_displacement_singular_dialog.validate_button"));
        if (size <= 1) {
            button.setText(L10n.getString("equipe_displacement_singular_dialog.validate_button"));
        } else {
            button.setText(L10n.getString("equipe_displacement_plural_dialog.validate_button"));
        }
        button.addActionListener(event -> {
            if (this._comboBoxVariante.getSelectedItem() == null) {
                DesktopView.beep();
                this._errorLabel.setText(L10n.getString("equipe_displacement_dialog.error2"));
            } else {
                this._destinationParcours = (ParcoursVariante)this._comboBoxVariante.getSelectedItem();
                this._updateCallback.accept(this._destinationParcours);
                this.dispose();
            }
        });
        this.setDefaultButton(button);
        return button;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

