/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.equipe_panel.EquipePanelPresenter;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.equipe.BadFileContent;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVector;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import fr.geraidv3.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

@ExcludeFromJacocoGeneratedReport
final class EquipeImportDialog
extends GDialog {
    private static final String NO_FILE = "equipe_import_dialog.no_file_selected";
    private static final String CSV_DESCRIPTION = "csv_file.description";
    private final transient EquipePanelPresenter _presenter;
    private final transient ParcoursVector _parcoursVector;
    private final HashMap<String, Integer> _vacantEquipeVariante = new HashMap();
    private JButton _validateButton;
    private JTextField _equipeFileText;
    private JTextField _puceFileText;
    private JTextField _equipeAndPuceFileText;
    private JTabbedPane _tabs;
    private boolean _onePucePerEquipier = true;
    private JSpinner _pucesPerEquipeSpinner;

    EquipeImportDialog(JFrame parent, EquipePanelPresenter presenter, ParcoursVector parcoursVector) {
        super(parent);
        this._presenter = presenter;
        this._parcoursVector = parcoursVector;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("equipe_import_dialog.title"));
        this.setMinimumSize(new Dimension(500, 100));
        this.setContentPane(this._createContentPane());
        this.pack();
    }

    private void _updateValidateButtonState() {
        this._validateButton.setEnabled(!this._equipeFileText.getText().equals(L10n.getString(NO_FILE)) && !this._puceFileText.getText().equals(L10n.getString(NO_FILE)) && !this._puceFileText.getText().equals(this._equipeFileText.getText()) && this._tabs.getSelectedIndex() == 0 || !this._equipeAndPuceFileText.getText().equals(L10n.getString(NO_FILE)) && this._tabs.getSelectedIndex() == 1);
    }

    private JPanel _createContentPane() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._tabs = new JTabbedPane();
        this._tabs.add(L10n.getString("equipe_import_dialog.title_1"), this._createDualImportTab());
        this._tabs.add(L10n.getString("equipe_import_dialog.title_2"), this._createOneFileImportTab());
        this._tabs.addChangeListener(event -> this._updateValidateButtonState());
        pane.add((Component)this._tabs, "Center");
        pane.add((Component)this._createButtonPane(), "South");
        return pane;
    }

    private JPanel _createDualImportTab() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createEquipeImportPane());
        panel.add(this._createPuceImportPanel());
        panel.add(this._createPucesPerEquipePanel());
        JPanel importPanel = new JPanel(new BorderLayout());
        importPanel.add((Component)panel, "North");
        importPanel.add((Component)this._createVacantEquipePane(), "Center");
        return importPanel;
    }

    private JComponent _createPucesPerEquipePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_import_dialog.puce.title"), 4, 2));
        panel.setLayout(new BoxLayout(panel, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel panel1 = new JPanel(new FlowLayout(0));
        JRadioButton button1 = new JRadioButton(L10n.getString("parcours_editor.puce.button1.label"));
        button1.setToolTipText(L10n.getString("parcours_editor.puce.button1.tooltip"));
        button1.setSelected(true);
        button1.addItemListener(e -> {
            this._onePucePerEquipier = true;
        });
        panel1.add(button1);
        buttonGroup.add(button1);
        panel.add(panel1);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        JRadioButton button2 = new JRadioButton();
        panel2.add(button2);
        buttonGroup.add(button2);
        this._pucesPerEquipeSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 50, 1));
        this._pucesPerEquipeSpinner.addChangeListener(e -> button2.setSelected(true));
        this._pucesPerEquipeSpinner.setToolTipText(L10n.getString("parcours_editor.puce.button2.tooltip"));
        panel2.add(this._pucesPerEquipeSpinner);
        panel2.add(new JLabel(L10n.getString("parcours_editor.puce.button2.label")));
        button2.setToolTipText(L10n.getString("parcours_editor.puce.button2.tooltip"));
        button2.addItemListener(e -> {
            this._onePucePerEquipier = false;
        });
        panel.add(panel2);
        return panel;
    }

    private JPanel _createEquipeImportPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_import_dialog.import_equipe"), 4, 2));
        JPanel fileLoadingPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        fileLoadingPanel.add((Component)this._createEquipeFileText(), c);
        fileLoadingPanel.add(this._createImportEquipeButton());
        panel.add((Component)fileLoadingPanel, "Center");
        panel.add((Component)this._createEquipeCsvFileExampleButton(), "South");
        return panel;
    }

    private JPanel _createPuceImportPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_import_dialog.import_puce"), 4, 2));
        JPanel fileLoadingPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        fileLoadingPanel.add((Component)this._createPuceFileText(), constraints);
        fileLoadingPanel.add(this._createImportPuceButton());
        panel.add((Component)fileLoadingPanel, "Center");
        panel.add((Component)this._createPuceCsvFileExampleButton(), "South");
        return panel;
    }

    private JTextField _createEquipeAndPuceFileText() {
        this._equipeAndPuceFileText = new JTextField(L10n.getString(NO_FILE));
        this._equipeAndPuceFileText.setToolTipText(L10n.getString("equipe_import_dialog.help_equipe", L10n.getString("csv_equipe_helper.csv_export_equipe_header")));
        this._equipeAndPuceFileText.setBackground(Color.white);
        this._equipeAndPuceFileText.setEditable(false);
        return this._equipeAndPuceFileText;
    }

    private JButton _createImportEquipeAndPuceFileButton() {
        JButton button = new JButton(L10n.getString("browse"));
        button.setToolTipText(L10n.getString("equipe_import_dialog.help_equipe", L10n.getString("csv_equipe_helper.csv_export_equipe_header")));
        button.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser(this._presenter.getRaidFolderPath());
            chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString(CSV_DESCRIPTION), "csv"));
            chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
            int returnVal = chooser.showOpenDialog(this.getRootPane());
            if (returnVal == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                this._presenter.setLastOpenDirectory(chooser.getSelectedFile());
                this._equipeAndPuceFileText.setText(filename);
            } else {
                this._equipeAndPuceFileText.setText(L10n.getString(NO_FILE));
            }
            this._updateValidateButtonState();
        });
        return button;
    }

    private JPanel _createOneFileImportTab() {
        JPanel importLine = new JPanel(new BorderLayout());
        importLine.setBorder(new EmptyBorder(10, 5, 5, 0));
        importLine.add((Component)this._createImportEquipeAndPuceFileButton(), "East");
        importLine.add((Component)this._createEquipeAndPuceFileText(), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_import_dialog.import_all"), 4, 2));
        panel.add((Component)importLine, "North");
        return panel;
    }

    private JScrollPane _createVacantEquipePane() {
        JPanel vacantEquipePane = new JPanel();
        vacantEquipePane.setLayout(new BoxLayout(vacantEquipePane, 1));
        vacantEquipePane.setMaximumSize(new Dimension(25, 25));
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                vacantEquipePane.add(this._createVariantePane(parcours.getName(), variante.getName()));
            }
        }
        JScrollPane scrollPane = new JScrollPane(vacantEquipePane);
        scrollPane.setBorder(new TitledBorder(null, L10n.getString("equipe_import_dialog.parcours_title"), 4, 2));
        return scrollPane;
    }

    private JPanel _createVariantePane(String parcoursName, String varianteName) {
        JPanel variantePane = new JPanel();
        variantePane.setLayout(new FlowLayout(0));
        this._vacantEquipeVariante.putIfAbsent(varianteName, 0);
        JLabel varianteNameLabel = new JLabel(L10n.getString("equipe_import_dialog.variante") + " " + parcoursName + " (" + varianteName + ")");
        variantePane.add(varianteNameLabel);
        variantePane.add(this._createVarianteSpinner(varianteName));
        return variantePane;
    }

    private JSpinner _createVarianteSpinner(String name) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        spinner.addChangeListener(event -> this._vacantEquipeVariante.replace(name, (int)((Integer)spinner.getValue())));
        return spinner;
    }

    private JTextField _createPuceFileText() {
        this._puceFileText = new JTextField(L10n.getString(NO_FILE));
        this._puceFileText.setBackground(Color.white);
        this._puceFileText.setToolTipText(L10n.getString("equipe_import_dialog.help_puce"));
        this._puceFileText.setEditable(false);
        return this._puceFileText;
    }

    private JButton _createImportPuceButton() {
        JButton importPuceButton = new JButton(L10n.getString("browse"));
        importPuceButton.setToolTipText(L10n.getString("equipe_import_dialog.help_puce"));
        importPuceButton.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString(CSV_DESCRIPTION), "csv"));
            chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
            int returnVal = chooser.showOpenDialog(this.getRootPane());
            if (returnVal == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                this._puceFileText.setText(filename);
            } else {
                this._puceFileText.setText(L10n.getString(NO_FILE));
            }
            this._updateValidateButtonState();
        });
        return importPuceButton;
    }

    private JPanel _createEquipeCsvFileExampleButton() {
        JPanel panel = new JPanel();
        JLabel hyperlink = new JLabel(L10n.getString("equipe_import_dialog.model_label"));
        hyperlink.setToolTipText(L10n.getString("equipe_import_dialog.help_equipe", L10n.getString("csv_equipe_helper.csv_export_equipe_header")));
        hyperlink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString(EquipeImportDialog.CSV_DESCRIPTION), "csv"));
                chooser.setCurrentDirectory(new File(EquipeImportDialog.this._presenter.getRaidFolderPath()));
                int returnVal = chooser.showSaveDialog(EquipeImportDialog.this.getRootPane());
                if (returnVal == 0) {
                    String filename = FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".csv");
                    File file = new File(filename);
                    int option = 0;
                    if (file.exists()) {
                        option = JOptionPane.showConfirmDialog(EquipeImportDialog.this.getRootPane(), L10n.getString("confirm_file_overwrite", filename), L10n.getString("confirmation_title"), 0, 2);
                    }
                    if (option == 0) {
                        EquipeImportDialog.this._presenter.exportEquipeCsvTemplate(filename);
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        panel.add(hyperlink);
        return panel;
    }

    private JPanel _createPuceCsvFileExampleButton() {
        JPanel panel = new JPanel();
        JLabel hyperlink = new JLabel(L10n.getString("equipe_import_dialog.model_label"));
        hyperlink.setToolTipText(L10n.getString("equipe_import_dialog.help_puce"));
        hyperlink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString(EquipeImportDialog.CSV_DESCRIPTION), "csv"));
                chooser.setCurrentDirectory(new File(EquipeImportDialog.this._presenter.getRaidFolderPath()));
                int returnVal = chooser.showSaveDialog(EquipeImportDialog.this.getRootPane());
                if (returnVal == 0) {
                    String filename = FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".csv");
                    File file = new File(filename);
                    int option = 0;
                    if (file.exists()) {
                        option = JOptionPane.showConfirmDialog(EquipeImportDialog.this.getRootPane(), L10n.getString("confirm_file_overwrite", filename), L10n.getString("confirmation_title"), 0, 2);
                    }
                    if (option == 0) {
                        EquipeImportDialog.this._presenter.exportPuceCsvTemplate(filename);
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        panel.add(hyperlink);
        return panel;
    }

    private JTextField _createEquipeFileText() {
        this._equipeFileText = new JTextField(L10n.getString(NO_FILE));
        this._equipeFileText.setBackground(Color.white);
        this._equipeFileText.setEditable(false);
        this._equipeFileText.setToolTipText(L10n.getString("equipe_import_dialog.help_equipe", L10n.getString("csv_equipe_helper.csv_export_equipe_header")));
        return this._equipeFileText;
    }

    private JButton _createImportEquipeButton() {
        JButton importEquipeButton = new JButton(L10n.getString("browse"));
        importEquipeButton.setToolTipText(L10n.getString("equipe_import_dialog.help_equipe", L10n.getString("csv_equipe_helper.csv_export_equipe_header")));
        importEquipeButton.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser(this._presenter.getRaidFolderPath());
            chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString(CSV_DESCRIPTION), "csv"));
            chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
            int returnVal = chooser.showOpenDialog(this.getRootPane());
            if (returnVal == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                this._presenter.setLastOpenDirectory(chooser.getSelectedFile());
                this._equipeFileText.setText(filename);
            } else {
                this._equipeFileText.setText(L10n.getString(NO_FILE));
            }
            this._updateValidateButtonState();
        });
        return importEquipeButton;
    }

    private JPanel _createButtonPane() {
        JPanel buttonPane = new JPanel(new FlowLayout(1, 50, 0));
        buttonPane.setBorder(new EmptyBorder(8, 0, 5, 0));
        buttonPane.add(this._createValidateButton());
        buttonPane.add(this._createCancelButton());
        return buttonPane;
    }

    private JButton _createValidateButton() {
        this._validateButton = new JButton(L10n.getString("validate"));
        this._validateButton.setEnabled(false);
        this._validateButton.addActionListener(event -> {
            try {
                if (this._tabs.getSelectedIndex() == 1) {
                    this._presenter.importEquipeFile(this._equipeAndPuceFileText.getText());
                } else {
                    int numberOfPucesPerEquipe = this._onePucePerEquipier ? 0 : (Integer)this._pucesPerEquipeSpinner.getValue();
                    this._presenter.importEquipeWithPuceFiles(this._equipeFileText.getText(), this._puceFileText.getText(), this._vacantEquipeVariante, numberOfPucesPerEquipe);
                }
                this._presenter.resetParcoursVarianteComboBox();
                this.dispose();
            }
            catch (BadFileContent | IOException exception) {
                ErrorPane.showMessageDialog(this.rootPane, exception.getMessage());
            }
        });
        return this._validateButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

