/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

@ExcludeFromJacocoGeneratedReport
final class EquipeListCellRenderer
extends JLabel
implements ListCellRenderer<Equipe> {
    private final DesktopView _parent;

    EquipeListCellRenderer(DesktopView parent) {
        this.setOpaque(true);
        this._parent = parent;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Equipe> list, Equipe equipe, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setForeground(this._copyColor(list.getSelectionForeground()));
            this.setBackground(this._copyColor(list.getSelectionBackground()));
        } else {
            this.setBackground(this._copyColor(list.getBackground()));
            this.setForeground(this._copyColor(list.getForeground()));
        }
        this.setText(equipe.toString());
        if (equipe.isNotClassified()) {
            this.setFont(this.getFont().deriveFont(2));
        } else if (equipe.isAbsent()) {
            this.setFont(this.getFont().deriveFont(2));
            if (!isSelected) {
                this.setForeground(LookAndFeelTheme.ABSENCE_COLOR);
            }
        } else if (equipe.isArrived((Parcours)this._parent.getParcoursComboBox().getSelectedItem(), this._parent.getSelectedEtape())) {
            this.setFont(list.getFont());
        } else {
            this.setFont(this.getFont().deriveFont(1));
        }
        this.setEnabled(list.isEnabled());
        return this;
    }

    private Color _copyColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }
}

