/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import com.formdev.flatlaf.ui.FlatLineBorder;
import fr.geraidv3.L10n;
import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.equipe_panel.EquipeListCellRenderer;
import fr.geraidv3.desktop.equipe_panel.EquipePanelPresenter;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import fr.geraidv3.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

@ExcludeFromJacocoGeneratedReport
public final class EquipePanelView
extends JPanel
implements StatefulComponent {
    private final transient EquipePanelPresenter _presenter;
    private final JList<Equipe> _equipeList;
    private final JPopupMenu _popupMenu = new JPopupMenu();
    private JLabel _teamCounterLabel;
    private JButton _addButton;
    private JButton _editTeamButton;
    private JButton _deleteButton;
    private JButton _exportEquipesButton;
    private JButton _importEquipesButton;
    private JButton _moveEquipesButton;
    private JButton _sortEquipesButton;
    private JButton _numberBibsButton;

    public EquipePanelView(DesktopView parent, DesktopPresenter presenter, JList<Equipe> equipeList) {
        super(new BorderLayout());
        this._equipeList = equipeList;
        this._presenter = new EquipePanelPresenter(this, presenter, parent, equipeList);
        this._initializeUI(parent, equipeList);
    }

    @Override
    public void update(DesktopPresenter presenter) {
        boolean hasParcours = presenter.hasParcours();
        int numberOfVariantes = presenter.getVarianteComboBox().getModel().getSize();
        boolean isVarianteSelected = presenter.getVarianteComboBox().getSelectedItemIndex() > -1;
        this._addButton.setEnabled(hasParcours && (isVarianteSelected || numberOfVariantes == 1));
        boolean hasEquipe = this._presenter.hasEquipes();
        this._editTeamButton.setEnabled(hasParcours && hasEquipe);
        this._deleteButton.setEnabled(hasParcours && hasEquipe);
        this._exportEquipesButton.setEnabled(hasParcours && hasEquipe);
        this._importEquipesButton.setEnabled(hasParcours);
        this._moveEquipesButton.setEnabled(hasParcours && hasEquipe);
        this._sortEquipesButton.setEnabled(hasParcours && hasEquipe);
        this._numberBibsButton.setEnabled(hasParcours && hasEquipe);
    }

    public void setEnabledPuceReaderButton(boolean value) {
    }

    public void readSportIdentPuce() {
        this._presenter.readSportIdentPuce();
    }

    public void changePuceReaderIcon(String iconFilename) {
    }

    public void updateEquipeTotal(int number) {
        if (number > 1) {
            this._teamCounterLabel.setText(String.format(L10n.getString("equipe_panel.equipe_count_plural", number), new Object[0]));
        } else {
            this._teamCounterLabel.setText(String.format(L10n.getString("equipe_panel.equipe_count_singular", number), new Object[0]));
        }
    }

    public void searchEquipe() {
        this._presenter.searchEquipe();
    }

    private void _initializeUI(DesktopView parent, JList<Equipe> equipeList) {
        this.setBorder(new TitledBorder(null, L10n.getString("equipe_panel.title"), 4, 2));
        this.setMinimumSize(new Dimension(450, 100));
        this.add((Component)this._createButtonPanel(), "North");
        this.add((Component)this._createTable(parent, equipeList), "Center");
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createTeamCounterPanel());
        panel.add(this._createAddTeamButton());
        panel.add(this._createEditTeamButton());
        panel.add(this._createDeleteTeamButton());
        panel.add(this._createSearchButton());
        panel.add(this._createMoveEquipesButton());
        panel.add(this._createNumberBibsButton());
        panel.add(this._createSortTeamButton());
        panel.add(this._createImportTeamsButton());
        panel.add(this._createExportEquipesButton());
        return panel;
    }

    private JButton _createImportTeamsButton() {
        this._importEquipesButton = new IconButton("import-csv-24.png");
        this._importEquipesButton.setToolTipText(L10n.getString("equipe_panel.import_csv.tooltip"));
        this._importEquipesButton.addActionListener(event -> this._presenter.createEquipeImportDialog());
        return this._importEquipesButton;
    }

    private JButton _createExportEquipesButton() {
        this._exportEquipesButton = new IconButton("export-csv-24.png");
        this._exportEquipesButton.setToolTipText(L10n.getString("equipe_panel.export_csv.tooltip"));
        this._exportEquipesButton.addActionListener(event -> {
            if (this._equipeList.getModel().getSize() > 0) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv"));
                chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
                int returnVal = chooser.showSaveDialog(this.getRootPane());
                if (returnVal == 0) {
                    String filename = FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".csv");
                    this._presenter.exportEquipes(filename);
                }
            }
        });
        return this._exportEquipesButton;
    }

    private JButton _createSearchButton() {
        IconButton searchButton = new IconButton("search-24.png");
        searchButton.setToolTipText(L10n.getString("equipe_panel.chip.tooltip"));
        searchButton.addActionListener(event -> this._presenter.searchEquipe());
        return searchButton;
    }

    private JButton _createNumberBibsButton() {
        this._numberBibsButton = new IconButton("bib-24.png");
        this._numberBibsButton.setToolTipText(L10n.getString("equipe_panel.bib_numbering.tooltip"));
        this._numberBibsButton.addActionListener(event -> {
            if (this._equipeList.getModel().getSize() > 0) {
                this._presenter.numberAllBibs();
            }
        });
        return this._numberBibsButton;
    }

    private JButton _createSortTeamButton() {
        this._sortEquipesButton = new IconButton("sorting-24.png");
        this._sortEquipesButton.addActionListener(event -> {
            if (this._equipeList.getModel().getSize() > 0) {
                this._presenter.sortEquipes();
            }
        });
        this._sortEquipesButton.setToolTipText(L10n.getString("equipe_panel.sort.tooltip"));
        return this._sortEquipesButton;
    }

    private JButton _createMoveEquipesButton() {
        this._moveEquipesButton = new IconButton("move-24.png");
        this._moveEquipesButton.setToolTipText(L10n.getString("equipe_panel.move.tooltip"));
        this._moveEquipesButton.addActionListener(event -> {
            List<Equipe> equipes = this._equipeList.getSelectedValuesList();
            this._presenter.moveEquipesToAnotherParcours(equipes);
        });
        return this._moveEquipesButton;
    }

    private JComponent _createTeamCounterPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(LookAndFeelTheme.ACCENT_COLOR);
        panel.setBorder((Border)new FlatLineBorder(new Insets(0, 0, 0, 0), LookAndFeelTheme.ACCENT_COLOR, 0.0f, 15));
        this._teamCounterLabel = new JLabel();
        this._teamCounterLabel.setForeground(Color.WHITE);
        this.updateEquipeTotal(0);
        panel.add(this._teamCounterLabel);
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.width = 100;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JButton _createAddTeamButton() {
        this._addButton = new IconButton("add-24.png");
        this._addButton.setToolTipText(L10n.getString("equipe_panel.add.tooltip"));
        this._addButton.addActionListener(event -> this._presenter.addEquipe());
        return this._addButton;
    }

    private JButton _createEditTeamButton() {
        this._editTeamButton = new IconButton("edit-24.png");
        this._editTeamButton.setToolTipText(L10n.getString("equipe_panel.modify.tooltip"));
        this._editTeamButton.addActionListener(event -> {
            if (this._equipeList.getSelectedIndex() != -1) {
                this._presenter.editCurrentSelectedEquipe(this._equipeList.getSelectedValue());
            }
        });
        return this._editTeamButton;
    }

    private JButton _createDeleteTeamButton() {
        this._deleteButton = new IconButton("delete-24.png");
        this._deleteButton.setToolTipText(L10n.getString("equipe_panel.delete.tooltip"));
        this._deleteButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EquipePanelView.this._deleteEquipes();
            }
        });
        return this._deleteButton;
    }

    private void _deleteEquipes() {
        if (this._equipeList.getModel().getSize() > 0 && this._equipeList.getSelectedIndex() > -1) {
            List<Equipe> equipes = this._equipeList.getSelectedValuesList();
            this._presenter.deleteCurrentSelectedEquipes(equipes);
        }
    }

    private JScrollPane _createTable(DesktopView parent, JList<Equipe> equipeList) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(this._createTeamList(parent, equipeList));
        return scrollPane;
    }

    private void _createPopupMenu(Equipe equipe) {
        if (this._popupMenu.getComponentCount() > 0) {
            this._popupMenu.removeAll();
        }
        JMenuItem menuItem = new JMenuItem(L10n.getString("result_view.popup_menu_label3"));
        menuItem.addActionListener(event -> {
            this._popupMenu.setVisible(false);
            this._presenter.displaySportIdentPuceResults(equipe);
        });
        this._popupMenu.add(menuItem);
    }

    private JList<Equipe> _createTeamList(DesktopView parent, final JList<Equipe> equipeList) {
        equipeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                EquipePanelView.this._popupMenu.setVisible(false);
                if (event.getClickCount() > 1) {
                    Equipe equipe = EquipePanelView.this._equipeList.getSelectedValue();
                    EquipePanelView.this._presenter.editCurrentSelectedEquipe(equipe);
                } else if (event.getButton() == 3) {
                    EquipePanelView.this._equipeList.setSelectedIndex(EquipePanelView.this._equipeList.locationToIndex(event.getPoint()));
                    Equipe equipe = EquipePanelView.this._equipeList.getSelectedValue();
                    if (EquipePanelView.this._presenter.hasResult(equipe)) {
                        EquipePanelView.this._createPopupMenu(equipe);
                        EquipePanelView.this._popupMenu.setLocation(event.getXOnScreen(), event.getYOnScreen());
                        EquipePanelView.this._popupMenu.setVisible(true);
                        equipeList.requestFocusInWindow();
                        equipeList.requestFocus();
                    }
                }
            }
        });
        SwingUtils.addDeleteShortcut(equipeList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EquipePanelView.this._deleteEquipes();
            }
        });
        equipeList.setMinimumSize(new Dimension(450, 0));
        equipeList.setSelectionMode(2);
        equipeList.setCellRenderer(new EquipeListCellRenderer(parent));
        equipeList.setFocusable(true);
        equipeList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EquipePanelView.this._popupMenu.setVisible(false);
            }
        });
        return equipeList;
    }
}

