/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.file_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

@ExcludeFromJacocoGeneratedReport
public final class FileMenu
extends JMenu {
    private final transient DesktopPresenter _presenter;

    public FileMenu(DesktopPresenter presenter) {
        super(L10n.getString("desktop.menu.file.title"));
        this._presenter = presenter;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.add(this._createMenuItemNewFile());
        this.add(this._createMenuItemOpenFile());
        this.add(this._createMenuItemRecentFiles());
        this.add(new JSeparator());
        this.add(this._createMenuItemSaveInFile());
        this.add(this._createMenuItemSaveAsInFile());
        this.add(this._createMenuItemBackup());
        this.add(new JSeparator());
        this.add(this._createMenuItemQuit());
    }

    private JMenuItem _createMenuItemNewFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.new"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        menuItem.addActionListener(event -> this._presenter.createNewRaidWithSavingConfirmation());
        return menuItem;
    }

    private JMenuItem _createMenuItemOpenFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.open"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menuItem.addActionListener(event -> this._presenter.openRaidFile());
        return menuItem;
    }

    private JMenuItem _createMenuItemRecentFiles() {
        JMenu menu = new JMenu(L10n.getString("desktop.menu.file.recent_files"));
        menu.removeAll();
        String[] recentRaidFiles = this._presenter.getRecentRaidFiles();
        if (recentRaidFiles.length == 0) {
            menu.setEnabled(false);
        } else {
            for (int i = 0; i < recentRaidFiles.length; ++i) {
                final String filename = recentRaidFiles[i];
                AbstractAction action = new AbstractAction(i + 1 + " " + filename){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        FileMenu.this._presenter.openRaidFileWithConfirmation(filename);
                    }
                };
                JMenuItem item = new JMenuItem(action);
                menu.add(item);
            }
            menu.setEnabled(true);
        }
        return menu;
    }

    private JMenuItem _createMenuItemSaveInFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.save"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        menuItem.addActionListener(event -> this._presenter.saveCurrentRaid());
        return menuItem;
    }

    private JMenuItem _createMenuItemSaveAsInFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.save_as"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        menuItem.addActionListener(event -> this._presenter.saveAsCurrentRaid());
        return menuItem;
    }

    private JMenuItem _createMenuItemBackup() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.backup"));
        menuItem.addActionListener(event -> this._presenter.backupCurrentRaid());
        return menuItem;
    }

    private JMenuItem _createMenuItemQuit() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.file.quit"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        menuItem.addActionListener(event -> this._presenter.quit());
        return menuItem;
    }
}

