/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.file_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.file_panel.FilePanelPresenter;
import fr.geraidv3.desktop.file_panel.FrequencyDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Color;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

@ExcludeFromJacocoGeneratedReport
public final class FilePanelView
extends JPanel
implements StatefulComponent {
    private final transient FilePanelPresenter _presenter;
    private JButton _saveButton;
    private JButton _backupButton;
    private int _backupFrequencyInMn = 1;
    private JButton _startBackupButton;

    public FilePanelView(DesktopPresenter desktopPresenter) {
        this._presenter = new FilePanelPresenter(this, desktopPresenter);
        this._initializeUI();
    }

    public void setSavingOkState() {
        this._saveButton.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/success-24.png")));
    }

    public void setSavingNormalState() {
        this._saveButton.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/save-24.png")));
    }

    @Override
    public void update(DesktopPresenter presenter) {
    }

    public void setBackupOkState() {
        this._backupButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/success-24.png")));
    }

    void setBackupNotOkState() {
        this._backupButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/error-24.png")));
    }

    public void setBackupNormalState() {
        this._backupButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/backup-24.png")));
    }

    int getBackupFrequencyInMn() {
        return this._backupFrequencyInMn;
    }

    void startBackupButton() {
        this._startBackupButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/stop-backup-24.png")));
        this._startBackupButton.setToolTipText(L10n.getString("file_panel.backup.stop"));
    }

    void stopBackupButton() {
        this._startBackupButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/start-backup-24.png")));
        this._startBackupButton.setToolTipText(L10n.getString("file_panel.backup.start"));
    }

    boolean chooseFrequencyDialog() {
        FrequencyDialog frequencyDialog = new FrequencyDialog((JFrame)this.getRootPane().getParent(), this._backupFrequencyInMn);
        int frequency = frequencyDialog.showDialog();
        if (frequency > 0) {
            this._backupFrequencyInMn = frequency;
            return true;
        }
        return false;
    }

    private void _initializeUI() {
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 10, 10, 10);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        LineBorder lineBorder = new LineBorder(Color.LIGHT_GRAY, 1, false);
        panel.setBorder(BorderFactory.createCompoundBorder(lineBorder, emptyBorder));
        panel.add(this._createNewFileButton());
        panel.add(this._createOpenFileButton());
        panel.add(this._createSaveFileButton());
        panel.add(new JSeparator());
        panel.add(this._createBackupButton());
        panel.add(this._createStartBackupButton());
        panel.add(new JSeparator());
        panel.add(this._createExportToCsvButton());
        this.add(panel);
    }

    private JButton _createNewFileButton() {
        IconButton button = new IconButton("new-24.png");
        button.setToolTipText(L10n.getString("file_panel.new"));
        button.addActionListener(event -> this._presenter.createNewRaidFile());
        return button;
    }

    private JButton _createOpenFileButton() {
        IconButton button = new IconButton("open-24.png");
        button.setToolTipText(L10n.getString("file_panel.open"));
        button.addActionListener(event -> this._presenter.openRaidFile());
        return button;
    }

    private JButton _createSaveFileButton() {
        this._saveButton = new IconButton("save-24.png");
        this._saveButton.setToolTipText(L10n.getString("file_panel.save"));
        this._saveButton.addActionListener(event -> this._presenter.saveCurrentRaid());
        return this._saveButton;
    }

    private JButton _createBackupButton() {
        this._backupButton = new IconButton("backup-24.png");
        this._backupButton.setToolTipText(L10n.getString("file_panel.backup"));
        this._backupButton.addActionListener(event -> this._presenter.backupCurrentRaid());
        return this._backupButton;
    }

    private JButton _createExportToCsvButton() {
        IconButton button = new IconButton("export-csv-24.png");
        button.setToolTipText(L10n.getString("file_panel.export.tooltip"));
        button.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
            chooser.setFileFilter(filter);
            chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this._presenter.exportToCsv(chooser.getSelectedFile().getAbsolutePath());
            }
        });
        return button;
    }

    private JButton _createStartBackupButton() {
        this._startBackupButton = new IconButton("start-backup-24.png");
        this._startBackupButton.setToolTipText(L10n.getString("file_panel.backup.tooltip"));
        this._startBackupButton.addActionListener(action -> this._presenter.startOrStopBackup());
        return this._startBackupButton;
    }
}

