/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

@ExcludeFromJacocoGeneratedReport
final class BaliseReplacementDialog
extends GDialog {
    private final transient BiConsumer<Integer, Integer> _updateCallback;
    private JSpinner _oldSpinner;
    private JSpinner _newSpinner;

    BaliseReplacementDialog(JFrame parent, BiConsumer<Integer, Integer> updateCallback) {
        super(parent);
        this._updateCallback = updateCallback;
        this.setModal(true);
        this.setTitle(L10n.getString("global_balise_replacement.title"));
        this._initializeUI();
    }

    private void _initializeUI() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)this._createOldAndNewPanel(), "Center");
        contentPanel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPanel);
        this.pack();
    }

    private JPanel _createOldAndNewPanel() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 1;
        c1.anchor = 17;
        c1.weightx = 0.0;
        c1.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)new JLabel(L10n.getString("global_balise_replacement.old_label")), c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.gridy = 1;
        c2.weightx = 1.0;
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 5);
        this._oldSpinner = this._createSpinner();
        contentPanel.add((Component)this._oldSpinner, c2);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 2;
        c3.anchor = 17;
        c3.weightx = 0.0;
        c3.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)new JLabel(L10n.getString("global_balise_replacement.new_label")), c3);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridx = 1;
        c4.gridy = 2;
        c4.weightx = 1.0;
        c4.fill = 2;
        c4.insets = new Insets(5, 5, 5, 5);
        this._newSpinner = this._createSpinner();
        contentPanel.add((Component)this._newSpinner, c4);
        return contentPanel;
    }

    private JSpinner _createSpinner() {
        SpinnerNumberModel model = new SpinnerNumberModel(31, 31, 500, 1);
        return new JSpinner(model);
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        JButton button = new JButton(L10n.getString("global_balise_replacement.validate"));
        button.addActionListener(event -> {
            int newCode;
            int oldCode = (Integer)this._oldSpinner.getValue();
            if (oldCode != (newCode = ((Integer)this._newSpinner.getValue()).intValue())) {
                this._updateCallback.accept(oldCode, newCode);
            }
            this.dispose();
        });
        this.setDefaultButton(button);
        return button;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

