/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_menu.InvalidCsvDataException;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.result.puce.PuceResultVector;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public final class CsvPuceResult {
    private CsvPuceResult() {
    }

    static void exportToFile(PuceResultVector puceResults, String absoluteFilename) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String header = L10n.getString("csv_puce_result_header");
            writer.write(header);
            writer.write(System.lineSeparator());
            List<PuceResult> puceResultVector = puceResults.getPuceResultVector();
            for (PuceResult puceResult : puceResultVector) {
                String text = puceResult.toCSV();
                writer.write(text);
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_puce_result_error1", e.getClass().getName(), e.getMessage()));
        }
    }

    static void importFromFile(Raid raid, String filename) throws IOException, ParseException, InvalidCsvDataException {
        File file = new File(filename);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            int lineCounter = 1;
            String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            while ((line = reader.readLine()) != null) {
                String[] rowTextParts = line.trim().split(delimiter);
                PuceResult puceResult = new PuceResult();
                Parcours parcours = raid.getParcoursVector().getParcoursFromName(rowTextParts[0]);
                if (parcours == null) {
                    throw new InvalidCsvDataException(L10n.getString("csv_puce_result_import_error0", rowTextParts[0]), lineCounter);
                }
                puceResult.setParcours(parcours);
                puceResult.setEtape(parcours.getEtape(rowTextParts[1]));
                String puceId = rowTextParts[5];
                Equipe equipe = parcours.getEquipeFromPuceId(puceId);
                String bib = rowTextParts[2];
                if (!bib.equals(equipe.getBib())) {
                    throw new InvalidCsvDataException(L10n.getString("csv_puce_result_import_error1", bib, equipe.getBib()), lineCounter);
                }
                puceResult.setEquipe(equipe);
                String equipeName = rowTextParts[3];
                if (!equipeName.equalsIgnoreCase(equipe.getName())) {
                    throw new InvalidCsvDataException(L10n.getString("csv_puce_result_import_error2", equipeName, equipe.getBib()), lineCounter);
                }
                String category = rowTextParts[4];
                if (!category.equalsIgnoreCase(equipe.getCategorie().getShortName())) {
                    throw new InvalidCsvDataException(L10n.getString("csv_puce_result_import_error3", category, equipe.getBib()), lineCounter);
                }
                puceResult.getPuce().setId(puceId);
                puceResult.getPuce().setStartTime(DateTimeUtils.parseLocalTime(rowTextParts[6]));
                puceResult.getPuce().setFinishTime(DateTimeUtils.parseLocalTime(rowTextParts[7]));
                boolean puceBelongToEquipe = CsvPuceResult._doesPuceBelongToEquipe(equipe, puceResult.getPuce().getId());
                if (!puceBelongToEquipe) {
                    throw new InvalidCsvDataException(L10n.getString("csv_puce_result_import_error4", puceResult.getPuce().getId(), equipe.getBib()), lineCounter);
                }
                ArrayList<Partiel> partiels = new ArrayList<Partiel>();
                for (int i = 0; i < (rowTextParts.length - 8) / 2; ++i) {
                    Partiel partiel = new Partiel(Integer.parseInt(rowTextParts[8 + i * 2]), DateTimeUtils.parseLocalTime(rowTextParts[9 + i * 2]));
                    partiels.add(partiel);
                }
                puceResult.getPuce().setPartiels(partiels);
                raid.addOrReplacePuceResult(puceResult);
            }
        }
    }

    private static boolean _doesPuceBelongToEquipe(Equipe equipe, String puceId) {
        for (String puceId1 : equipe.getPuceIds()) {
            if (!puceId1.equals(puceId)) continue;
            return true;
        }
        return false;
    }
}

