/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.model.Raid;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import javax.swing.table.AbstractTableModel;

final class PenaliteTableModel
extends AbstractTableModel {
    private final String[] _columnNames;
    private final transient Object[][] _data;

    PenaliteTableModel(Raid raid, Parcours parcours, Etape etape) {
        this._columnNames = raid.getResultColumnNameHeaders(etape);
        this._data = raid.getPenalitesIndividuellesAsTable(parcours, etape);
    }

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this._data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this._columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this._data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this._data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    String getHeaderAsCsv() {
        StringBuilder csvText = new StringBuilder();
        csvText.append(this._columnNames[0]);
        for (int i = 1; i < this._columnNames.length; ++i) {
            csvText.append(";").append(this._columnNames[i]);
        }
        return csvText.toString();
    }

    String[] getDataCSV() {
        String[] csvText = new String[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            StringBuilder row = new StringBuilder(this.getValueAt(i, 0).toString());
            for (int j = 1; j < this.getColumnCount(); ++j) {
                row.append(";").append(this.getValueAt(i, j));
            }
            csvText[i] = row.toString();
        }
        return csvText;
    }
}

