/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.raid_menu.CsvPenaltyHelper;
import fr.geraidv3.desktop.raid_menu.IndividualPenaltyEditor;
import fr.geraidv3.desktop.raid_menu.PenaliteTableModel;
import fr.geraidv3.desktop.raid_menu.PenaltyEditor;
import fr.geraidv3.desktop.raid_menu.RaidMenuPresenter;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import fr.geraidv3.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@ExcludeFromJacocoGeneratedReport
final class PenaltiesManagementDialog
extends GDialog {
    private final transient DesktopPresenter _desktopPresenter;
    private final transient RaidMenuPresenter _raidMenuPresenter;
    private JTable _table;
    private JComboBox<Parcours> _parcoursComboBox;
    private JComboBox<Etape> _etapesComboBox;
    private JButton _editPenaliteButton;
    private JButton _addPenaltyButton;
    private JButton _editPenaltyButton;
    private JButton _deletePenaliteButton;
    private JButton _exportPenalitesButton;

    PenaltiesManagementDialog(JFrame parent, RaidMenuPresenter raidMenuPresenter, DesktopPresenter desktopPresenter) {
        super(parent);
        this._desktopPresenter = desktopPresenter;
        this._raidMenuPresenter = raidMenuPresenter;
        this._initializeUI();
        this._initialiseData();
        this._updateButton();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PenaltiesManagementDialog.class.getClassLoader().getResource("fr/geraidv3/icon/logo32.png")));
        this.setTitle(L10n.getString("penalty_management_dialog.title"));
        this.setMinimumSize(new Dimension(750, 400));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.add(this._createGlobalPanel());
        contentPane.add(this._createPenaliteIndividualButtonPanel());
        contentPane.add(this._createTeamListPanel());
        this.setContentPane(contentPane);
        this.pack();
    }

    private JPanel _createGlobalPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("penalty_management_dialog.global_panel.title"), 4, 2));
        panel.add(new JLabel(L10n.getString("penalty_management_dialog.global_panel.label1")));
        panel.add(this._createParcoursComboBox());
        panel.add(new JLabel(L10n.getString("penalty_management_dialog.global_panel.label2")));
        panel.add(this._createEtapesComboBox());
        panel.add(this._createAddPenaliteButton());
        panel.add(this._createEditPenaliteButton());
        panel.add(this._createDeletePenaliteButton());
        panel.add(this._createImportPenaltyButton());
        panel.add(this._createExportPenalitesButton());
        return panel;
    }

    private JButton _createAddPenaliteButton() {
        this._addPenaltyButton = new IconButton("add-24.png");
        this._addPenaltyButton.setToolTipText(L10n.getString("penalty_management_dialog.global_panel.button_add"));
        this._addPenaltyButton.addActionListener(event -> {
            if (this._etapesComboBox.getSelectedIndex() > -1) {
                Penalite penalty = new Penalite();
                penalty.setParcours((Parcours)this._parcoursComboBox.getSelectedItem());
                penalty.setEtape((Etape)this._etapesComboBox.getSelectedItem());
                PenaltyEditor editor = new PenaltyEditor(this, this._raidMenuPresenter, penalty, this::_refreshTable, true);
                this._desktopPresenter.setModified(true);
                editor.setLocationRelativeTo(null);
                editor.setVisible(true);
            }
        });
        return this._addPenaltyButton;
    }

    private JButton _createEditPenaliteButton() {
        this._editPenaltyButton = new IconButton("edit-24.png");
        this._editPenaltyButton.setToolTipText(L10n.getString("penalty_management_dialog.global_panel.button_edit"));
        this._editPenaltyButton.addActionListener(event -> {
            if (this._table.getSelectedColumn() > 2) {
                int index = this._getSelectedColumnIndex();
                Penalite penalty = this._desktopPresenter.getRaid().getPenalite((Etape)this._etapesComboBox.getSelectedItem(), index);
                PenaltyEditor editor = new PenaltyEditor(this, this._raidMenuPresenter, penalty, this::_refreshTable, false);
                this._desktopPresenter.setModified(true);
                editor.setLocationRelativeTo(null);
                editor.setVisible(true);
            }
        });
        return this._editPenaltyButton;
    }

    private JButton _createDeletePenaliteButton() {
        this._deletePenaliteButton = new IconButton("delete-24.png");
        this._deletePenaliteButton.setToolTipText(L10n.getString("penalty_management_dialog.global_panel.button_delete"));
        this._deletePenaliteButton.addActionListener(event -> this._deletePenalite());
        return this._deletePenaliteButton;
    }

    private void _deletePenalite() {
        if (this._table.getSelectedColumn() > 2) {
            int answer;
            int index = this._getSelectedColumnIndex();
            Penalite penalite = this._desktopPresenter.getRaid().getPenalite((Etape)this._etapesComboBox.getSelectedItem(), index);
            if (penalite != null && (answer = JOptionPane.showConfirmDialog(this.rootPane, L10n.getString("penalty_management_dialog.global_panel.delete.message", penalite.getName()), L10n.getString("penalty_management_dialog.global_panel.delete.title"), 0, 3)) == 0) {
                this._desktopPresenter.getRaid().getPenaliteVector().remove(penalite);
                this._refreshTable();
                this._desktopPresenter.setModified(true);
            }
        }
    }

    private JButton _createImportPenaltyButton() {
        IconButton button = new IconButton("import-csv-24.png");
        button.setToolTipText(L10n.getString("penalty_management_dialog.global_panel.tooltip_import_penalty"));
        button.addActionListener(event -> {
            if (this._etapesComboBox.getSelectedIndex() > -1) {
                JFileChooser chooser = new JFileChooser(this._desktopPresenter.getRaidFolderPath());
                FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    String filename = chooser.getSelectedFile().getAbsolutePath();
                    this._desktopPresenter.setLastOpenDirectory(chooser.getSelectedFile());
                    CsvPenaltyHelper.importAsCsv(this._raidMenuPresenter, (Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), filename);
                    this._refreshTable();
                    this._desktopPresenter.setModified(true);
                }
            }
        });
        return button;
    }

    private JButton _createExportPenalitesButton() {
        this._exportPenalitesButton = new IconButton("export-csv-24.png");
        this._exportPenalitesButton.setToolTipText(L10n.getString("penalty_management_dialog.global_panel.tooltip_export_penalty"));
        this._exportPenalitesButton.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser(this._desktopPresenter.getRaidFolderPath());
            FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                String filename = FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".csv");
                this._desktopPresenter.setLastOpenDirectory(chooser.getSelectedFile());
                CsvPenaltyHelper.exportPenalties((PenaliteTableModel)this._table.getModel(), filename);
            }
        });
        return this._exportPenalitesButton;
    }

    private JComboBox<Etape> _createEtapesComboBox() {
        this._etapesComboBox = new JComboBox();
        this._etapesComboBox.addItemListener(event -> this._refreshTable());
        return this._etapesComboBox;
    }

    private JComboBox<Parcours> _createParcoursComboBox() {
        this._parcoursComboBox = new JComboBox();
        this._parcoursComboBox.addItemListener(event -> {
            if (this._parcoursComboBox.getSelectedIndex() != -1) {
                assert (this._parcoursComboBox.getSelectedItem() != null);
                this._etapesComboBox.setModel(new DefaultComboBoxModel<Etape>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector()));
                this._etapesComboBox.repaint();
                if (this._etapesComboBox.getItemCount() > 0) {
                    this._etapesComboBox.setSelectedIndex(0);
                } else {
                    this._etapesComboBox.setSelectedIndex(-1);
                }
            } else {
                this._etapesComboBox.removeAllItems();
                this._etapesComboBox.repaint();
                this._etapesComboBox.setSelectedIndex(-1);
            }
            this._refreshTable();
        });
        return this._parcoursComboBox;
    }

    private JPanel _createPenaliteIndividualButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("penalty_management_dialog.individual_panel.title"), 4, 2));
        this._editPenaliteButton = new IconButton("edit-24.png");
        this._editPenaliteButton.setToolTipText(L10n.getString("penalty_management_dialog.individual_panel.edit.tooltip"));
        this._editPenaliteButton.addActionListener(event -> this._openIndividualPenaltyEditor());
        panel.add(this._editPenaliteButton);
        return panel;
    }

    private JPanel _createTeamListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this._table = new JTable(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return super.getScrollableTracksViewportWidth() && this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                PenaltiesManagementDialog.this._updateButton();
                if (event.getClickCount() > 1 && event.getButton() == 1) {
                    PenaltiesManagementDialog.this._openIndividualPenaltyEditor();
                }
            }
        });
        this._table.setAutoResizeMode(4);
        this._table.setSelectionMode(0);
        this._table.getTableHeader().setBackground(Color.BLACK);
        this._table.getTableHeader().setForeground(Color.WHITE);
        Font font = this._table.getTableHeader().getFont();
        this._table.getTableHeader().setFont(font.deriveFont(12.0f));
        this._table.setRowSelectionAllowed(false);
        this._table.setCellSelectionEnabled(true);
        this._table.setFocusable(true);
        this._table.getTableHeader().setReorderingAllowed(false);
        SwingUtils.addDeleteShortcut(this._table, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PenaltiesManagementDialog.this._deletePenalite();
            }
        });
        scrollPane.setViewportView(this._table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void _openIndividualPenaltyEditor() {
        if (this._table.getSelectedColumn() > 2 && !((String)this._table.getValueAt(this._table.getSelectedRow(), 2)).isEmpty()) {
            boolean isACreation = ((String)this._table.getValueAt(this._table.getSelectedRow(), this._table.getSelectedColumn())).isEmpty();
            IndividualPenaltyEditor editor = new IndividualPenaltyEditor(this, this._getSelectedIndividualPenalties(), individualPenalties -> {
                this._addIndividualPenalties((List<PenaliteIndividuelle>)individualPenalties);
                this._refreshTable();
            }, isACreation);
            editor.setLocationRelativeTo(null);
            editor.setVisible(true);
        }
    }

    private void _initialiseData() {
        if (this._desktopPresenter.getRaid().getParcoursVector().getSize() > 0) {
            this._parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(this._desktopPresenter.getRaid().getParcoursVector().getParcoursVector()));
            assert (this._parcoursComboBox.getSelectedItem() != null);
            this._etapesComboBox.setModel(new DefaultComboBoxModel<Etape>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector()));
            this._etapesComboBox.repaint();
            if (this._etapesComboBox.getItemCount() > 0) {
                this._etapesComboBox.setSelectedIndex(0);
            } else {
                this._etapesComboBox.setSelectedIndex(-1);
            }
            this._refreshTable();
        }
    }

    private void _updateButton() {
        this._addPenaltyButton.setEnabled(this._etapesComboBox.getSelectedIndex() > -1);
        boolean isPenaltyColumnSelected = this._table.getSelectedColumn() > 2;
        this._editPenaltyButton.setEnabled(isPenaltyColumnSelected);
        this._deletePenaliteButton.setEnabled(isPenaltyColumnSelected);
        this._exportPenalitesButton.setEnabled(this._table.getModel().getRowCount() > 0);
        boolean isAPenaltySelected = isPenaltyColumnSelected && !((String)this._table.getValueAt(this._table.getSelectedRow(), 2)).isEmpty();
        this._editPenaliteButton.setEnabled(isAPenaltySelected);
    }

    private void _addIndividualPenalties(List<PenaliteIndividuelle> individualPenalties) {
        Raid raid = this._desktopPresenter.getRaid();
        for (PenaliteIndividuelle p : individualPenalties) {
            Penalite penalite = raid.getPenalite((Etape)this._etapesComboBox.getSelectedItem(), this._getSelectedColumnIndex());
            if (penalite == null) continue;
            penalite.addPenaliteIndividuelle(p);
        }
    }

    private void _refreshTable() {
        this._table.setModel(new PenaliteTableModel(this._desktopPresenter.getRaid(), (Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem()));
        this._updateTableColumnModel();
        this._updateButton();
    }

    private int _getSelectedColumnIndex() {
        int index = this._table.getSelectedColumn() - 3;
        index = index % 2 == 1 ? (index - 1) / 2 : (index /= 2);
        return index;
    }

    private PenaliteIndividuelle[] _getSelectedIndividualPenalties() {
        PenaliteIndividuelle[] selected = new PenaliteIndividuelle[this._table.getSelectedRowCount()];
        int[] selectedRowIndexes = this._table.getSelectedRows();
        for (int i = 0; i < selectedRowIndexes.length; ++i) {
            PenaliteIndividuelle penalty = new PenaliteIndividuelle();
            penalty.setPuceIds((String)this._table.getValueAt(selectedRowIndexes[i], 2));
            PenaliteIndividuelle selectedPenalty = this._desktopPresenter.getRaid().getPenaliteIndividuelle((Etape)this._etapesComboBox.getSelectedItem(), this._getSelectedColumnIndex(), (String)this._table.getValueAt(selectedRowIndexes[i], 2));
            if (selectedPenalty != null) {
                penalty.setPoints(selectedPenalty.getPoints());
                penalty.setTimeIns(selectedPenalty.getTimeInS());
            }
            selected[i] = penalty;
        }
        return selected;
    }

    private void _updateTableColumnModel() {
        int i;
        DefaultTableCellRenderer rightCellRender = new DefaultTableCellRenderer();
        rightCellRender.setHorizontalAlignment(0);
        TableColumnModel columnModel = this._table.getColumnModel();
        for (i = 0; i < columnModel.getColumnCount(); ++i) {
            if (i == 3) continue;
            columnModel.getColumn(i).setCellRenderer(rightCellRender);
        }
        for (i = 0; i < this._table.getColumnCount(); ++i) {
            TableColumn tableColumn = this._table.getColumnModel().getColumn(i);
            int preferredWidth = tableColumn.getPreferredWidth();
            int maxWidth = tableColumn.getMaxWidth();
            for (int row = 0; row < this._table.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = this._table.getCellRenderer(row, i);
                Component c = this._table.prepareRenderer(cellRenderer, row, i);
                int width = c.getPreferredSize().width + this._table.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            tableColumn.setPreferredWidth((int)((double)preferredWidth * 1.2));
        }
    }
}

