/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.PuceResultManagementDialog;
import fr.geraidv3.desktop.raid_menu.BaliseReplacementDialog;
import fr.geraidv3.desktop.raid_menu.BaliseSwappingDialog;
import fr.geraidv3.desktop.raid_menu.CsvPuceResult;
import fr.geraidv3.desktop.raid_menu.HtmlViewer;
import fr.geraidv3.desktop.raid_menu.InvalidCsvDataException;
import fr.geraidv3.desktop.raid_menu.PenaltiesManagementDialog;
import fr.geraidv3.desktop.raid_menu.RaidSettingsDialog;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.CategorieVector;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.utils.FileUtils;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

final class RaidMenuPresenter {
    final DesktopPresenter _desktopPresenter;
    final DesktopView _desktopView;

    RaidMenuPresenter(DesktopPresenter desktopPresenter, DesktopView desktopView) {
        this._desktopPresenter = desktopPresenter;
        this._desktopView = desktopView;
    }

    void addPenalty(Penalite penalite) {
        this._desktopPresenter.getRaid().getPenaliteVector().add(penalite);
    }

    void displayRaidSummary() {
        String htmlText = this._desktopPresenter.getRaid().exportAllParcoursAsHTML();
        HtmlViewer frame = new HtmlViewer(this._desktopPresenter, htmlText);
        frame.setLocationRelativeTo(null);
        frame.setLocationRelativeTo(this._desktopView.getParent());
        frame.setVisible(true);
    }

    void searchEquipe() {
        this._desktopView.getEquipePanel().searchEquipe();
    }

    void managePenalties() {
        PenaltiesManagementDialog dialog = new PenaltiesManagementDialog(this._desktopView, this, this._desktopPresenter);
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }

    void configureRaid() {
        RaidSettingsDialog dialog = new RaidSettingsDialog(this._desktopView, this, () -> {
            this._desktopView.repaintEquipeList();
            this._desktopView.update();
        });
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }

    void managePuceResults() {
        if (this._desktopPresenter.getRaid().getPuceResultVector().getSize() > 0) {
            PuceResultManagementDialog dialog = new PuceResultManagementDialog(this._desktopView, this._desktopPresenter);
            dialog.setLocationRelativeTo(this._desktopView);
            dialog.setVisible(true);
        }
    }

    void exportResultToCsvFile() {
        JFileChooser chooser = new JFileChooser(this._desktopPresenter.getRaidFolderPath());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
        chooser.setFileFilter(filter);
        int returnValue = chooser.showSaveDialog(this._desktopView);
        if (returnValue == 0) {
            String filename = FileUtils.checkExtension(chooser.getSelectedFile().getAbsolutePath(), ".csv");
            this._desktopPresenter.setLastOpenDirectory(chooser.getSelectedFile());
            CsvPuceResult.exportToFile(this._desktopPresenter.getRaid().getPuceResultVector(), filename);
        }
    }

    void importResultFromCsvFile() {
        JFileChooser chooser = new JFileChooser(this._desktopPresenter.getRaidFolderPath());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
        chooser.setFileFilter(filter);
        int returnValue = chooser.showOpenDialog(this._desktopView);
        if (returnValue == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this._desktopPresenter.setLastOpenDirectory(chooser.getSelectedFile());
            try {
                CsvPuceResult.importFromFile(this._desktopPresenter.getRaid(), filename);
            }
            catch (InvalidCsvDataException | IOException | ParseException e) {
                DesktopView.beep();
                ErrorPane.showMessageDialog(this._desktopView, L10n.getString("csv_puce_result_error2", e.getMessage()));
            }
            this._desktopView.refreshResultTable();
        }
    }

    String getRaidName() {
        return this._desktopPresenter.getRaid().getRaidName();
    }

    void setRaidName(String name) {
        this._desktopPresenter.getRaid().setRaidName(name);
    }

    CategorieVector getCategories() {
        return this._desktopPresenter.getRaid().getCategorieVector();
    }

    void setCategories(CategorieVector categories) {
        this._desktopPresenter.getRaid().setCategorieVector(categories);
    }

    String getPageHeader() {
        return this._desktopPresenter.getRaid().getPrintHeader();
    }

    void setPageHeader(String text) {
        this._desktopPresenter.getRaid().setPrintHeader(text);
    }

    String getPageFooter() {
        return this._desktopPresenter.getRaid().getPrintFooter();
    }

    void setPageFooter(String text) {
        this._desktopPresenter.getRaid().setPrintFooter(text);
    }

    void replaceBalises() {
        BaliseReplacementDialog dialog = new BaliseReplacementDialog(this._desktopView, (oldCode, newCode) -> {
            Raid raid = this._desktopPresenter.getRaid();
            raid.replaceBalise((Integer)oldCode, (Integer)newCode);
            this._desktopView.getBaliseList().repaint();
        });
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }

    void swapTwoBalises() {
        BaliseSwappingDialog dialog = new BaliseSwappingDialog(this._desktopView, (code1, code2) -> {
            Raid raid = this._desktopPresenter.getRaid();
            raid.swapBalises((Integer)code1, (Integer)code2);
            this._desktopView.getBaliseList().repaint();
        });
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }
}

