/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

@ExcludeFromJacocoGeneratedReport
public final class BaliseEditor
extends GDialog {
    private final transient Balise _balise;
    private final transient Consumer<Balise> _okUpdateCallback;
    private final boolean _isCreation;
    private final boolean _reducedView;
    private transient Runnable _removeCallback;
    private JLabel _codeLabel;
    private JSpinner _codeSpinner;
    private JSpinner _punchPointsSpinner;
    private JSpinner _punchHourSpinner;
    private JSpinner _punchMinutesSpinner;
    private JSpinner _punchSecondSpinner;
    private JRadioButton _punchBonusRadioButton;
    private JRadioButton _punchPenaltyRadioButton;
    private JSpinner _mispunchPointsSpinner;
    private JSpinner _mispunchHourSpinner;
    private JSpinner _mispunchMinuteSpinner;
    private JSpinner _mispunchSecondSpinner;
    private JRadioButton _mispunchBonusRadioButton;
    private JRadioButton _mispunchPenaltyRadioButton;

    public BaliseEditor(JFrame parent, Balise balise, Consumer<Balise> updateCallback, boolean isCreation, boolean reducedView) {
        super(parent);
        this._balise = balise;
        this._okUpdateCallback = updateCallback;
        this._reducedView = reducedView;
        this._isCreation = isCreation;
        this._initializeUI();
        this.setAlwaysOnTop(true);
        this._initializeData();
    }

    public BaliseEditor(JDialog parent, Balise balise, Consumer<Balise> updateCallback, Runnable removeCallback, boolean isCreation, boolean reducedView) {
        super(parent);
        this._balise = balise;
        this._okUpdateCallback = updateCallback;
        this._removeCallback = removeCallback;
        this._reducedView = reducedView;
        this._isCreation = isCreation;
        this._initializeUI();
        this._initializeData();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this._createContentPane());
        this.setTitle(L10n.getString(this._isCreation ? "balise_editor.title1" : "balise_editor.title2"));
        this.pack();
        if (this._reducedView) {
            this._codeLabel.setVisible(false);
            this._codeSpinner.setVisible(false);
        }
    }

    private void _initializeData() {
        this._codeSpinner.setValue(this._balise.getNumber());
        this._punchPointsSpinner.setValue(Math.abs(this._balise.getPunchPointsBonus()));
        this._mispunchPointsSpinner.setValue(Math.abs(this._balise.getMispunchPointsPenalty()));
        this._initializeBonusAndPenalty();
        this._initTimes();
    }

    private void _initializeBonusAndPenalty() {
        boolean punchBonus = this._balise.getPunchPointsBonus() >= 0 && this._balise.getPunchTimeBonusInS() <= 0;
        this._punchBonusRadioButton.setSelected(punchBonus);
        this._punchPenaltyRadioButton.setSelected(!punchBonus);
        boolean mispunchBonus = this._balise.getMispunchPointsPenalty() > 0 || this._balise.getMispunchTimePenaltyInS() < 0;
        this._mispunchBonusRadioButton.setSelected(mispunchBonus);
        this._mispunchPenaltyRadioButton.setSelected(!mispunchBonus);
    }

    private void _initTimes() {
        int punchHours = (int)Math.floor((double)Math.abs(this._balise.getPunchTimeBonusInS()) / 3600.0);
        int punchMinutes = (int)Math.floor(((double)Math.abs(this._balise.getPunchTimeBonusInS()) - (double)punchHours * 3600.0) / 60.0);
        int punchSeconds = Math.abs(this._balise.getPunchTimeBonusInS()) - punchHours * 3600 - punchMinutes * 60;
        this._punchHourSpinner.setValue(punchHours);
        this._punchMinutesSpinner.setValue(punchMinutes);
        this._punchSecondSpinner.setValue(punchSeconds);
        int mispunchHours = (int)Math.floor((double)Math.abs(this._balise.getMispunchTimePenaltyInS()) / 3600.0);
        int mispunchMinutes = (int)Math.floor(((double)Math.abs(this._balise.getMispunchTimePenaltyInS()) - (double)mispunchHours * 3600.0) / 60.0);
        int mispunchSeconds = Math.abs(this._balise.getMispunchTimePenaltyInS()) - mispunchHours * 3600 - mispunchMinutes * 60;
        this._mispunchHourSpinner.setValue(mispunchHours);
        this._mispunchMinuteSpinner.setValue(mispunchMinutes);
        this._mispunchSecondSpinner.setValue(mispunchSeconds);
    }

    private JPanel _createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._createContentPanel(), "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        return panel;
    }

    private JComponent _createBaliseCodeTextField() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._codeLabel = new JLabel(L10n.getString("balise_editor.code"));
        panel.add(this._codeLabel);
        this._codeSpinner = new JSpinner(new SpinnerNumberModel(31, 31, 10000, 1));
        panel.add(this._codeSpinner);
        return panel;
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this._createBaliseCodeTextField());
        panel.add(this._createPointsWhenPunchCheckpointPanel());
        panel.add(this._createPointsWhenMispunchCheckpointPanel());
        return panel;
    }

    private JPanel _createPointsWhenPunchCheckpointPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("balise_editor.panel.checked_control"), 4, 2));
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this._createPunchBonusRadioButton());
        panel1.add(this._createPunchPenaltyRadioButton());
        panel.add(panel1);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this._createPunchPointPanel());
        panel.add(panel2);
        JPanel panel3 = new JPanel(new FlowLayout(0));
        panel3.add(this._createPunchTimePanel());
        panel.add(panel3);
        ButtonGroup group = new ButtonGroup();
        group.add(this._punchBonusRadioButton);
        group.add(this._punchPenaltyRadioButton);
        return panel;
    }

    private JSpinner _createPunchPointSpinner() {
        this._punchPointsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        return this._punchPointsSpinner;
    }

    private JPanel _createPointsWhenMispunchCheckpointPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("balise_editor.panel.miss_control"), 4, 2));
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this._createMispunchBonusRadioButton());
        panel1.add(this._createMispunchPenaltyRadioButton());
        panel.add(panel1);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this._createMispunchPointPanel());
        panel.add(panel2);
        JPanel panel3 = new JPanel(new FlowLayout(0));
        panel3.add(this._createMispunchTimePanel());
        panel.add(panel3);
        ButtonGroup group = new ButtonGroup();
        group.add(this._mispunchBonusRadioButton);
        group.add(this._mispunchPenaltyRadioButton);
        return panel;
    }

    private JPanel _createMispunchPointPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new JLabel(L10n.getString("balise_editor.miss_control.points")));
        panel.add(this._mispunchPointSpinner());
        return panel;
    }

    private JPanel _createPunchPointPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new JLabel(L10n.getString("balise_editor.checked_control.points")));
        panel.add(this._createPunchPointSpinner());
        return panel;
    }

    private JRadioButton _createPunchBonusRadioButton() {
        this._punchBonusRadioButton = new JRadioButton(L10n.getString("balise_editor.checked_control.bonus"));
        return this._punchBonusRadioButton;
    }

    private JSpinner _mispunchPointSpinner() {
        this._mispunchPointsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        return this._mispunchPointsSpinner;
    }

    private JSpinner _createMispunchHourSpinner() {
        this._mispunchHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 12, 1));
        return this._mispunchHourSpinner;
    }

    private JSpinner _createMispunchMinuteSpinner() {
        this._mispunchMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._mispunchMinuteSpinner;
    }

    private JSpinner _createMispunchSecondSpinner() {
        this._mispunchSecondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._mispunchSecondSpinner;
    }

    private JRadioButton _createMispunchBonusRadioButton() {
        this._mispunchBonusRadioButton = new JRadioButton();
        this._mispunchBonusRadioButton.setText(L10n.getString("balise_editor.mis_control.bonus"));
        return this._mispunchBonusRadioButton;
    }

    private JRadioButton _createMispunchPenaltyRadioButton() {
        this._mispunchPenaltyRadioButton = new JRadioButton();
        this._mispunchPenaltyRadioButton.setText(L10n.getString("balise_editor.miss_control.penalty"));
        return this._mispunchPenaltyRadioButton;
    }

    private JPanel _createPunchTimePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("balise_editor.checked_control.time")));
        panel.add(this._createPunchHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createPunchMinuteSpinner());
        panel.add(new JLabel(" " + L10n.getString("minute_abbreviation")));
        panel.add(this._createPunchSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JSpinner _createPunchHourSpinner() {
        this._punchHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 12, 1));
        return this._punchHourSpinner;
    }

    private JSpinner _createPunchMinuteSpinner() {
        this._punchMinutesSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._punchMinutesSpinner;
    }

    private JSpinner _createPunchSecondSpinner() {
        this._punchSecondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._punchSecondSpinner;
    }

    private JRadioButton _createPunchPenaltyRadioButton() {
        this._punchPenaltyRadioButton = new JRadioButton(L10n.getString("balise_editor.checked_control.penalty"));
        return this._punchPenaltyRadioButton;
    }

    private JPanel _createMispunchTimePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("balise_editor.miss_control.time")));
        panel.add(this._createMispunchHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createMispunchMinuteSpinner());
        panel.add(new JLabel(" " + L10n.getString("minute_abbreviation")));
        panel.add(this._createMispunchSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        if (this._removeCallback != null) {
            panel.add(this._createRemoveButton());
        }
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createRemoveButton() {
        JButton button = new JButton(L10n.getString("balise_editor.remove_button"));
        button.setToolTipText(L10n.getString("balise_editor.remove_tooltip"));
        button.addActionListener(event -> {
            this._removeCallback.run();
            this.dispose();
        });
        return button;
    }

    private JButton _createValidateButton() {
        JButton button = new JButton(L10n.getString(this._isCreation ? "balise_editor.validate_button1" : "balise_editor.validate_button2"));
        button.addActionListener(event -> {
            int codeNumber = (Integer)this._codeSpinner.getValue();
            this._balise.setNumber(codeNumber);
            if (this._punchBonusRadioButton.isSelected()) {
                this._balise.setPunchPointsBonus((Integer)this._punchPointsSpinner.getValue());
            } else {
                this._balise.setPunchPointsBonus(-((Integer)this._punchPointsSpinner.getValue()).intValue());
            }
            this._balise.setPunchTimeBonusInS(this._getPunchTimeInS());
            if (this._mispunchBonusRadioButton.isSelected()) {
                this._balise.setMispunchPointsPenalty((Integer)this._mispunchPointsSpinner.getValue());
            } else {
                this._balise.setMispunchPointsPenalty(-((Integer)this._mispunchPointsSpinner.getValue()).intValue());
            }
            this._balise.setMispunchTimePenaltyInS(this._getMispunchTimeInS());
            this._okUpdateCallback.accept(this._balise);
            this.dispose();
        });
        this.setDefaultButton(button);
        return button;
    }

    private int _getPunchTimeInS() {
        int time = (Integer)this._punchHourSpinner.getValue() * 3600 + (Integer)this._punchMinutesSpinner.getValue() * 60 + (Integer)this._punchSecondSpinner.getValue();
        if (this._punchBonusRadioButton.isSelected()) {
            time *= -1;
        }
        return time;
    }

    private int _getMispunchTimeInS() {
        int time = (Integer)this._mispunchHourSpinner.getValue() * 3600 + (Integer)this._mispunchMinuteSpinner.getValue() * 60 + (Integer)this._mispunchSecondSpinner.getValue();
        if (this._mispunchBonusRadioButton.isSelected()) {
            time *= -1;
        }
        return time;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

