/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_panel.BaliseEditor;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.GelEpreuveFactory;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

@ExcludeFromJacocoGeneratedReport
final class EpreuveEditor
extends GDialog {
    private final transient Etape _etape;
    private final transient Consumer<Epreuve> _updateCallback;
    private final boolean _isCreation;
    private final boolean _isInVariante;
    private final transient EtapeEpreuveMap _etapeEpreuveMap;
    private transient Epreuve _epreuve;
    private JTextField _nameTextField;
    private JLabel _errorLabel;
    private JComboBox<LimitType> _limitTypeComboBox;
    private JPanel _durationLimitPanel;
    private JSpinner _hourDurationLimitSpinner;
    private JSpinner _minuteDurationLimitSpinner;
    private JPanel _timeLimitPanel;
    private JSpinner _hourTimeLimitSpinner;
    private JSpinner _minuteTimeLimitSpinner;
    private JSpinner _secondTimeLimitSpinner;
    private JPanel _penalitePanel;
    private JSpinner _pointsSpinner;
    private JSpinner _timeSpinner;
    private JSpinner _timePenaltySpinner;
    private JCheckBox _startTimeWithLastBaliseOfPreviousEpreuveCheckbox;
    private JCheckBox _stopTimeWithFirstBaliseOfNextEpreuveCheckbox;
    private JCheckBox _courseEnLigneCheckbox;
    private JCheckBox _isAscenseurCheckBox;
    private JCheckBox _isEpreuveTimedCheckbox;
    private JCheckBox _toBeDoneAfterFinishCheckbox;
    private JSpinner _timeMultiplicatorSpinner;
    private JCheckBox _toBeDoneAfterPreviousEpreuveCheckbox;
    private JCheckBox _toBeDoneBeforeNextEpreuveCheckbox;
    private JCheckBox _exclusiveWithNextEpreuveCheckbox;
    private JCheckBox _variantCheckBox;
    private JButton _validationButton;
    private JRadioButton _gelRadioButton;
    private JRadioButton _epreuveRadioButton;
    private JPanel _freezePanel;
    private JPanel _chronoPanel;
    private JCheckBox _backAndForthCheckBox;
    private JPanel _timeMultiplicatorPanel;

    EpreuveEditor(JFrame parent, Epreuve epreuve, Etape etape, EtapeEpreuveMap etapeEpreuveMap, Consumer<Epreuve> updateCallback, boolean isCreation, boolean isInVariante) {
        super(parent);
        this._epreuve = epreuve;
        this._etape = etape;
        this._etapeEpreuveMap = etapeEpreuveMap;
        this._updateCallback = updateCallback;
        this._isCreation = isCreation;
        this._isInVariante = isInVariante;
        this._initializeUI();
        this._initializeData();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString(this._isCreation ? "epreuve_editor.title1" : "epreuve_editor.title2"));
        this.setContentPane(this._createContentPane());
        this.pack();
    }

    private void _initializeData() {
        this._nameTextField.setText(this._epreuve.getName());
        this._timeMultiplicatorSpinner.setValue(this._epreuve.getTimeMultiplier());
        this._limitTypeComboBox.setModel(new DefaultComboBoxModel<LimitType>(LimitType.values()));
        this._limitTypeComboBox.setSelectedItem((Object)this._epreuve.getLimitType());
        this._pointsSpinner.setValue(this._epreuve.getPenaltyPoints());
        this._timePenaltySpinner.setValue(this._epreuve.getPenaltyTimeInMn());
        this._timeSpinner.setValue(this._epreuve.getPenaltyIntervalInMn());
        switch (this._epreuve.getLimitType()) {
            case AVECLIMITEHORAIRE: {
                this._timeLimitPanel.setVisible(true);
                this._durationLimitPanel.setVisible(false);
                this._hourTimeLimitSpinner.setValue(DateTimeUtils.getHoursFromDate(this._epreuve.getTimeLimit()));
                this._minuteTimeLimitSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._epreuve.getTimeLimit()));
                break;
            }
            case AVECLIMITETEMPS: {
                this._timeLimitPanel.setVisible(false);
                this._durationLimitPanel.setVisible(true);
                this._hourDurationLimitSpinner.setValue(DateTimeUtils.getHoursFromDate(this._epreuve.getDurationLimit()));
                this._minuteDurationLimitSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._epreuve.getDurationLimit()));
                this._secondTimeLimitSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._epreuve.getDurationLimit()));
                break;
            }
            case SANSLIMITE: {
                this._timeLimitPanel.setVisible(false);
                this._durationLimitPanel.setVisible(false);
                break;
            }
        }
        this._isEpreuveTimedCheckbox.setSelected(this._epreuve.isTimed());
        this._courseEnLigneCheckbox.setSelected(this._epreuve.isEnLigne());
        this._toBeDoneAfterFinishCheckbox.setSelected(this._epreuve.isToBeDoneAfterFinish());
        this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setSelected(this._epreuve.isStartTheLastBaliseOfPreviousEpreuve());
        this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setSelected(this._epreuve.isFinishTheFirstBaliseOfNextEpreuve());
        this._toBeDoneAfterPreviousEpreuveCheckbox.setSelected(this._epreuve.isToBeDoneAfterPreviousEpreuve());
        this._toBeDoneBeforeNextEpreuveCheckbox.setSelected(this._epreuve.isToBeDoneBeforeNextEpreuve());
        this._exclusiveWithNextEpreuveCheckbox.setSelected(this._epreuve.isExclusiveWithNextEpreuve());
        this._backAndForthCheckBox.setSelected(this._epreuve.isBackAndForth());
        this._isAscenseurCheckBox.setSelected(this._epreuve.isAscenseur());
        if (this._nameTextField.getText().isEmpty()) {
            this._validationButton.setEnabled(false);
        }
        if (this._epreuve.getType() == EpreuveType.EPREUVE) {
            this._epreuveRadioButton.setSelected(true);
        } else if (this._epreuve.getType() == EpreuveType.GEL) {
            this._limitTypeComboBox.removeItem((Object)LimitType.AVECLIMITEHORAIRE);
            this._gelRadioButton.setSelected(true);
            this._chronoPanel.setVisible(false);
            this._freezePanel.setVisible(true);
            this._timeMultiplicatorPanel.setVisible(false);
        }
        if (this._isCreation) {
            if (this._isInVariante) {
                this._variantCheckBox.setSelected(true);
                this._variantCheckBox.setEnabled(false);
            } else {
                this._variantCheckBox.setSelected(false);
                this._variantCheckBox.setEnabled(false);
            }
        } else if (this._isInVariante) {
            this._variantCheckBox.setSelected(this._epreuve.isVariante());
            this._variantCheckBox.setEnabled(!this._epreuve.isVariante());
        } else {
            this._variantCheckBox.setSelected(false);
            this._variantCheckBox.setEnabled(false);
        }
    }

    private JPanel _createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this._createTopPanel(), "North");
        panel.add((Component)this._createOptionsPanel(), "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        return panel;
    }

    private JPanel _createTopPanel() {
        JPanel panel = new JPanel(new FlowLayout(0, 10, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel labelPanel = new JPanel(new BorderLayout(5, 0));
        labelPanel.add((Component)new JLabel(L10n.getString("epreuve_editor.name")), "West");
        labelPanel.add((Component)this._createJTextFieldNom(), "Center");
        panel.add(labelPanel);
        panel.add(this._createRadioButtonPanel());
        return panel;
    }

    private JPanel _createRadioButtonPanel() {
        JPanel radioPanel = new JPanel(new FlowLayout(0));
        this._epreuveRadioButton = this._createEpreuveEpreuveRadioButton();
        this._gelRadioButton = this._createFrozenEpreuveRadioButton();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._gelRadioButton);
        bg.add(this._epreuveRadioButton);
        radioPanel.add(this._epreuveRadioButton);
        radioPanel.add(this._gelRadioButton);
        return radioPanel;
    }

    private JRadioButton _createEpreuveEpreuveRadioButton() {
        JRadioButton radioButton = new JRadioButton(L10n.getString("epreuve_editor.type1"));
        radioButton.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        radioButton.addActionListener(event -> {
            this._freezePanel.setVisible(false);
            this._chronoPanel.setVisible(true);
            this._epreuve = new StandardEpreuveFactory().createEpreuve(this._epreuve);
            this._limitTypeComboBox.setModel(new DefaultComboBoxModel());
            this._limitTypeComboBox.setModel(new DefaultComboBoxModel<LimitType>(LimitType.values()));
            this._limitTypeComboBox.setSelectedIndex(0);
            this._timeMultiplicatorPanel.setVisible(true);
        });
        radioButton.setEnabled(this._isCreation);
        return radioButton;
    }

    private JRadioButton _createFrozenEpreuveRadioButton() {
        JRadioButton radioButton = new JRadioButton(L10n.getString("epreuve_editor.type2"));
        radioButton.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        radioButton.addActionListener(event -> {
            this._freezePanel.setVisible(true);
            this._chronoPanel.setVisible(false);
            this._epreuve = new GelEpreuveFactory().createEpreuve(this._epreuve);
            this._limitTypeComboBox.setModel(new DefaultComboBoxModel());
            this._limitTypeComboBox.setModel(new DefaultComboBoxModel<LimitType>(LimitType.values()));
            this._limitTypeComboBox.removeItem((Object)LimitType.AVECLIMITEHORAIRE);
            this._limitTypeComboBox.setSelectedIndex(0);
            this._timeMultiplicatorPanel.setVisible(false);
        });
        radioButton.setEnabled(this._isCreation);
        return radioButton;
    }

    private JPanel _createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        panel.add(this._createJPanelTypeLimite());
        panel.add(this._createDurationLimitPanel());
        panel.add(this._createTimeLimitPanel());
        panel.add(this._createJPanelPenalite());
        panel.add(this._createCheckBoxesPanel());
        panel.add(this._createTimeMultiplicatorPanel());
        panel.add(this._createBaliseModelPanel());
        panel.add(this._createIsVarianteCheckbox());
        JPanel errorPanel = new JPanel(new FlowLayout(0));
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(Color.red);
        errorPanel.add(this._errorLabel);
        panel.add(errorPanel);
        return panel;
    }

    private JPanel _createCheckBoxesPanel() {
        JPanel panel = new JPanel(new CardLayout());
        panel.add(this._createJPanelChrono());
        panel.add(this._createJPanelFreeze());
        return panel;
    }

    private JPanel _createJPanelFreeze() {
        this._freezePanel = new JPanel();
        this._freezePanel.setLayout(new BoxLayout(this._freezePanel, 1));
        this._freezePanel.add(this._createBackAndForthCheckBox());
        return this._freezePanel;
    }

    private JCheckBox _createBackAndForthCheckBox() {
        this._backAndForthCheckBox = new JCheckBox(L10n.getString("epreuve_editor.checkbox10"));
        return this._backAndForthCheckBox;
    }

    private JPanel _createIsVarianteCheckbox() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._variantCheckBox = new JCheckBox(L10n.getString("epreuve_editor.checkbox9"));
        panel.add(this._variantCheckBox);
        return panel;
    }

    private JComponent _createBaliseModelPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createBaliseModelButton());
        return panel;
    }

    private JButton _createBaliseModelButton() {
        ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/flag-24.png"));
        JButton button = new JButton(L10n.getString("epreuve_editor.default_balise.button"), icon);
        button.setToolTipText(L10n.getString("epreuve_editor.default_balise.tooltip"));
        Balise balise = new Balise(this._epreuve.getBaliseModel());
        button.addActionListener(event -> {
            BaliseEditor view = new BaliseEditor(this, balise, b -> this._epreuve.setLocalBaliseModel((Balise)b), () -> this._epreuve.removeLocalBaliseModel(), false, true);
            view.setLocationRelativeTo(this);
            view.setVisible(true);
        });
        return button;
    }

    private JTextField _createJTextFieldNom() {
        this._nameTextField = new JTextField();
        this._nameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EpreuveEditor.this._validationButton.setEnabled(!EpreuveEditor.this._nameTextField.getText().trim().isEmpty());
            }
        });
        return this._nameTextField;
    }

    private JPanel _createJPanelTypeLimite() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("epreuve_editor.limit")));
        panel.add(this._createJComboBoxTypeLimite());
        return panel;
    }

    private JComboBox<LimitType> _createJComboBoxTypeLimite() {
        this._limitTypeComboBox = new JComboBox();
        this._limitTypeComboBox.addActionListener(event -> {
            assert (this._limitTypeComboBox.getSelectedItem() != null);
            switch ((LimitType)((Object)((Object)this._limitTypeComboBox.getSelectedItem()))) {
                case SANSLIMITE: {
                    this._timeLimitPanel.setVisible(false);
                    this._durationLimitPanel.setVisible(false);
                    this._penalitePanel.setVisible(false);
                    break;
                }
                case AVECLIMITEHORAIRE: {
                    this._timeLimitPanel.setVisible(true);
                    this._durationLimitPanel.setVisible(false);
                    this._penalitePanel.setVisible(true);
                    this._isEpreuveTimedCheckbox.setSelected(true);
                    break;
                }
                case AVECLIMITETEMPS: {
                    this._timeLimitPanel.setVisible(false);
                    this._durationLimitPanel.setVisible(true);
                    this._penalitePanel.setVisible(true);
                    this._isEpreuveTimedCheckbox.setSelected(true);
                    break;
                }
            }
        });
        return this._limitTypeComboBox;
    }

    private JPanel _createDurationLimitPanel() {
        this._durationLimitPanel = new JPanel(new FlowLayout(0));
        this._durationLimitPanel.add(new JLabel(L10n.getString("epreuve_editor.time_limit")));
        this._durationLimitPanel.add(this._createHourDurationLimitTemps());
        this._durationLimitPanel.add(new JLabel(L10n.getString("hour_abbreviation")));
        this._durationLimitPanel.add(this._createMinuteDurationLimitSpinner());
        this._durationLimitPanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        this._durationLimitPanel.add(this._createSecondDurationLimitSpinner());
        this._durationLimitPanel.add(new JLabel(L10n.getString("second_abbreviation")));
        return this._durationLimitPanel;
    }

    private JSpinner _createHourDurationLimitTemps() {
        this._hourDurationLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        return this._hourDurationLimitSpinner;
    }

    private JSpinner _createMinuteDurationLimitSpinner() {
        this._minuteDurationLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._minuteDurationLimitSpinner;
    }

    private JPanel _createTimeLimitPanel() {
        this._timeLimitPanel = new JPanel(new FlowLayout(0));
        this._timeLimitPanel.setVisible(false);
        this._timeLimitPanel.add(new JLabel(L10n.getString("epreuve_editor.hour_limit")));
        this._timeLimitPanel.add(this._createHourTimeLimitSpinner());
        this._timeLimitPanel.add(new JLabel(L10n.getString("hour_abbreviation")));
        this._timeLimitPanel.add(this._createMinuteTimeLimitSpinner());
        this._timeLimitPanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._timeLimitPanel;
    }

    private JSpinner _createHourTimeLimitSpinner() {
        this._hourTimeLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 48, 1));
        return this._hourTimeLimitSpinner;
    }

    private JSpinner _createMinuteTimeLimitSpinner() {
        this._minuteTimeLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._minuteTimeLimitSpinner;
    }

    private JPanel _createJPanelPenalite() {
        this._penalitePanel = new JPanel(new FlowLayout(0));
        this._penalitePanel.add((Component)new JLabel(L10n.getString("epreuve_editor.minus")), null);
        this._penalitePanel.add(this._createJSpinnerPoints());
        this._penalitePanel.add(new JLabel(L10n.getString("epreuve_editor.point_and_plus")));
        this._penalitePanel.add(this._createJSpinnerPenaliteTemps());
        this._penalitePanel.add(new JLabel(L10n.getString("epreuve_editor.mn_by")));
        this._penalitePanel.add(this._createJSpinnerTemps());
        this._penalitePanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._penalitePanel;
    }

    private JSpinner _createJSpinnerPoints() {
        this._pointsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 500, 1));
        return this._pointsSpinner;
    }

    private JSpinner _createJSpinnerTemps() {
        this._timeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        return this._timeSpinner;
    }

    private JSpinner _createJSpinnerPenaliteTemps() {
        this._timePenaltySpinner = new JSpinner();
        this._timePenaltySpinner.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        return this._timePenaltySpinner;
    }

    private JPanel _createJPanelChrono() {
        this._chronoPanel = new JPanel(new FlowLayout(0));
        this._chronoPanel.setLayout(new BoxLayout(this._chronoPanel, 1));
        this._chronoPanel.add(this._createIsEpreuveTimedCheckbox());
        this._chronoPanel.add(this._createStartTimeWithLastBaliseOfPreviousEpreuveCheckbox());
        this._chronoPanel.add(this._createStopTimeWithFirstBaliseOfNextEpreuveCheckbox());
        this._chronoPanel.add(this._createCourseEnLigneCheckbox());
        this._chronoPanel.add(this._createIsAscenseurCheckBox());
        this._chronoPanel.add(this._createToBeDoneAfterFinishCheckbox());
        this._chronoPanel.add(this._createExclusiveWithNextEpreuveCheckbox());
        this._chronoPanel.add(this._createToBeDoneAfterPreviousEpreuveCheckbox());
        this._chronoPanel.add(this._createToBeDoneBeforeNextEpreuveCheckbox());
        return this._chronoPanel;
    }

    private Component _createIsAscenseurCheckBox() {
        this._isAscenseurCheckBox = new JCheckBox(L10n.getString("epreuve_editor.checkbox11"));
        this._isAscenseurCheckBox.addChangeListener(arg0 -> {
            if (this._isAscenseurCheckBox.isSelected()) {
                this._courseEnLigneCheckbox.setSelected(false);
                this._courseEnLigneCheckbox.setEnabled(false);
            } else {
                this._courseEnLigneCheckbox.setEnabled(true);
            }
        });
        return this._isAscenseurCheckBox;
    }

    private JCheckBox _createIsEpreuveTimedCheckbox() {
        this._isEpreuveTimedCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox1"));
        this._isEpreuveTimedCheckbox.addChangeListener(arg0 -> this._checkChronoConstraints());
        return this._isEpreuveTimedCheckbox;
    }

    private void _checkChronoConstraints() {
        assert (this._limitTypeComboBox.getSelectedItem() != null);
        if ((Integer)this._timeMultiplicatorSpinner.getValue() > 1 || this._limitTypeComboBox.getSelectedItem() != LimitType.SANSLIMITE || this._gelRadioButton.isSelected()) {
            this._isEpreuveTimedCheckbox.setSelected(true);
        }
        if (this._isEpreuveTimedCheckbox.isSelected()) {
            if (this._etapeEpreuveMap.isFirstEpreuveOfEtape(this._etape, this._epreuve) || this._gelRadioButton.isSelected()) {
                this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setEnabled(false);
                this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setSelected(false);
            } else {
                this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setEnabled(true);
            }
            if (this._etapeEpreuveMap.isLastEpreuve(this._etape, this._epreuve) || this._gelRadioButton.isSelected()) {
                this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setEnabled(false);
                this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setSelected(false);
            } else {
                this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setEnabled(true);
            }
        } else {
            this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setSelected(false);
            this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setSelected(false);
            this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setEnabled(false);
            this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setEnabled(false);
        }
    }

    private JCheckBox _createStartTimeWithLastBaliseOfPreviousEpreuveCheckbox() {
        this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox2"));
        this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.setEnabled(false);
        return this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox;
    }

    private JCheckBox _createStopTimeWithFirstBaliseOfNextEpreuveCheckbox() {
        this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox3"));
        this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setEnabled(false);
        this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.setSelected(true);
        return this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox;
    }

    private JCheckBox _createCourseEnLigneCheckbox() {
        this._courseEnLigneCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox4"));
        this._courseEnLigneCheckbox.addChangeListener(arg0 -> {
            if (this._courseEnLigneCheckbox.isSelected()) {
                this._isAscenseurCheckBox.setSelected(false);
                this._isAscenseurCheckBox.setEnabled(false);
            } else {
                this._isAscenseurCheckBox.setEnabled(true);
            }
        });
        return this._courseEnLigneCheckbox;
    }

    private JCheckBox _createToBeDoneAfterFinishCheckbox() {
        this._toBeDoneAfterFinishCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox5"));
        return this._toBeDoneAfterFinishCheckbox;
    }

    private JCheckBox _createExclusiveWithNextEpreuveCheckbox() {
        this._exclusiveWithNextEpreuveCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox6"));
        return this._exclusiveWithNextEpreuveCheckbox;
    }

    private JCheckBox _createToBeDoneAfterPreviousEpreuveCheckbox() {
        this._toBeDoneAfterPreviousEpreuveCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox7"));
        this._toBeDoneAfterPreviousEpreuveCheckbox.addItemListener(event -> {
            if (this._toBeDoneAfterPreviousEpreuveCheckbox.isSelected()) {
                this._toBeDoneBeforeNextEpreuveCheckbox.setSelected(false);
            }
        });
        return this._toBeDoneAfterPreviousEpreuveCheckbox;
    }

    private JCheckBox _createToBeDoneBeforeNextEpreuveCheckbox() {
        this._toBeDoneBeforeNextEpreuveCheckbox = new JCheckBox(L10n.getString("epreuve_editor.checkbox8"));
        this._toBeDoneBeforeNextEpreuveCheckbox.addItemListener(event -> {
            if (this._toBeDoneBeforeNextEpreuveCheckbox.isSelected()) {
                this._toBeDoneAfterPreviousEpreuveCheckbox.setSelected(false);
            }
        });
        return this._toBeDoneBeforeNextEpreuveCheckbox;
    }

    private JPanel _createTimeMultiplicatorPanel() {
        this._timeMultiplicatorPanel = new JPanel(new FlowLayout(0));
        this._timeMultiplicatorPanel.add(new JLabel(L10n.getString("epreuve_editor.multiplicator")));
        this._timeMultiplicatorPanel.add(this._createTimeMultiplicatorSpinner());
        return this._timeMultiplicatorPanel;
    }

    private JSpinner _createTimeMultiplicatorSpinner() {
        this._timeMultiplicatorSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this._timeMultiplicatorSpinner.addChangeListener(event -> {
            if ((Integer)this._timeMultiplicatorSpinner.getValue() > 1) {
                this._isEpreuveTimedCheckbox.setSelected(true);
            }
        });
        return this._timeMultiplicatorSpinner;
    }

    private JSpinner _createSecondDurationLimitSpinner() {
        this._secondTimeLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._secondTimeLimitSpinner;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        this._validationButton = new JButton(L10n.getString(this._isCreation ? "epreuve_editor.validate_button1" : "epreuve_editor.validate_button2"));
        this.setDefaultButton(this._validationButton);
        this._validationButton.addActionListener(event -> this._validate());
        return this._validationButton;
    }

    private void _validate() {
        String confirmationMessage;
        int answer;
        if (this._variantCheckBox.isEnabled() && this._variantCheckBox.isSelected() && (answer = JOptionPane.showConfirmDialog(this.rootPane, confirmationMessage = L10n.getString("epreuve_editor.warning_variant"), L10n.getString("confirmation_title"), 0, 3)) == 1) {
            return;
        }
        String epreuveName = this._nameTextField.getText();
        if (epreuveName.trim().isEmpty()) {
            DesktopView.beep();
            this._errorLabel.setText(L10n.getString("epreuve_editor.error1"));
            return;
        }
        this._epreuve.setName(epreuveName);
        this._epreuve.setTimeMultiplier((Integer)this._timeMultiplicatorSpinner.getValue());
        this._epreuve.setLimitType((LimitType)((Object)this._limitTypeComboBox.getSelectedItem()));
        this._epreuve.setTimed(this._isEpreuveTimedCheckbox.isSelected());
        this._epreuve.setEnLigne(this._courseEnLigneCheckbox.isSelected());
        this._epreuve.setToBeDoneAfterFinish(this._toBeDoneAfterFinishCheckbox.isSelected());
        this._epreuve.setStartTheLastBaliseOfPreviousEpreuve(this._startTimeWithLastBaliseOfPreviousEpreuveCheckbox.isSelected());
        this._epreuve.setFinishTheFirstBaliseOfNextEpreuve(this._stopTimeWithFirstBaliseOfNextEpreuveCheckbox.isSelected());
        this._epreuve.setToBeDoneAfterPreviousEpreuve(this._toBeDoneAfterPreviousEpreuveCheckbox.isSelected());
        this._epreuve.setToBeDoneBeforeNextEpreuve(this._toBeDoneBeforeNextEpreuveCheckbox.isSelected());
        this._epreuve.setExclusiveWithNextEpreuve(this._exclusiveWithNextEpreuveCheckbox.isSelected());
        this._epreuve.setVariante(this._variantCheckBox.isSelected());
        this._epreuve.setBackAndForth(this._backAndForthCheckBox.isSelected());
        this._epreuve.setAscenseur(this._isAscenseurCheckBox.isSelected());
        assert (this._epreuve.getLimitType() != null);
        if (this._epreuve.getLimitType() == LimitType.AVECLIMITEHORAIRE) {
            this._epreuve.setTimeLimit(new Date((long)((Integer)this._hourTimeLimitSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._minuteTimeLimitSpinner.getValue()).intValue() * 60000L));
        }
        if (this._epreuve.getLimitType() == LimitType.AVECLIMITETEMPS) {
            this._epreuve.setDurationLimit(new Date((long)((Integer)this._hourDurationLimitSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._minuteDurationLimitSpinner.getValue()).intValue() * 60000L + (long)((Integer)this._secondTimeLimitSpinner.getValue()).intValue() * 1000L));
        }
        if (this._epreuve.getLimitType() != LimitType.SANSLIMITE) {
            this._epreuve.setPenaltyPoints((Integer)this._pointsSpinner.getValue());
            this._epreuve.setPenaltyTimeInMn((Integer)this._timePenaltySpinner.getValue());
            this._epreuve.setPenaltyIntervalInMn((Integer)this._timeSpinner.getValue());
        }
        if (this._etapeEpreuveMap.existsAnotherEpreuveWithSameName(this._etape, epreuveName, this._epreuve)) {
            DesktopView.beep();
            this._errorLabel.setText(L10n.getString("epreuve_editor.error2"));
        } else {
            this._updateCallback.accept(this._epreuve);
            this.dispose();
        }
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

