/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

@ExcludeFromJacocoGeneratedReport
final class EtapeEditor
extends GDialog {
    private final transient Etape _etape;
    private final transient Parcours _parcours;
    private final transient Consumer<Etape> _updateCallback;
    private JTextField _nameTextField;
    private JCheckBox _completedCheckBox;
    private JLabel _errorLabel;
    private JComboBox<StartType> _typeComboBox;
    private JPanel _startHourPanel;
    private JSpinner _startHourSpinner;
    private JSpinner _startMinuteSpinner;
    private JComboBox<LimitType> _limitTypeCombBox;
    private JPanel _durationLimitPanel;
    private JSpinner _hourDurationLimitSpinner;
    private JSpinner _minuteDurationLimitSpinner;
    private JPanel _timeLimitPanel;
    private JSpinner _hourTimeLimitSpinner;
    private JSpinner _minuteTimeLimitSpinner;
    private JPanel _penalitePanel;
    private JSpinner _penaltyPointsSpinner;
    private JSpinner _tempsSpinner;
    private JSpinner _penaltyTimeSpinner;
    private JPanel _gelPanel;
    private JCheckBox _gelCheckbox;
    private final boolean _isCreation;
    private JButton _validationButton;

    EtapeEditor(JFrame parent, Parcours parcours, Etape etape, Consumer<Etape> updateCallback, boolean isCreation) {
        super(parent);
        this._parcours = parcours;
        this._etape = etape;
        this._updateCallback = updateCallback;
        this._isCreation = isCreation;
        this._initializeUI();
        this.initializeData();
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString(this._isCreation ? "etape_editor.title1" : "etape_editor.title2"));
        this.setContentPane(this._createContentPane());
        this.setModal(true);
        this.pack();
    }

    private void initializeData() {
        this._typeComboBox.setModel(new DefaultComboBoxModel<StartType>(StartType.values()));
        this._typeComboBox.setSelectedItem((Object)this._etape.getStartType());
        switch (this._etape.getStartType()) {
            case GROUPE: {
                this._startHourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._etape.getStartHour()));
                this._startMinuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._etape.getStartHour()));
                break;
            }
            case BOITIER: {
                this._startHourPanel.setVisible(false);
                break;
            }
        }
        this._nameTextField.setText(this._etape.getName());
        this._completedCheckBox.setSelected(this._etape.isFinished());
        this._limitTypeCombBox.setModel(new DefaultComboBoxModel<LimitType>(LimitType.values()));
        this._limitTypeCombBox.setSelectedItem((Object)this._etape.getLimitType());
        this._penaltyPointsSpinner.setValue(this._etape.getPenaltyPoints());
        this._penaltyTimeSpinner.setValue(this._etape.getPenaltyTimeInMm());
        this._tempsSpinner.setValue(this._etape.getPenaltyInterval());
        switch (this._etape.getLimitType()) {
            case AVECLIMITEHORAIRE: {
                this._timeLimitPanel.setVisible(true);
                this._durationLimitPanel.setVisible(false);
                this._gelPanel.setVisible(false);
                this._hourTimeLimitSpinner.setValue(DateTimeUtils.getHoursFromDate(this._etape.getLimitHour()));
                this._minuteTimeLimitSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._etape.getLimitHour()));
                break;
            }
            case AVECLIMITETEMPS: {
                this._timeLimitPanel.setVisible(false);
                this._durationLimitPanel.setVisible(true);
                this._gelPanel.setVisible(true);
                this._hourDurationLimitSpinner.setValue(DateTimeUtils.getHoursFromDate(this._etape.getDurationLimit()));
                this._minuteDurationLimitSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._etape.getDurationLimit()));
                this._gelCheckbox.setSelected(this._etape.isGelUsedInTimeLimit());
                break;
            }
            case SANSLIMITE: {
                this._timeLimitPanel.setVisible(false);
                this._durationLimitPanel.setVisible(false);
                this._gelPanel.setVisible(false);
                break;
            }
        }
        if (this._nameTextField.getText().isEmpty()) {
            this._validationButton.setEnabled(false);
        }
    }

    private JPanel _createContentPane() {
        JPanel jContentPane = new JPanel(new BorderLayout());
        jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        jContentPane.add((Component)this._createJPanel(), "North");
        jContentPane.add((Component)this._createButtonPanel(), "South");
        return jContentPane;
    }

    private JPanel _createJPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel labelPanel = new JPanel(new BorderLayout(5, 0));
        labelPanel.add((Component)new JLabel(L10n.getString("etape_editor.etape_name")), "West");
        labelPanel.add((Component)this._createJTextFieldNom(), "Center");
        panel.add(labelPanel);
        panel.add(this._createJCheckBoxFini());
        panel.add(this._createJPanelType());
        panel.add(this._createJPanelHeureDepart());
        panel.add(this._createJPanelTypeLimite());
        panel.add(this._createJPanelHeureLimiteTemps());
        panel.add(this._createHeureLimiteHorairePanel());
        panel.add(this._createPenalitePanel());
        panel.add(this._createGelPanel());
        panel.add(this._getLabelError());
        return panel;
    }

    private JTextField _createJTextFieldNom() {
        this._nameTextField = new JTextField();
        this._nameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EtapeEditor.this._validationButton.setEnabled(!EtapeEditor.this._nameTextField.getText().trim().isEmpty());
            }
        });
        return this._nameTextField;
    }

    private JComponent _getLabelError() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(Color.red);
        this._errorLabel.setPreferredSize(new Dimension(340, 60));
        panel.add(this._errorLabel);
        return panel;
    }

    private JComponent _createJCheckBoxFini() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._completedCheckBox = new JCheckBox(L10n.getString("etape_editor.finished_checkbox"));
        panel.add(this._completedCheckBox);
        return panel;
    }

    private JPanel _createJPanelType() {
        JPanel jPanelType = new JPanel(new FlowLayout(0));
        jPanelType.add(new JLabel(L10n.getString("etape_editor.start_type")));
        jPanelType.add(this._createJComboBoxType());
        return jPanelType;
    }

    private JComboBox<StartType> _createJComboBoxType() {
        this._typeComboBox = new JComboBox();
        this._typeComboBox.addActionListener(event -> {
            assert (this._typeComboBox.getSelectedItem() != null);
            switch ((StartType)((Object)((Object)this._typeComboBox.getSelectedItem()))) {
                case GROUPE: {
                    this._startHourPanel.setVisible(true);
                    break;
                }
                case BOITIER: {
                    this._startHourPanel.setVisible(false);
                    break;
                }
            }
        });
        return this._typeComboBox;
    }

    private JPanel _createJPanelHeureDepart() {
        this._startHourPanel = new JPanel(new FlowLayout(0));
        this._startHourPanel.add(new JLabel(L10n.getString("etape_editor.start_time")));
        this._startHourPanel.add(this._createJSpinnerHeure());
        this._startHourPanel.add(new JLabel(L10n.getString("hour_abbreviation")));
        this._startHourPanel.add(this._createJSpinnerMinute());
        this._startHourPanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._startHourPanel;
    }

    private JSpinner _createJSpinnerHeure() {
        this._startHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 48, 1));
        return this._startHourSpinner;
    }

    private JSpinner _createJSpinnerMinute() {
        this._startMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._startMinuteSpinner;
    }

    private JPanel _createJPanelTypeLimite() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("etape_editor.limit")));
        panel.add(this._createJComboBoxTypeLimite());
        return panel;
    }

    private JComboBox<LimitType> _createJComboBoxTypeLimite() {
        this._limitTypeCombBox = new JComboBox();
        this._limitTypeCombBox.addActionListener(event -> {
            assert (this._limitTypeCombBox.getSelectedItem() != null);
            switch ((LimitType)((Object)((Object)this._limitTypeCombBox.getSelectedItem()))) {
                case SANSLIMITE: {
                    this._timeLimitPanel.setVisible(false);
                    this._durationLimitPanel.setVisible(false);
                    this._penalitePanel.setVisible(false);
                    this._gelPanel.setVisible(false);
                    break;
                }
                case AVECLIMITEHORAIRE: {
                    this._timeLimitPanel.setVisible(true);
                    this._durationLimitPanel.setVisible(false);
                    this._penalitePanel.setVisible(true);
                    this._gelPanel.setVisible(false);
                    break;
                }
                case AVECLIMITETEMPS: {
                    this._timeLimitPanel.setVisible(false);
                    this._durationLimitPanel.setVisible(true);
                    this._penalitePanel.setVisible(true);
                    this._gelPanel.setVisible(true);
                    break;
                }
            }
        });
        return this._limitTypeCombBox;
    }

    private JPanel _createJPanelHeureLimiteTemps() {
        this._durationLimitPanel = new JPanel(new FlowLayout(0));
        this._durationLimitPanel.add(new JLabel(L10n.getString("etape_editor.limit_time")));
        this._durationLimitPanel.add(this._createJSpinnerHeureLimiteTemps());
        this._durationLimitPanel.add(new JLabel(L10n.getString("hour_abbreviation")));
        this._durationLimitPanel.add(this._createJSpinnerMinuteLimiteTemps());
        this._durationLimitPanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._durationLimitPanel;
    }

    private JSpinner _createJSpinnerHeureLimiteTemps() {
        this._hourDurationLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        return this._hourDurationLimitSpinner;
    }

    private JSpinner _createJSpinnerMinuteLimiteTemps() {
        this._minuteDurationLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._minuteDurationLimitSpinner;
    }

    private JPanel _createHeureLimiteHorairePanel() {
        this._timeLimitPanel = new JPanel(new FlowLayout(0));
        this._timeLimitPanel.setVisible(false);
        this._timeLimitPanel.add(new JLabel(L10n.getString("etape_editor.limit_hour")));
        this._timeLimitPanel.add(this._createHeureLimiteHoraireSpinner());
        this._timeLimitPanel.add(new JLabel(L10n.getString("hour_abbreviation")));
        this._timeLimitPanel.add(this._createMinuteLimiteHoraireSpinner());
        this._timeLimitPanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._timeLimitPanel;
    }

    private JSpinner _createHeureLimiteHoraireSpinner() {
        this._hourTimeLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 48, 1));
        return this._hourTimeLimitSpinner;
    }

    private JSpinner _createMinuteLimiteHoraireSpinner() {
        this._minuteTimeLimitSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        return this._minuteTimeLimitSpinner;
    }

    private JPanel _createPenalitePanel() {
        this._penalitePanel = new JPanel(new FlowLayout(0));
        this._penalitePanel.add(new JLabel(L10n.getString("etape_editor.minus")));
        this._penalitePanel.add(this._createPenaltyPointsSpinner());
        this._penalitePanel.add(new JLabel(L10n.getString("etape_editor.points_and_plus")));
        this._penalitePanel.add(this._createPenaltyTimeSpinner());
        this._penalitePanel.add(new JLabel(L10n.getString("etape_editor.mn_by")));
        this._penalitePanel.add(this._createTempsSpinner());
        this._penalitePanel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return this._penalitePanel;
    }

    private JSpinner _createPenaltyPointsSpinner() {
        this._penaltyPointsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 500, 10));
        return this._penaltyPointsSpinner;
    }

    private JSpinner _createTempsSpinner() {
        this._tempsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 60, 1));
        return this._tempsSpinner;
    }

    private JSpinner _createPenaltyTimeSpinner() {
        this._penaltyTimeSpinner = new JSpinner();
        this._penaltyTimeSpinner.setMinimumSize(new Dimension(47, 20));
        this._penaltyTimeSpinner.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        return this._penaltyTimeSpinner;
    }

    private JPanel _createGelPanel() {
        this._gelPanel = new JPanel(new FlowLayout(0));
        this._gelCheckbox = new JCheckBox(L10n.getString("etape_editor.freeze_checkbox"));
        this._gelPanel.add(this._gelCheckbox);
        return this._gelPanel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        this._validationButton = new JButton(L10n.getString(this._isCreation ? "etape_editor.validate_button1" : "etape_editor.validate_button2"));
        this.setDefaultButton(this._validationButton);
        this._validationButton.addActionListener(event -> {
            String name = this._nameTextField.getText();
            if (name.trim().isEmpty()) {
                DesktopView.beep();
                this._errorLabel.setText(L10n.getString("etape_editor.error1"));
                return;
            }
            this._etape.setName(name.trim());
            this._etape.setFinished(this._completedCheckBox.isSelected());
            this._etape.setStartType((StartType)((Object)((Object)this._typeComboBox.getSelectedItem())));
            assert (this._etape.getStartType() != null);
            if (this._etape.getStartType() == StartType.GROUPE) {
                this._etape.setStartHour(new Date((long)((Integer)this._startHourSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._startMinuteSpinner.getValue()).intValue() * 60000L));
            }
            this._etape.setLimitType((LimitType)((Object)((Object)this._limitTypeCombBox.getSelectedItem())));
            assert (this._etape.getLimitType() != null);
            if (this._etape.getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                this._etape.setLimitHour(new Date((long)((Integer)this._hourTimeLimitSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._minuteTimeLimitSpinner.getValue()).intValue() * 60000L));
            }
            if (this._etape.getLimitType() == LimitType.AVECLIMITETEMPS) {
                this._etape.setDurationLimit(new Date((long)((Integer)this._hourDurationLimitSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._minuteDurationLimitSpinner.getValue()).intValue() * 60000L));
                this._etape.setGelUsedInTimeLimit(this._gelCheckbox.isSelected());
            }
            if (this._etape.getLimitType() != LimitType.SANSLIMITE) {
                this._etape.setPenaltyPoints((Integer)this._penaltyPointsSpinner.getValue());
                this._etape.setPenaltyTimeInMm((Integer)this._penaltyTimeSpinner.getValue());
                this._etape.setPenaltyInterval((Integer)this._tempsSpinner.getValue());
            }
            if (this._parcours.existsAnotherEtapeWithSameName(name, this._etape)) {
                DesktopView.beep();
                this._errorLabel.setText(L10n.getString("etape_editor.error2"));
            } else {
                this._updateCallback.accept(this._etape);
                this.dispose();
            }
        });
        return this._validationButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

