/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.epreuve.Epreuve;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlParcoursReader {
    private static final String IOF_VERSION_V2 = "IOFVersion";
    private static final String IOF_VERSION_V3 = "iofVersion";
    private static final String VERSION = "version";
    private static final String COURSE = "Course";
    private static final String RACE_COURSE_DATA = "RaceCourseData";
    private static final String COURSE_NAME = "CourseName";
    private static final String NAME = "Name";
    private static final String COURSE_VARIATION = "CourseVariation";
    private static final String COURSE_CONTROL = "CourseControl";
    private static final String CONTROL_CODE = "ControlCode";
    private static final String CONTROL = "Control";
    private static final String ID = "Id";
    private static final String COURSE_VARIATION_ID = "CourseVariationId";
    private static Element _racine;

    XmlParcoursReader() {
    }

    static void importEpreuve(Epreuve epreuve, String filePath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream input = new FileInputStream(filePath);
            InputStream inputStream = XmlParcoursReader._discardByteOrderMarkIfAny(input);
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            Document document = builder.parse(new InputSource(reader));
            document.getDocumentElement().normalize();
            _racine = document.getDocumentElement();
            if (!_racine.getAttribute(IOF_VERSION_V3).isEmpty()) {
                if (_racine.getAttribute(IOF_VERSION_V3).charAt(0) == '3') {
                    XmlParcoursReader._importCourseV3(epreuve);
                }
            } else if (_racine.getElementsByTagName(IOF_VERSION_V2).getLength() > 0) {
                if (((Element)_racine.getElementsByTagName(IOF_VERSION_V2).item(0)).getAttribute(VERSION).charAt(0) == '2') {
                    XmlParcoursReader._importCourseV2(epreuve);
                }
            } else {
                ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.error1"));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.error2", e.getClass().getName(), e.getMessage()));
        }
    }

    @VisibleForTesting
    static InputStream _discardByteOrderMarkIfAny(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    private static void _importCourseV2(Epreuve epreuve) {
        NodeList courses = _racine.getElementsByTagName(COURSE);
        ArrayList<Object> courseNames = new ArrayList<Object>();
        courseNames.add(L10n.getString("xml_parcours_reader.all_controls"));
        if (courses.getLength() > 0) {
            for (int i = 0; i < courses.getLength(); ++i) {
                Element course = (Element)courses.item(i);
                NodeList variations = course.getElementsByTagName(COURSE_VARIATION);
                for (int j = 0; j < variations.getLength(); ++j) {
                    Element variation = (Element)variations.item(j);
                    if (XmlParcoursReader._getChildText(variation, NAME) != null) {
                        courseNames.add(XmlParcoursReader._getChildText(course, COURSE_NAME) + " - " + XmlParcoursReader._getChildText(variation, NAME));
                        continue;
                    }
                    courseNames.add(XmlParcoursReader._getChildText(course, COURSE_NAME) + " - " + XmlParcoursReader._getChildText(variation, COURSE_VARIATION_ID));
                }
            }
            String selectedCourse = (String)JOptionPane.showInputDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.circuit_chooser.message"), L10n.getString("xml_parcours_reader.circuit_chooser.title"), 1, null, courseNames.toArray(), courseNames.get(0));
            if (selectedCourse != null) {
                if (selectedCourse.equals(courseNames.get(0))) {
                    XmlParcoursReader._importAllControlsV2(epreuve);
                    return;
                }
                for (int i = 0; i < courses.getLength(); ++i) {
                    Element course = (Element)courses.item(i);
                    NodeList variations = course.getElementsByTagName(COURSE_VARIATION);
                    for (int j = 0; j < variations.getLength(); ++j) {
                        Element variation = (Element)variations.item(j);
                        if (!(XmlParcoursReader._getChildText(course, COURSE_NAME) + " - " + XmlParcoursReader._getChildText(variation, NAME)).equals(selectedCourse) && !(XmlParcoursReader._getChildText(course, COURSE_NAME) + " - " + XmlParcoursReader._getChildText(variation, COURSE_VARIATION_ID)).equals(selectedCourse)) continue;
                        NodeList controls = variation.getElementsByTagName(COURSE_CONTROL);
                        for (int k = 0; k < controls.getLength(); ++k) {
                            Element code = (Element)controls.item(k);
                            Balise balise = new Balise(Integer.parseInt(XmlParcoursReader._getChildText(code, CONTROL_CODE).trim()));
                            balise.applyModel(epreuve.getBaliseModel());
                            epreuve.addBalise(balise);
                        }
                    }
                }
            }
        } else {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.error3"));
        }
    }

    private static void _importAllControlsV2(Epreuve epreuve) {
        NodeList controls = _racine.getElementsByTagName(CONTROL);
        if (controls.getLength() > 0) {
            for (int i = 0; i < controls.getLength(); ++i) {
                Element control = (Element)controls.item(i);
                Balise balise = new Balise(Integer.parseInt(XmlParcoursReader._getChildText(control, CONTROL_CODE).trim()));
                balise.applyModel(epreuve.getBaliseModel());
                epreuve.addBalise(balise);
            }
        }
    }

    private static void _importCourseV3(Epreuve epreuve) {
        Element race = (Element)_racine.getElementsByTagNameNS(_racine.getNamespaceURI(), RACE_COURSE_DATA).item(0);
        NodeList courses = race.getElementsByTagNameNS(_racine.getNamespaceURI(), COURSE);
        if (courses.getLength() > 0) {
            Object[] courseNames = new String[courses.getLength() + 1];
            courseNames[0] = L10n.getString("xml_parcours_reader.all_controls");
            for (int i = 0; i < courses.getLength(); ++i) {
                Element course = (Element)courses.item(i);
                courseNames[i + 1] = XmlParcoursReader._getChildText(course, NAME, _racine.getNamespaceURI());
            }
            String selectedCourse = (String)JOptionPane.showInputDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.circuit_chooser.message"), L10n.getString("xml_parcours_reader.circuit_chooser.title"), 1, null, courseNames, courseNames[0]);
            if (selectedCourse != null) {
                if (selectedCourse.equals(courseNames[0])) {
                    XmlParcoursReader._importAllControlsV3(epreuve);
                    return;
                }
                for (int i = 0; i < courses.getLength(); ++i) {
                    Element course = (Element)courses.item(i);
                    if (!XmlParcoursReader._getChildText(course, NAME, _racine.getNamespaceURI()).equals(selectedCourse)) continue;
                    NodeList controls = course.getElementsByTagNameNS(_racine.getNamespaceURI(), COURSE_CONTROL);
                    for (int j = 0; j < controls.getLength(); ++j) {
                        Element code = (Element)controls.item(j);
                        if (!code.getAttribute(L10n.getString("xml_parcours_reader.type")).equals(CONTROL)) continue;
                        Balise balise = new Balise(Integer.parseInt(XmlParcoursReader._getChildText(code, CONTROL, _racine.getNamespaceURI()).trim()));
                        balise.applyModel(epreuve.getBaliseModel());
                        epreuve.addBalise(balise);
                    }
                }
            }
        } else {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_parcours_reader.error3"));
        }
    }

    private static void _importAllControlsV3(Epreuve epreuve) {
        Element race = (Element)_racine.getElementsByTagNameNS(_racine.getNamespaceURI(), RACE_COURSE_DATA).item(0);
        NodeList raceChildren = race.getChildNodes();
        for (int i = 0; i < raceChildren.getLength(); ++i) {
            Element control;
            String controlId;
            Node child = raceChildren.item(i);
            if (!CONTROL.equals(child.getNodeName()) || !XmlParcoursReader._isInt(controlId = XmlParcoursReader._getChildText(control = (Element)child, ID, _racine.getNamespaceURI()).trim())) continue;
            Balise balise = new Balise(Integer.parseInt(controlId));
            balise.applyModel(epreuve.getBaliseModel());
            epreuve.addBalise(balise);
        }
    }

    private static boolean _isInt(String str) {
        return str.lastIndexOf("-") == 0 && !str.equals("-0") ? str.replace("-", "").matches("\\d+") : str.matches("\\d+");
    }

    private static String _getChildText(Element element, String tag, String namespaceURI) {
        Node node = element.getElementsByTagNameNS(namespaceURI, tag).item(0);
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return "";
        }
        return firstChild.getTextContent();
    }

    private static String _getChildText(Element element, String tag) {
        Node node = element.getElementsByTagName(tag).item(0);
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return "";
        }
        return firstChild.getTextContent();
    }
}

