/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.result_panel.DataTableModel;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.swing.JOptionPane;

final class CsvWriter {
    CsvWriter() {
    }

    static void export(DataTableModel resultTableModel, String filename) {
        File file = new File(filename);
        int option = 0;
        if (file.exists()) {
            option = JOptionPane.showConfirmDialog(GeRaidV3.getRootFrame(), L10n.getString("confirm_file_overwrite", filename), L10n.getString("confirmation_title"), 0, 2);
        }
        if (option == 0) {
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                String csvText = resultTableModel.generateHeaderAsCsv();
                writer.write(csvText);
                writer.write(System.lineSeparator());
                for (String row : resultTableModel.generateDataAsCsv()) {
                    writer.write(row);
                    writer.write(System.lineSeparator());
                }
            }
            catch (IOException e) {
                DesktopView.beep();
                ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.cvs_writer.error", e.getClass().getName(), e.getMessage()));
            }
        }
    }
}

