/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.result_panel.ResultPresenter;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.Document;

@ExcludeFromJacocoGeneratedReport
public final class GlobalResultView
extends JPanel {
    private final transient ResultPresenter _presenter;
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private JEditorPane _globalResultsEditorPane;
    private JRadioButton _parcoursResultsRadioButton;

    GlobalResultView(ResultPresenter presenter) {
        super(new BorderLayout());
        this._presenter = presenter;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._createGlobalResultsControlPanel(), "North");
        this.add((Component)this._createGlobalResultsDataPanel(), "Center");
    }

    private JPanel _createGlobalResultsControlPanel() {
        JPanel panel = new JPanel();
        panel.add(this._createParcoursResultsRadioButton());
        panel.add(this._createEtapeResultsRadioButton());
        panel.add(this._createRefreshResultsButton());
        return panel;
    }

    private JRadioButton _createParcoursResultsRadioButton() {
        this._parcoursResultsRadioButton = new JRadioButton(L10n.getString("result_view.global_result.radio_button1"));
        this._parcoursResultsRadioButton.setSelected(true);
        this._buttonGroup.add(this._parcoursResultsRadioButton);
        return this._parcoursResultsRadioButton;
    }

    private JRadioButton _createEtapeResultsRadioButton() {
        JRadioButton button = new JRadioButton(L10n.getString("result_view.global_result.radio_button2"));
        this._buttonGroup.add(button);
        return button;
    }

    private JButton _createRefreshResultsButton() {
        IconButton button = new IconButton("reload-24.png");
        button.setToolTipText(L10n.getString("result_view.global_result.reload_button"));
        button.addActionListener(event -> {
            String url = this._presenter.refreshResults(this._parcoursResultsRadioButton.isSelected());
            try {
                Document document = this._globalResultsEditorPane.getDocument();
                document.putProperty("stream", null);
                this._globalResultsEditorPane.setPage("file:///" + url);
                JOptionPane.showMessageDialog(this.getRootPane(), L10n.getString("result_view.refresh.button.message", url), L10n.getString("information"), 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return button;
    }

    private JScrollPane _createGlobalResultsDataPanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this._createGlobalResultsHTMLViewer());
        return scrollPane;
    }

    private JEditorPane _createGlobalResultsHTMLViewer() {
        this._globalResultsEditorPane = new JEditorPane();
        this._globalResultsEditorPane.setEditable(false);
        this._globalResultsEditorPane.setContentType("text/html");
        return this._globalResultsEditorPane;
    }
}

