/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.result_panel.EpreuveTableModel;
import fr.geraidv3.desktop.result_panel.EtapeTableModel;
import fr.geraidv3.desktop.result_panel.ParcoursTableModel;
import fr.geraidv3.desktop.result_panel.VisualizationType;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.EtapeVisualizationLevel;
import fr.geraidv3.result.ParcoursVisualizationLevel;
import fr.geraidv3.result.etape.EtapeResult;
import fr.geraidv3.result.parcours.ParcoursResult;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import javax.swing.JTable;

public final class HtmlWriter {
    private static final String HTML_SUFFIX = ".html";
    private static final String HTML_FOOTER = "<br><br><br></body></html>";

    private HtmlWriter() {
    }

    public static String createParcoursHtmlFilename(String raidName, String parcoursName, String categorieName) {
        return raidName + "_" + parcoursName + "_" + categorieName + HTML_SUFFIX;
    }

    public static String createEtapeHtmlFilename(String raidName, String parcoursName, String etapeName, String categorieName) {
        return raidName + "_" + parcoursName + "_" + etapeName + "_" + categorieName + HTML_SUFFIX;
    }

    public static String createEpreuveHtmlFilename(String raidName, String parcoursName, String etapeName, String epreuveName, String categorieName) {
        return raidName + "_" + parcoursName + "_" + etapeName + "_" + epreuveName + "_" + categorieName + HTML_SUFFIX;
    }

    static String exportResults(String outputDirectory, String raidName, VisualizationType visualizationType, String parcoursName, String categorieName, String etapeName, String epreuveName, JTable resultTable) {
        File file = new File(outputDirectory);
        if (!file.exists()) {
            return null;
        }
        StringBuilder absoluteFilename = new StringBuilder(outputDirectory).append(File.separator);
        StringBuilder header = new StringBuilder();
        header.append("<h1>").append(raidName).append("</h1>");
        header.append("<p style='font-weight:bold'>").append(L10n.getString("parcours")).append(" : ").append(parcoursName).append("</p>");
        switch (visualizationType) {
            case PARCOURS: {
                absoluteFilename.append(HtmlWriter.createParcoursHtmlFilename(raidName, parcoursName, categorieName));
                HtmlWriter._exportParcoursAsHtml(absoluteFilename.toString(), (ParcoursTableModel)resultTable.getModel(), resultTable, header.toString());
                break;
            }
            case ETAPE: {
                absoluteFilename.append(HtmlWriter.createEtapeHtmlFilename(raidName, parcoursName, etapeName, categorieName));
                header.append("<p style='font-weight:bold'>").append(L10n.getString("etape")).append(" : ").append(etapeName).append("</p>");
                HtmlWriter._exportEtapeAsHtml(absoluteFilename.toString(), (EtapeTableModel)resultTable.getModel(), resultTable, header.toString());
                break;
            }
            case EPREUVE: {
                absoluteFilename.append(HtmlWriter.createEpreuveHtmlFilename(raidName, parcoursName, etapeName, epreuveName, categorieName));
                header.append("<p style='font-weight:bold'>").append(L10n.getString("etape")).append(" : ").append(etapeName).append("</p>");
                header.append("<p style='font-weight:bold'>").append(L10n.getString("epreuve")).append(" : ").append(epreuveName).append("</p>");
                HtmlWriter._exportEpreuveAsHtml(absoluteFilename.toString(), (EpreuveTableModel)resultTable.getModel(), resultTable, header.toString());
            }
        }
        return absoluteFilename.toString();
    }

    static String exportPodiumAsHtml(String parcoursName, String categorieName, String etapeName, String epreuveName, JTable resultTable, int podiumValue, VisualizationType visualizationType) {
        StringBuilder htmlText = new StringBuilder();
        htmlText.append("<table><tr>");
        htmlText.append("<td><p style='font-weight:bold'>").append(L10n.getString("podium_parcours")).append(" : ").append(parcoursName).append("</p></td>");
        htmlText.append("<td><p style='font-weight:bold'>").append(L10n.getString("categorie")).append(" : ").append(categorieName).append("</td></p>");
        htmlText.append("</tr></table>");
        switch (visualizationType) {
            case PARCOURS: {
                htmlText.append(HtmlWriter._generateParcoursPodiumAsHtml((ParcoursTableModel)resultTable.getModel(), resultTable, podiumValue));
                break;
            }
            case ETAPE: {
                htmlText.append("<p style='font-weight:bold'>").append(L10n.getString("etape")).append(" : ").append(etapeName).append("</p>");
                htmlText.append(HtmlWriter._generateEtapePodiumAsHtml((EtapeTableModel)resultTable.getModel(), resultTable, podiumValue));
                break;
            }
            case EPREUVE: {
                htmlText.append("<p style='font-weight:bold'>").append(L10n.getString("etape")).append(" : ").append(etapeName).append("</p>");
                htmlText.append("<p style='font-weight:bold'>").append(L10n.getString("epreuve")).append(" : ").append(epreuveName).append("</p>");
                htmlText.append(HtmlWriter._generateEpreuvePodiumAsHtml((EpreuveTableModel)resultTable.getModel(), resultTable, podiumValue, htmlText.toString()));
            }
        }
        return htmlText.toString();
    }

    static String refreshResults(String outputDirectoryPath, Raid raid, boolean isParcoursResultSelected, boolean useCumulativePenalites) {
        String outputFilename = outputDirectoryPath + File.separator + raid.getRaidName() + HTML_SUFFIX;
        if (isParcoursResultSelected) {
            HtmlWriter._exportParcoursAsHtml(outputFilename, raid, useCumulativePenalites);
        } else {
            HtmlWriter._generateParcoursByEtape(outputFilename, raid, useCumulativePenalites);
        }
        return outputFilename;
    }

    static void printResults(String raidName, JTable resultTable, VisualizationType visualizationType, String parcoursName, String categorieName, String etapeName, String epreuveName, boolean isShortGlobalResultPrinting) throws PrinterException {
        if (isShortGlobalResultPrinting) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            switch (visualizationType) {
                case EPREUVE: {
                    printerJob.setPrintable((EpreuveTableModel)resultTable.getModel());
                    break;
                }
                case ETAPE: {
                    printerJob.setPrintable((EtapeTableModel)resultTable.getModel());
                    break;
                }
                case PARCOURS: {
                    printerJob.setPrintable((ParcoursTableModel)resultTable.getModel());
                }
            }
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        } else {
            StringBuilder header = new StringBuilder(raidName);
            header.append(" - ").append(parcoursName);
            if (visualizationType == VisualizationType.ETAPE || visualizationType == VisualizationType.EPREUVE) {
                assert (etapeName != null);
                header.append(" - ").append(etapeName);
            }
            if (visualizationType == VisualizationType.EPREUVE) {
                header.append(" - ").append(epreuveName);
            }
            header.append(" - : ").append(categorieName);
            MessageFormat headerFormat = new MessageFormat(header.toString());
            resultTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, null);
        }
    }

    private static void _generateParcoursByEtape(String absoluteFilename, Raid geRaid, boolean useCumulativePenalites) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            StringBuilder code = new StringBuilder(HtmlWriter._generateHtmlFileHeaderCode(absoluteFilename));
            code.append("<h1>").append(geRaid.getRaidName()).append("</h1>");
            for (int i = 0; i < geRaid.getParcoursVector().getSize(); ++i) {
                Parcours parcours = geRaid.getParcoursVector().getParcoursVector().get(i);
                code.append("<p style='font-weight:bold'>").append(L10n.getString("parcours")).append(" : ").append(parcours.getName()).append("</p>");
                for (int j = 0; j < parcours.getEtapeVector().size(); ++j) {
                    Etape etape = parcours.getEtapeVector().get(j);
                    code.append("<p style='font-weight:bold'>").append(L10n.getString("etape")).append(" : ").append(etape.getName()).append("</p>");
                    EtapeResult etapeResult = new EtapeResult(geRaid, etape, null, null, null, EtapeVisualizationLevel.SIMPLE, true, useCumulativePenalites);
                    code.append("<table style='border: 1px solid #000;margin-right:auto;margin-left:auto;'>");
                    code.append(etapeResult.getTableColumnHeadersAsHtml());
                    code.append(etapeResult.getTableRowDataAsHtml());
                    code.append("</table>");
                }
            }
            code.append(HTML_FOOTER);
            writer.write(code.toString());
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.html_writer.error", e.getClass().getName(), e.getMessage()));
        }
    }

    private static void _exportParcoursAsHtml(String absoluteFilename, Raid geRaid, boolean useCumulativePenalites) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            StringBuilder code = new StringBuilder(HtmlWriter._generateHtmlFileHeaderCode(absoluteFilename));
            code.append("<h1>").append(geRaid.getRaidName()).append("</h1>");
            for (int i = 0; i < geRaid.getParcoursVector().getSize(); ++i) {
                Parcours parcours = geRaid.getParcoursVector().getParcoursVector().get(i);
                code.append("<p style='font-weight:bold'>").append(L10n.getString("parcours")).append(" : ").append(parcours.getName()).append("</p>");
                ParcoursResult parcoursResults = new ParcoursResult(geRaid, parcours, null, ParcoursVisualizationLevel.AVEC_ETAPE, true, useCumulativePenalites);
                code.append("<table style='border: 1px solid #000;margin-right:auto;margin-left:auto;'>");
                code.append(parcoursResults.getTableColumnHeadersAsHtml());
                code.append(parcoursResults.getDataAsHtml());
                code.append("</table>");
            }
            code.append(HTML_FOOTER);
            writer.write(code.toString());
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.html_writer.error", e.getClass().getName(), e.getMessage()));
        }
    }

    private static void _exportParcoursAsHtml(String absoluteFilename, ParcoursTableModel parcoursTableModel, JTable resultTable, String tableHeader) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String code = HtmlWriter._generateHtmlFileHeaderCode(absoluteFilename) + tableHeader + parcoursTableModel.getHeaderAsHtml() + parcoursTableModel.getDataAsHtml(resultTable) + HTML_FOOTER;
            writer.write(code);
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.html_writer.error", e.getClass().getName(), e.getMessage()));
        }
    }

    private static void _exportEtapeAsHtml(String absoluteFilename, EtapeTableModel etapeTableModel, JTable resultTable, String tableHeader) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String code = HtmlWriter._generateHtmlFileHeaderCode(absoluteFilename) + tableHeader + etapeTableModel.getHeaderAsHtml() + etapeTableModel.getDataAsHtml(resultTable) + HTML_FOOTER;
            writer.write(code);
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.html_writer.error", e.getClass().getName(), e.getMessage()));
        }
    }

    private static void _exportEpreuveAsHtml(String absoluteFilename, EpreuveTableModel epreuveTableModel, JTable resultTable, String tableHeader) {
        File file = new File(absoluteFilename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String code = HtmlWriter._generateHtmlFileHeaderCode(absoluteFilename) + tableHeader + epreuveTableModel.getHeaderAsHtml() + epreuveTableModel.getDataAsHtml(resultTable) + HTML_FOOTER;
            writer.write(code);
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("result_panel.html_writer.error", e.getClass().getName(), e.getMessage()));
        }
    }

    private static String _generateHtmlFileHeaderCode(String filePath) {
        File file = new File(filePath);
        return "<!DOCTYPE html><html lang=\"fr-FR\"><head><meta charset=\"UTF-8\"><meta http-equiv=\"refresh\" content=\"30\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><title>" + file.getName() + "</title></head><body style='text-align:center'>";
    }

    private static String _generateHtmlHeaderCode() {
        return "<!DOCTYPE html><html lang=\"fr-FR\"><head><meta charset=\"UTF-8\"><meta http-equiv=\"refresh\" content=\"30\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"></head><body style='text-align:center'>";
    }

    private static String _generateParcoursPodiumAsHtml(ParcoursTableModel parcoursTableModel, JTable resultTable, int index) {
        return HtmlWriter._generateHtmlHeaderCode() + parcoursTableModel.getHeaderAsHtml() + parcoursTableModel.getDataAsHtml(resultTable, index) + HTML_FOOTER;
    }

    private static String _generateEtapePodiumAsHtml(EtapeTableModel etapeTableModel, JTable resultTable, int index) {
        return HtmlWriter._generateHtmlHeaderCode() + etapeTableModel.getHeaderAsHtml() + etapeTableModel.getDataAsHtml(resultTable, index) + HTML_FOOTER;
    }

    private static String _generateEpreuvePodiumAsHtml(EpreuveTableModel epreuveTableModels, JTable resultTable, int index, String tableHeader) {
        return HtmlWriter._generateHtmlHeaderCode() + tableHeader + epreuveTableModels.getHeaderAsHtml() + epreuveTableModels.getDataAsHtml(resultTable, index) + HTML_FOOTER;
    }
}

