/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.TableModelWithHeaderTooltips;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.parcours.ParcoursResult;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public final class ParcoursTableModel
extends TableModelWithHeaderTooltips
implements Printable {
    private final transient Object[][] _data;
    private final transient ParcoursResult _parcoursResult;

    public ParcoursTableModel(ParcoursResult parcoursResult) {
        super(parcoursResult.getTableColumnHeaders(), parcoursResult.getTableColumnTooltips());
        this._parcoursResult = parcoursResult;
        this._data = parcoursResult.getTableRowData();
    }

    @Override
    public int getRowCount() {
        return this._data.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.getRowCount()) {
            if ("0".equals(String.valueOf(this._data[row][col])) || "0:00:00".equals(String.valueOf(this._data[row][col]))) {
                return "";
            }
            return this._data[row][col];
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this._data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public String[] generateDataAsCsv() {
        ArrayList<String> cvsText = new ArrayList<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String[] names;
            int categoryColumn = 3;
            String content = this.getValueAt(i, 3).toString();
            for (String name : names = content.split("\n")) {
                StringBuilder csvRow = new StringBuilder(this.getValueAt(i, 0).toString());
                for (int k = 1; k < this.getColumnCount(); ++k) {
                    if (k == 3) {
                        csvRow.append(";\"").append(name).append("\"");
                        continue;
                    }
                    csvRow.append(";\"").append(this.getValueAt(i, k)).append("\"");
                }
                cvsText.add(csvRow.toString());
            }
        }
        return cvsText.toArray(new String[0]);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int xMargin = (int)pageFormat.getImageableX();
        int yMargin = (int)pageFormat.getImageableY();
        int pageHeight = (int)pageFormat.getImageableHeight() - 8;
        int fontSize = 10;
        int headerNumberOfLine = 3;
        int totalNumberOfLines = this._data.length + 3;
        int maxLinesPerPage = pageHeight / 10;
        int totalNumberOfPages = (int)((double)totalNumberOfLines / (double)maxLinesPerPage) + 1;
        if (pageIndex < totalNumberOfPages) {
            int start = Math.max(0, pageIndex * maxLinesPerPage - 3);
            int end = Math.min(start + maxLinesPerPage - 3 - 1, this._data.length - 1);
            graphics.setColor(Color.BLACK);
            int yPosition = yMargin;
            graphics.setFont(new Font("Serif", 0, 10));
            yPosition += 10;
            if (pageIndex == 0) {
                graphics.drawString(L10n.getString("parcours_semicolon") + " " + this._parcoursResult.getParcours().getName(), xMargin, yPosition);
                graphics.drawString(L10n.getString("categorie_semicolon") + " " + this._parcoursResult.getCategorie().getLongName(), xMargin, yPosition += 10);
                yPosition += 20;
            }
            for (int i = start; i < end + 1; ++i) {
                Object[] datum = this._data[i];
                graphics.drawString(String.valueOf(datum[0]) + "  " + String.valueOf(datum[3]), xMargin, yPosition);
                yPosition += 10;
            }
            graphics.setFont(new Font("Serif", 0, 8));
            graphics.drawString("Page " + (pageIndex + 1) + " / " + totalNumberOfPages, xMargin, yMargin + pageHeight + 5);
            return 0;
        }
        return 1;
    }

    String getHeaderAsHtml() {
        int index = Math.max(this.getColumnCount(), 7);
        StringBuilder text = new StringBuilder("<table style='border: 1px solid #000;margin-right:auto;margin-left:auto;'><tr style='font-weight: bold;text-align:center'>");
        for (int i = 0; i < index; ++i) {
            if (i == 2) continue;
            text.append("<td style='").append("background-color:#000;color:#FFF;padding:5px 3px 5px 3px;").append("'>").append(this.getColumnName(i)).append("</td>");
        }
        text.append("</tr>");
        return text.toString();
    }

    String getDataAsHtml(JTable table) {
        int index = Math.max(this.getColumnCount(), 7);
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.getRowCount(); ++i) {
            text.append("<tr style='");
            if (i % 2 == 0) {
                text.append("background-color:#FFF;");
            } else {
                text.append("background-color:#EAEAEA;");
            }
            text.append("text-align:center'>");
            text.append("<td style='").append("background-color:#008000;color:#FFF;").append("'>").append(this.getValueAt(table.convertRowIndexToModel(i), 0)).append("</td>");
            for (int j = 1; j < index; ++j) {
                if (j == 2) continue;
                text.append("<td>").append(this.getValueAt(table.convertRowIndexToModel(i), j)).append("</td>");
            }
            text.append("</tr>");
        }
        text.append("</table>");
        if (this.getRowCount() < 25) {
            text.append("<br>".repeat(25 - this.getRowCount()));
        }
        return text.toString();
    }

    String getDataAsHtml(JTable table, int index) {
        StringBuilder html = new StringBuilder();
        if (this.getRowCount() < index) {
            index = this.getRowCount();
        }
        for (int i = 0; i < index; ++i) {
            html.append("<tr style=");
            if (i % 2 == 0) {
                html.append("background-color:#FFF;");
            } else {
                html.append("background-color:#EAEAEA;");
            }
            html.append(" align=center>");
            for (int j = 0; j < 7; ++j) {
                if (j == 2) continue;
                if (j == 3) {
                    String puceId = (String)this.getValueAt(table.convertRowIndexToModel(i), 2);
                    ParcoursVariante parcours = this._parcoursResult.getRaid().getParcoursFromIdPuce(puceId).getVarianteFromPuceId(puceId);
                    Equipe equipe = parcours.getEquipeVector().getEquipeFromPuceId(puceId);
                    html.append("<td><b>").append(this.getValueAt(table.convertRowIndexToModel(i), j)).append("</b>");
                    assert (equipe != null);
                    List<Equipier> equipierVector = equipe.getEquipierVector().getEquipierVector();
                    for (Equipier equipier : equipierVector) {
                        html.append("<br>").append(equipier.toString());
                    }
                    html.append("</td>");
                    continue;
                }
                html.append("<td>").append(this.getValueAt(table.convertRowIndexToModel(i), j)).append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
        return html.toString();
    }
}

