/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.PuceResultManagementDialog;
import fr.geraidv3.desktop.result_panel.AutomaticHtmlExportTask;
import fr.geraidv3.desktop.result_panel.CsvWriter;
import fr.geraidv3.desktop.result_panel.EpreuveTableModel;
import fr.geraidv3.desktop.result_panel.EtapeTableModel;
import fr.geraidv3.desktop.result_panel.HtmlWriter;
import fr.geraidv3.desktop.result_panel.ParcoursTableModel;
import fr.geraidv3.desktop.result_panel.ResultView;
import fr.geraidv3.desktop.result_panel.VisualizationType;
import fr.geraidv3.desktop.setting_menu.PublicationClient;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.FileUtils;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.JTable;

final class ResultPresenter {
    private final DesktopPresenter _parentPresenter;
    private final ResultView _view;
    private AutomaticHtmlExportTask _automaticHtmlExportTask;

    ResultPresenter(DesktopPresenter presenter, ResultView view) {
        this._parentPresenter = presenter;
        this._view = view;
    }

    String exportResultIntoHtmlFile(VisualizationType visualizationType, String parcoursName, String categorieName, String etapeName, String epreuveName, JTable resultTable, boolean withPublicationOnWebSite) {
        String absoluteFilename = HtmlWriter.exportResults(this._parentPresenter.getGlobalSettings().getBackupDirectoryPath(), this.getRaid().getRaidName(), visualizationType, parcoursName, categorieName, etapeName, epreuveName, resultTable);
        if (absoluteFilename != null && withPublicationOnWebSite && this.showConnectionViewIfNeeded()) {
            File file = new File(absoluteFilename);
            this._publishOnWebsite(file.getName(), absoluteFilename);
        }
        return absoluteFilename;
    }

    boolean exportResultIntoHtmlFile() {
        return this._view.exportResultIntoHtmlFile();
    }

    boolean existBackupDirectory() {
        File directory = new File(this._parentPresenter.getGlobalSettings().getBackupDirectoryPath());
        return directory.exists();
    }

    void setExportStatusFailure() {
        this._view.setExportFailure();
    }

    void setExportStatusNormal() {
        this._view.setExportNormal();
    }

    void setExportStatusSuccess() {
        this._view.setExportSuccess();
    }

    void setEnabledDisplayTeammate(boolean selected) {
        this._parentPresenter.getRaid().setEnabledDisplayTeammate(selected);
        this._parentPresenter.refreshResultTable();
    }

    long getPublishingFrequencyInS() {
        return this._view.getPublishingFrequencyInS();
    }

    void fillCategoriesComboBox() {
        this._view.fillCategoryComboBox();
        this._parentPresenter.refreshResultTable();
    }

    boolean runOrStopAutomaticExportResultsAsHtml() {
        if (this._automaticHtmlExportTask != null) {
            this._automaticHtmlExportTask.stop();
            this._automaticHtmlExportTask = null;
            return false;
        }
        this._automaticHtmlExportTask = new AutomaticHtmlExportTask(this);
        this._automaticHtmlExportTask.execute();
        return true;
    }

    void displaySPORTIdentResults(Parcours parcours, Etape etape, String puce) {
        if (this.getRaid().getPuceResultVector().getSize() > 0) {
            PuceResultManagementDialog dialog = new PuceResultManagementDialog(this._parentPresenter.getFrame(), this._parentPresenter, parcours, etape, this.getRaid().getEquipeFromPuceId(puce), puce);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
    }

    void displayReduceResults(Parcours parcours, Etape etape, String chip) {
        PuceResult puceResult = this._parentPresenter.getRaid().getPuceResultVector().getPuceResult(parcours, etape, chip);
        if (puceResult != null) {
            this._parentPresenter.showSportIdentResulDialog(puceResult, true, true, true);
        }
    }

    void displayCompleteResults(Parcours parcours, Etape etape, String chip) {
        PuceResult chipResult = this._parentPresenter.getRaid().getPuceResultVector().getPuceResult(parcours, etape, chip);
        if (chipResult != null) {
            this._parentPresenter.showSportIdentResulDialog(chipResult, true, true, false);
        }
    }

    String getRaidFolderPath() {
        return this._parentPresenter.getGlobalSettings().getWorkingDirectoryPath();
    }

    Raid getRaid() {
        return this._parentPresenter.getRaid();
    }

    String exportPodiumAsHtml(VisualizationType visualizationType, Parcours parcours, Categorie categorie, Etape etape, String epreuveName, JTable table, int podiumValue) {
        return HtmlWriter.exportPodiumAsHtml(parcours.getName(), categorie.getLongName(), etape.getName(), epreuveName, table, podiumValue, visualizationType);
    }

    String refreshResults(boolean isParcoursResultSelected) {
        return HtmlWriter.refreshResults(this._parentPresenter.getGlobalSettings().getBackupDirectoryPath(), this.getRaid(), isParcoursResultSelected, this._view.isCumulativePenalites());
    }

    void printResults(JTable table, VisualizationType visualizationType, Parcours parcours, Categorie categorie, Etape etape, Epreuve epreuve) throws PrinterException {
        HtmlWriter.printResults(this.getRaid().getRaidName(), table, visualizationType, parcours.getName(), categorie.getShortName(), etape.getName(), epreuve.getName(), this._parentPresenter.getGlobalSettings().isShortGlobalResultPrinting());
    }

    void exportResultAsCSV(String filePath, JTable table, VisualizationType visualizationType) {
        String file = FileUtils.checkExtension(filePath, ".csv");
        switch (visualizationType) {
            case ETAPE: {
                CsvWriter.export((EtapeTableModel)table.getModel(), file);
                break;
            }
            case PARCOURS: {
                CsvWriter.export((ParcoursTableModel)table.getModel(), file);
                break;
            }
            case EPREUVE: {
                CsvWriter.export((EpreuveTableModel)table.getModel(), file);
            }
        }
    }

    boolean showConnectionViewIfNeeded() {
        GlobalSettings globalSettings = this._parentPresenter.getGlobalSettings();
        if (globalSettings.getPublicationSettings().hasEmptyParameters()) {
            this._parentPresenter.configurePublicationSettings();
            return !globalSettings.getPublicationSettings().hasEmptyParameters();
        }
        return true;
    }

    private void _publishOnWebsite(String filename, String sourceAbsoluteFilename) {
        try {
            GlobalSettings globalSettings = this._parentPresenter.getGlobalSettings();
            PublicationClient.publish(globalSettings.getPublicationSettings(), filename, sourceAbsoluteFilename);
        }
        catch (Exception exception) {
            ErrorPane.showMessageDialog(this._view.getRootPane(), exception.getMessage());
        }
    }
}

