/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.categorie.Categorie;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class GlobalSettingsFile {
    private static final String SETTING_FILE_NAME = "config.xml";
    private static final String CONFIG = "config";
    private static final String CLUB_NAME = "nom";
    private static final String CATEGORIES = "categories";
    private static final String CATEGORY = "categorie";
    private static final String LONG_NAME = "nomLong";
    private static final String SHORT_NAME = "nomCourt";
    private static final String WORKING_FOLDER = "dossierTravail";
    private static final String SAVE_FOLDER = "dossierSauvegarde";
    private static final String TICKET = "ticket";
    private static final String PRINTING = "print";
    private static final String TOOLTIPS = "tooltips";
    private static final String FONT_SCALE = "fontScale";
    private static final String POINTS = "points";
    private static final String TIME = "temps";
    private static final String MISPUNCH_PENALTY_POINTS = "pointsPm";
    private static final String MISPUNCH_PENALTY_TIME = "tempsPm";

    private GlobalSettingsFile() {
    }

    static void load(GlobalSettings globalSettings, String settingsDirectory) {
        String settingAbsoluteFileName = GlobalSettingsFile._getSettingAbsoluteFileName(settingsDirectory);
        File defaultDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        try {
            GlobalSettingsFile._loadGlobalSettingFromXmlFile(globalSettings, settingAbsoluteFileName, defaultDirectory.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("settings_handle.error1") + " " + e.getClass().getName() + ", " + e.getMessage());
        }
    }

    static void save(GlobalSettings globalSettings, String settingsDirectory) {
        String settingAbsoluteFileName = GlobalSettingsFile._getSettingAbsoluteFileName(settingsDirectory);
        try {
            Document document = GlobalSettingsFile._saveGlobalSettingsAsXml(globalSettings);
            DOMSource source = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            StreamResult result = new StreamResult(new File(settingAbsoluteFileName));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | TransformerException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("settings_handle.error2") + " " + e.getClass().getName() + ", " + e.getMessage());
        }
    }

    @VisibleForTesting
    static Document _saveGlobalSettingsAsXml(GlobalSettings globalSettings) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement(CONFIG);
        document.appendChild(root);
        GlobalSettingsFile._saveElement(document, root, CLUB_NAME, globalSettings.getClubName());
        GlobalSettingsFile._saveElement(document, root, WORKING_FOLDER, globalSettings.getWorkingDirectoryPath());
        GlobalSettingsFile._saveElement(document, root, SAVE_FOLDER, globalSettings.getBackupDirectoryPath());
        GlobalSettingsFile._saveElement(document, root, TICKET, globalSettings.getIsShortIndividualResultPrintingAsString());
        GlobalSettingsFile._saveElement(document, root, PRINTING, globalSettings.getIsShortGlobalResultPrintingAsString());
        GlobalSettingsFile._saveElement(document, root, TOOLTIPS, GlobalSettingsFile._encodeBoolean(globalSettings.isTooltipsEnabled()));
        GlobalSettingsFile._saveElement(document, root, FONT_SCALE, "" + globalSettings.getFontScale());
        Element categories = document.createElement(CATEGORIES);
        Vector<Categorie> categorieVector = globalSettings.getCategoriesTemplate().getCategorieVector();
        for (Categorie categorie : categorieVector) {
            Element category = document.createElement(CATEGORY);
            GlobalSettingsFile._saveElement(document, category, LONG_NAME, categorie.getLongName());
            GlobalSettingsFile._saveElement(document, category, SHORT_NAME, categorie.getShortName());
            categories.appendChild(category);
        }
        GlobalSettingsFile._saveElement(document, root, POINTS, "" + globalSettings.getPunchPointsBonus());
        GlobalSettingsFile._saveElement(document, root, TIME, "" + globalSettings.getPunchTimeBonusInS());
        GlobalSettingsFile._saveElement(document, root, MISPUNCH_PENALTY_POINTS, "" + globalSettings.getMispunchPointsPenalty());
        GlobalSettingsFile._saveElement(document, root, MISPUNCH_PENALTY_TIME, "" + globalSettings.getMispunchTimePenaltyInS());
        root.appendChild(categories);
        return document;
    }

    @VisibleForTesting
    static void _loadGlobalSettingFromXmlFile(GlobalSettings globalSettings, String settingsFilePath, String defaultDirectoryPath) throws IOException, ParserConfigurationException, SAXException {
        Node fontScaleElement;
        Node tooltips;
        Node printing;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream input = new FileInputStream(settingsFilePath);
        InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
        Document document = builder.parse(new InputSource(reader));
        document.getDocumentElement().normalize();
        Node clubName = document.getElementsByTagName(CLUB_NAME).item(0);
        globalSettings.setClubName(clubName.getFirstChild().getTextContent().trim());
        Node workingNode = document.getElementsByTagName(WORKING_FOLDER).item(0);
        File workingDirectory = new File(workingNode.getFirstChild().getTextContent().trim());
        if (workingDirectory.exists()) {
            globalSettings.setWorkingDirectoryPath(workingNode.getFirstChild().getTextContent().trim());
        } else {
            globalSettings.setWorkingDirectoryPath(defaultDirectoryPath);
        }
        Node backupNode = document.getElementsByTagName(SAVE_FOLDER).item(0);
        File backupDirectory = new File(backupNode.getFirstChild().getTextContent().trim());
        if (backupDirectory.exists()) {
            globalSettings.setBackupDirectoryPath(backupNode.getFirstChild().getTextContent().trim());
        } else {
            globalSettings.setBackupDirectoryPath(defaultDirectoryPath);
        }
        Node ticket = document.getElementsByTagName(TICKET).item(0);
        if (ticket != null) {
            int value = Integer.parseInt(ticket.getFirstChild().getTextContent().trim());
            globalSettings.setShortIndividualResultPrinting(value == 1);
        }
        if ((printing = document.getElementsByTagName(PRINTING).item(0)) != null) {
            int bool = Integer.parseInt(printing.getFirstChild().getTextContent().trim());
            globalSettings.setShortGlobalResultPrinting(bool == 1);
        }
        if ((tooltips = document.getElementsByTagName(TOOLTIPS).item(0)) != null) {
            int bool = Integer.parseInt(tooltips.getFirstChild().getTextContent().trim());
            globalSettings.setTooltipsEnabled(bool == 1);
        }
        if ((fontScaleElement = document.getElementsByTagName(FONT_SCALE).item(0)) != null) {
            int value = Integer.parseInt(fontScaleElement.getFirstChild().getTextContent().trim());
            globalSettings.setFontScale(value);
        }
        GlobalSettingsFile._loadAllCategories(globalSettings, document);
        Node points = document.getElementsByTagName(POINTS).item(0);
        if (points != null) {
            globalSettings.setPunchPointsBonus(Integer.parseInt(points.getFirstChild().getTextContent()));
            Node time = document.getElementsByTagName(TIME).item(0);
            globalSettings.setPunchTimeBonusInS(Integer.parseInt(time.getFirstChild().getTextContent()));
            Node mispunchPenaltyPoints = document.getElementsByTagName(MISPUNCH_PENALTY_POINTS).item(0);
            globalSettings.setMispunchPointsPenalty(Integer.parseInt(mispunchPenaltyPoints.getFirstChild().getTextContent()));
            Node mispunchPenaltyTime = document.getElementsByTagName(MISPUNCH_PENALTY_TIME).item(0);
            globalSettings.setMispunchTimePenaltyInS(Integer.parseInt(mispunchPenaltyTime.getFirstChild().getTextContent()));
        }
    }

    private static void _saveElement(Document document, Element root, String tag, String value) {
        Element element = document.createElement(tag);
        element.appendChild(document.createTextNode(value));
        root.appendChild(element);
    }

    private static void _loadAllCategories(GlobalSettings globalSettings, Document root) {
        NodeList categories = root.getElementsByTagName(CATEGORY);
        for (int i = 0; i < categories.getLength(); ++i) {
            Node item = categories.item(i);
            if (item.getNodeType() != 1) continue;
            Element element = (Element)item;
            String longName = element.getElementsByTagName(LONG_NAME).item(0).getTextContent();
            String shortName = element.getElementsByTagName(SHORT_NAME).item(0).getTextContent();
            Categorie categorie = new Categorie(longName, shortName);
            globalSettings.getCategoriesTemplate().addCategorie(categorie);
        }
    }

    private static String _getSettingAbsoluteFileName(String settingsDirectory) {
        return settingsDirectory + File.separator + SETTING_FILE_NAME;
    }

    private static String _encodeBoolean(boolean value) {
        return value ? "1" : "0";
    }
}

