/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.setting_menu.PublicationClient;
import fr.geraidv3.desktop.setting_menu.PublicationPresenter;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.GlobalSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class PublicationView
extends GDialog {
    private final transient PublicationPresenter _presenter;
    private final transient Consumer<GlobalSettings.PublicationSettings> _updateCallback;
    private final String _inputHost;
    private final String _inputUsername;
    private final String _inputDestination;
    private final String _inputPassword;
    private JTextField _host;
    private JTextField _username;
    private JPasswordField _password;
    private JTextField _destination;
    private JButton _saveButton;
    private JButton _connectionTestButton;

    public PublicationView(DesktopPresenter presenter, Consumer<GlobalSettings.PublicationSettings> updateCallback) {
        super(presenter.getFrame());
        this._presenter = new PublicationPresenter(presenter);
        this._updateCallback = updateCallback;
        this._inputHost = this._presenter.getHost();
        this._inputUsername = this._presenter.getUsername();
        this._inputDestination = this._presenter.getDestination();
        this._inputPassword = this._presenter.getPassword();
        this._initializeUI();
        this._updateButtons();
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString("connection_view.title"));
        this.setResizable(false);
        this.setModal(true);
        this.setMinimumSize(new Dimension(500, 100));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.add((Component)this._getContentPane(), "Center");
        panel.add((Component)this._getButtonPanel(), "South");
        this.setContentPane(panel);
        this.pack();
        this.setDefaultButton(this._saveButton);
    }

    private JPanel _getContentPane() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.anchor = 17;
        c1.weightx = 0.0;
        c1.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)new JLabel(L10n.getString("connection_view.host.label")), c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weightx = 1.0;
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)this._createHostTextField(), c2);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 1;
        c3.anchor = 17;
        c3.weightx = 0.0;
        c3.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)new JLabel(L10n.getString("connection_view.destination.label")), c3);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridx = 1;
        c4.gridy = 1;
        c4.weightx = 1.0;
        c4.fill = 2;
        c4.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)this._createDestinationFolderTextField(), c4);
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridx = 0;
        c5.gridy = 2;
        c5.anchor = 17;
        c5.weightx = 0.0;
        c5.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)new JLabel(L10n.getString("connection_view.username.label")), c5);
        GridBagConstraints c6 = new GridBagConstraints();
        c6.gridx = 1;
        c6.gridy = 2;
        c6.weightx = 1.0;
        c6.fill = 2;
        c6.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)this._createUsernameTextField(), c6);
        GridBagConstraints c7 = new GridBagConstraints();
        c7.gridx = 0;
        c7.gridy = 3;
        c7.anchor = 17;
        c7.weightx = 0.0;
        c7.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel(L10n.getString("connection_view.password.label"));
        contentPanel.add((Component)label, c7);
        GridBagConstraints c8 = new GridBagConstraints();
        c8.gridx = 1;
        c8.gridy = 3;
        c8.weightx = 1.0;
        c8.fill = 2;
        c8.insets = new Insets(5, 5, 5, 5);
        contentPanel.add((Component)this._createPasswordTextField(), c8);
        return contentPanel;
    }

    private JTextField _createHostTextField() {
        this._host = new JTextField(this._presenter.getHost());
        this._host.setToolTipText(L10n.getString("connection_view.host.tooltip"));
        this._host.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }
        });
        return this._host;
    }

    private JTextField _createDestinationFolderTextField() {
        this._destination = new JTextField(this._presenter.getDestination());
        this._destination.setToolTipText(L10n.getString("connection_view.destination.tooltip"));
        this._destination.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }
        });
        return this._destination;
    }

    private JTextField _createUsernameTextField() {
        this._username = new JTextField(this._presenter.getUsername());
        this._username.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }
        });
        return this._username;
    }

    private JPasswordField _createPasswordTextField() {
        this._password = new JPasswordField(this._presenter.getPassword());
        this._password.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                PublicationView.this._updateButtons();
            }
        });
        return this._password;
    }

    private JPanel _getButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this._createTestConnectionButton());
        panel.add(this._createSaveButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private void _updateButtons() {
        String password = new String(this._password.getPassword()).trim();
        this._connectionTestButton.setEnabled(!this._host.getText().trim().isEmpty() && !this._username.getText().trim().isEmpty() && !password.isEmpty());
        boolean modified = !this._host.getText().trim().equals(this._inputHost) || !this._destination.getText().trim().equals(this._inputDestination) || !this._username.getText().trim().equals(this._inputUsername) || !password.equals(this._inputPassword);
        this._saveButton.setEnabled(modified);
    }

    private JButton _createTestConnectionButton() {
        this._connectionTestButton = new JButton(L10n.getString("connection_view.test_button"));
        this._connectionTestButton.addActionListener(event -> {
            GlobalSettings.PublicationSettings settings = new GlobalSettings.PublicationSettings(this._host.getText().trim(), this._destination.getText().trim(), this._username.getText().trim(), new String(this._password.getPassword()));
            boolean answer = PublicationClient.checkConnection(settings);
            if (answer) {
                JOptionPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("connection_view.test_success"), L10n.getString("connection_view.test_title"), 1);
            } else {
                ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("connection_view.test_failure"));
            }
        });
        return this._connectionTestButton;
    }

    private JButton _createSaveButton() {
        this._saveButton = new JButton(L10n.getString("connection_view.save_button"));
        this._saveButton.addActionListener(event -> {
            GlobalSettings.PublicationSettings settings = new GlobalSettings.PublicationSettings(this._host.getText().trim(), this._destination.getText().trim(), this._username.getText().trim(), new String(this._password.getPassword()));
            this._updateCallback.accept(settings);
            this.dispose();
        });
        return this._saveButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

