/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.result_panel.EtapeTableModel;
import fr.geraidv3.desktop.result_panel.ParcoursTableModel;
import fr.geraidv3.desktop.simulation.SimulationPresenter;
import fr.geraidv3.desktop.swing_ext.TableWithHeaderTooltips;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@ExcludeFromJacocoGeneratedReport
final class ClassificationView
extends JPanel {
    private final transient SimulationPresenter _presenter;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final JComboBox<Categorie> _categoryComboBox = new JComboBox();
    private JTable _resultTable;
    private JRadioButton _etapeRadioButton;
    private JRadioButton _parcoursRadioButton;

    ClassificationView(SimulationPresenter presenter, JComboBox<Parcours> parcoursComboBox) {
        super(new BorderLayout());
        this._presenter = presenter;
        this._parcoursComboBox = parcoursComboBox;
        this._initializeUI();
    }

    void refreshTable() {
        if (this._parcoursComboBox.getSelectedIndex() >= 0) {
            if (this._categoryComboBox.getModel().getSize() <= 0) {
                this._fillCategoriesComboBox();
            }
            if (this._parcoursRadioButton.isSelected()) {
                this._resultTable.setModel(new ParcoursTableModel(this._presenter.createParcoursResult(this._categoryComboBox)));
            } else {
                this._resultTable.setModel(new EtapeTableModel(this._presenter.createEtapeResult(this._categoryComboBox)));
            }
            this._updateTableColumnModel();
        } else {
            this._resultTable.setModel(new DefaultTableModel());
        }
    }

    private void _initializeUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._createControlPanel(), "North");
        this.add((Component)this._createResultsPanel(), "Center");
    }

    private JPanel _createControlPanel() {
        FlowLayout layout = new FlowLayout(3);
        layout.setAlignOnBaseline(true);
        JPanel panel = new JPanel(layout);
        panel.add(this._createTypeToolbar());
        panel.add(this._createFilterToolbar());
        return panel;
    }

    private JComponent _createResultsPanel() {
        JTable table = this._createDetailedResultsTable();
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        return scrollPane;
    }

    private void _fillCategoriesComboBox() {
        this._categoryComboBox.removeAllItems();
        this._categoryComboBox.addItem(new Categorie(L10n.getString("result_view.detailed_result.categorie.label1"), L10n.getString("result_view.detailed_result.categorie.label2")));
        List<Categorie> categorieVector = this._presenter.getCategorieVector();
        for (Categorie categorie : categorieVector) {
            this._categoryComboBox.addItem(categorie);
        }
        this._categoryComboBox.setSelectedIndex(0);
    }

    private void _updateTableColumnModel() {
        int i;
        DefaultTableCellRenderer rightCellRender = new DefaultTableCellRenderer();
        rightCellRender.setHorizontalAlignment(0);
        TableColumnModel columnModel = this._resultTable.getColumnModel();
        for (i = 0; i < columnModel.getColumnCount(); ++i) {
            if (i == 3) continue;
            columnModel.getColumn(i).setCellRenderer(rightCellRender);
        }
        for (i = 0; i < this._resultTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this._resultTable.getColumnModel().getColumn(i);
            int preferredWidth = tableColumn.getPreferredWidth();
            int maxWidth = tableColumn.getMaxWidth();
            for (int row = 0; row < this._resultTable.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = this._resultTable.getCellRenderer(row, i);
                Component c = this._resultTable.prepareRenderer(cellRenderer, row, i);
                int width = c.getPreferredSize().width + this._resultTable.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            tableColumn.setPreferredWidth((int)((double)preferredWidth * 1.2));
        }
    }

    private JTable _createDetailedResultsTable() {
        this._resultTable = new TableWithHeaderTooltips();
        this._resultTable.setAutoResizeMode(4);
        this._resultTable.setSelectionMode(0);
        this._resultTable.getTableHeader().setReorderingAllowed(false);
        this._resultTable.getTableHeader().setBackground(Color.BLACK);
        this._resultTable.getTableHeader().setForeground(Color.WHITE);
        this._resultTable.setFocusable(true);
        this._resultTable.setAutoCreateRowSorter(true);
        Font font = this._resultTable.getTableHeader().getFont();
        this._resultTable.getTableHeader().setFont(font.deriveFont(12.0f));
        return this._resultTable;
    }

    private JRadioButton _createEtapeRadioButton() {
        this._etapeRadioButton = new JRadioButton(L10n.getString("result_view.detailed_result.type.choice2"));
        this._etapeRadioButton.addActionListener(event -> this._presenter.refreshResultTable());
        this._etapeRadioButton.setSelected(true);
        return this._etapeRadioButton;
    }

    private JRadioButton _createParcoursButton() {
        this._parcoursRadioButton = new JRadioButton(L10n.getString("result_view.detailed_result.type.choice3"));
        this._parcoursRadioButton.addActionListener(event -> this._presenter.refreshResultTable());
        return this._parcoursRadioButton;
    }

    private JPanel _createTypeToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.type.title"), 4, 2));
        panel.add(this._createParcoursButton());
        panel.add(this._createEtapeRadioButton());
        ButtonGroup group = new ButtonGroup();
        group.add(this._etapeRadioButton);
        group.add(this._parcoursRadioButton);
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JPanel _createFilterToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.filter.title"), 4, 2));
        panel.add(new JLabel(L10n.getString("result_view.detailed_result.filter.label1")));
        panel.add(this._createCategorieComboBox());
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JComboBox<Categorie> _createCategorieComboBox() {
        Dimension preferredSize = this._categoryComboBox.getPreferredSize();
        preferredSize.width = 100;
        this._categoryComboBox.setPreferredSize(preferredSize);
        this._categoryComboBox.addActionListener(event -> this._presenter.refreshResultTable());
        return this._categoryComboBox;
    }
}

