/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.simulation.SimulationPresenter;
import fr.geraidv3.desktop.sportident_panel.DocumentRenderer;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.text.html.HTMLDocument;

@ExcludeFromJacocoGeneratedReport
final class GenerationView
extends JPanel {
    private final transient SimulationPresenter _presenter;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final JComboBox<Etape> _etapeComboBox;
    private final JList<Equipe> _equipeList;
    private final JEditorPane _resultPane = new JEditorPane();
    private JButton _resetButton;
    private JButton _deleteButton;
    private JButton _editButton;

    GenerationView(SimulationPresenter presenter, JComboBox<Parcours> parcoursComboBox, JComboBox<Etape> etapeComboBox, JList<Equipe> equipeList) {
        this._presenter = presenter;
        this._parcoursComboBox = parcoursComboBox;
        this._etapeComboBox = etapeComboBox;
        this._equipeList = equipeList;
        this._initializeUI();
    }

    public void printResult() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        DocumentRenderer documentRenderer = new DocumentRenderer(this._resultPane);
        documentRenderer.setScale(0.66);
        printerJob.setPrintable(documentRenderer, pageFormat);
        try {
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    void updateResultView(String htmlCode) {
        if (htmlCode == null) {
            this._resultPane.setVisible(false);
        } else {
            this._resultPane.setText(htmlCode);
            this._resultPane.setCaretPosition(0);
            this._resultPane.setVisible(true);
        }
    }

    void updateButtonState() {
        boolean isEtapeSelected = this._presenter.isEtapeSelected();
        boolean isEquipeSelected = this._presenter.isEquipeSelected();
        this._editButton.setEnabled(isEtapeSelected && isEquipeSelected);
        this._deleteButton.setEnabled(isEtapeSelected && isEquipeSelected);
        this._resetButton.setEnabled(this._presenter.isNotEmptyEquipeList());
    }

    private void _initializeUI() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel1 = this._createToolBar();
        panel1.setAlignmentX(0.0f);
        this.add(panel1);
        JPanel panel2 = this._createSelectionPanel();
        panel2.setAlignmentX(0.0f);
        this.add(panel2);
        JPanel panel3 = this._createResultPanel();
        panel3.setAlignmentX(0.0f);
        this.add(panel3);
    }

    private JPanel _createToolBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new TitledBorder(null, L10n.getString("simulator.command.title"), 4, 2));
        panel.add(this._createAddResultsButton());
        panel.add(this._createEditResultButton());
        panel.add(this._createDeleteResultButton());
        panel.add(this._createClearButton());
        return panel;
    }

    private Component _createAddResultsButton() {
        IconButton button = new IconButton("add-24.png");
        button.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        button.setToolTipText(L10n.getString("simulator.generate.tooltip"));
        button.addActionListener(event -> this._presenter.addRandomResults());
        return button;
    }

    private Component _createEditResultButton() {
        this._editButton = new IconButton("edit-24.png");
        this._editButton.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this._editButton.setToolTipText(L10n.getString("simulator.edit.tooltip"));
        this._editButton.addActionListener(event -> this._presenter.editResult());
        return this._editButton;
    }

    private Component _createDeleteResultButton() {
        this._deleteButton = new IconButton("delete-24.png");
        this._deleteButton.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this._deleteButton.setToolTipText(L10n.getString("simulator.delete.tooltip"));
        this._deleteButton.addActionListener(event -> this._presenter.deleteResult());
        return this._deleteButton;
    }

    private Component _createClearButton() {
        this._resetButton = new IconButton("trash-24.png");
        this._resetButton.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this._resetButton.setToolTipText(L10n.getString("simulator.clear_results.tooltip"));
        this._resetButton.addActionListener(event -> this._presenter.clearResultsForCurrentParcours());
        return this._resetButton;
    }

    private JPanel _createSelectionPanel() {
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBorder(new TitledBorder(null, L10n.getString("simulator.selection.title"), 4, 2));
        selectionPanel.setLayout(new BoxLayout(selectionPanel, 1));
        selectionPanel.add(this._createSelectorsPanel());
        selectionPanel.add(this._createEquipesScrollPane());
        return selectionPanel;
    }

    private JPanel _createSelectorsPanel() {
        JPanel comboBoxPanel = new JPanel(new FlowLayout(0));
        comboBoxPanel.add(new JLabel(L10n.getString("simulator.parcours")));
        comboBoxPanel.add(this._createParcoursComboBox());
        comboBoxPanel.add(new JLabel(L10n.getString("simulator.etape")));
        comboBoxPanel.add(this._createEtapeComboBox());
        return comboBoxPanel;
    }

    private JComboBox<Parcours> _createParcoursComboBox() {
        this._parcoursComboBox.addActionListener(event -> this._presenter.selectParcours());
        return this._parcoursComboBox;
    }

    private JComboBox<Etape> _createEtapeComboBox() {
        this._etapeComboBox.addActionListener(event -> this._presenter.updateResult());
        return this._etapeComboBox;
    }

    private JScrollPane _createEquipesScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(this._createEquipeList());
        return scrollPane;
    }

    private JList<Equipe> _createEquipeList() {
        this._equipeList.setMinimumSize(new Dimension(500, 0));
        this._equipeList.setSelectionMode(0);
        this._equipeList.setCellRenderer(new EquipeListSimulatorCellRenderer(this));
        this._equipeList.addListSelectionListener(event -> this._presenter.updateResult());
        this._equipeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    GenerationView.this._presenter.editResult();
                }
                GenerationView.this.updateButtonState();
            }
        });
        SwingUtils.addDeleteShortcut(this._equipeList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerationView.this._presenter.deleteResult();
            }
        });
        return this._equipeList;
    }

    private JPanel _createResultPanel() {
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.setBorder(new TitledBorder(null, L10n.getString("simulator.result.title"), 4, 2));
        resultPanel.add((Component)this._createResultJScrollPane(), "Center");
        return resultPanel;
    }

    private JComponent _createResultJScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(1100, 300));
        scrollPane.setViewportView(this._createDetailedResultPanel());
        scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        return scrollPane;
    }

    private JComponent _createDetailedResultPanel() {
        JPanel resultPanel = new JPanel(new BorderLayout());
        this._resultPane.setContentType("text/html; charset=UTF-8");
        this._resultPane.setBackground(Color.white);
        this._resultPane.setEditable(false);
        this._resultPane.setFocusable(false);
        this._resultPane.setDocument(new HTMLDocument());
        resultPanel.add((Component)this._resultPane, "Center");
        return resultPanel;
    }

    private Parcours _getSelectedParcours() {
        return (Parcours)this._parcoursComboBox.getSelectedItem();
    }

    @ExcludeFromJacocoGeneratedReport
    private static final class EquipeListSimulatorCellRenderer
    extends JLabel
    implements ListCellRenderer<Equipe> {
        private final GenerationView _parent;

        EquipeListSimulatorCellRenderer(GenerationView parent) {
            this.setOpaque(true);
            this._parent = parent;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Equipe> list, Equipe equipe, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setForeground(this._copyColor(list.getSelectionForeground()));
                this.setBackground(this._copyColor(list.getSelectionBackground()));
            } else {
                this.setBackground(this._copyColor(list.getBackground()));
                this.setForeground(this._copyColor(list.getForeground()));
            }
            this.setText("<html>" + equipe.toString() + " (<span style='font-style:italic;'>" + String.valueOf(this._parent._getSelectedParcours().getVarianteFromEquipe(equipe)) + "</span>)</html>");
            this.setEnabled(list.isEnabled());
            return this;
        }

        private Color _copyColor(Color color) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
    }
}

