/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.PartialEditorDialog;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.StartType;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

@ExcludeFromJacocoGeneratedReport
final class RandomResultEditor
extends GDialog {
    private final transient PuceResult _puceResult;
    private JList<Partiel> _baliseList;

    RandomResultEditor(JFrame parent, PuceResult puceResult) {
        super(parent);
        this._puceResult = puceResult;
        this._initializeUI();
        this.setAlwaysOnTop(true);
        this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
        this._baliseList.setSelectedIndex(0);
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("random_result_editor.title"));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this._createContentPanel(), "Center");
        this.setContentPane(pane);
        this.pack();
    }

    private JPanel _createContentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(this._createInformationPanel());
        contentPanel.add(this._createParametersPanel());
        contentPanel.add(this._createPunchesPanel());
        return contentPanel;
    }

    private JPanel _createInformationPanel() {
        JPanel infoPanel = new JPanel();
        JLabel label1 = new JLabel(L10n.getString("parcours_semicolon") + " " + String.valueOf(this._puceResult.getParcours()));
        label1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        infoPanel.add(label1);
        JLabel label2 = new JLabel(L10n.getString("etape_semicolon") + " " + String.valueOf(this._puceResult.getEtape()));
        label2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        infoPanel.add(label2);
        JLabel label3 = new JLabel(L10n.getString("equipe_semicolon") + " " + this._puceResult.getEquipe().getName());
        label3.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        infoPanel.add(label3);
        return infoPanel;
    }

    private JPanel _createParametersPanel() {
        JPanel outPanel = new JPanel(new FlowLayout(0));
        outPanel.setBorder(new TitledBorder(null, L10n.getString("random_result_editor.result_panel.title"), 4, 2));
        JPanel panel = new JPanel(new GridLayout(2, 4));
        panel.add(new JLabel(L10n.getString("random_result_editor.result_panel.start")));
        JPanel row11 = new JPanel();
        row11.add(this._createStartHourSpinner());
        row11.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(row11);
        JPanel row12 = new JPanel();
        row12.add(this._createStartMinuteSpinner());
        row12.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(row12);
        JPanel row13 = new JPanel();
        row13.add(this._createStartSecondSpinner());
        row13.add(new JLabel(L10n.getString("second_abbreviation")));
        panel.add(row13);
        panel.add(new JLabel(L10n.getString("random_result_editor.result_panel.finish")));
        JPanel row21 = new JPanel();
        row21.add(this._createFinishHourSpinner());
        row21.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(row21);
        JPanel row22 = new JPanel();
        row22.add(this._createFinishMinuteSpinner());
        row22.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(row22);
        JPanel row23 = new JPanel();
        row23.add(this._createFinishSecondSpinner());
        row23.add(new JLabel(L10n.getString("second_abbreviation")));
        panel.add(row23);
        outPanel.add(panel);
        return outPanel;
    }

    private JSpinner _createStartHourSpinner() {
        JSpinner startHourSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getHoursFromDate(this._puceResult.getPuce().getStartTime()), 0, 23, 1));
        startHourSpinner.setEditor(new JSpinner.NumberEditor(startHourSpinner, "00"));
        startHourSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setHoursToDate(this._puceResult.getPuce().getStartTime(), (Integer)startHourSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        startHourSpinner.setEnabled(this._puceResult.getEtape().getStartType() == StartType.BOITIER);
        return startHourSpinner;
    }

    private JSpinner _createStartMinuteSpinner() {
        JSpinner startMinuteSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getMinutesFromDate(this._puceResult.getPuce().getStartTime()), 0, 59, 1));
        startMinuteSpinner.setEditor(new JSpinner.NumberEditor(startMinuteSpinner, "00"));
        startMinuteSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setMinutesToDate(this._puceResult.getPuce().getStartTime(), (Integer)startMinuteSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        startMinuteSpinner.setEnabled(this._puceResult.getEtape().getStartType() == StartType.BOITIER);
        return startMinuteSpinner;
    }

    private JSpinner _createStartSecondSpinner() {
        JSpinner startSecondSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getSecondsFromDate(this._puceResult.getPuce().getStartTime()), 0, 59, 1));
        startSecondSpinner.setEditor(new JSpinner.NumberEditor(startSecondSpinner, "00"));
        startSecondSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setSecondsToDate(this._puceResult.getPuce().getStartTime(), (Integer)startSecondSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        startSecondSpinner.setEnabled(this._puceResult.getEtape().getStartType() == StartType.BOITIER);
        return startSecondSpinner;
    }

    private JSpinner _createFinishHourSpinner() {
        JSpinner finishHourSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getHoursFromDate(this._puceResult.getPuce().getFinishTime()), 0, 47, 1));
        finishHourSpinner.setEditor(new JSpinner.NumberEditor(finishHourSpinner, "00"));
        finishHourSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setHoursToDate(this._puceResult.getPuce().getFinishTime(), (Integer)finishHourSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return finishHourSpinner;
    }

    private JSpinner _createFinishMinuteSpinner() {
        JSpinner finishMinuteSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getMinutesFromDate(this._puceResult.getPuce().getFinishTime()), 0, 59, 1));
        finishMinuteSpinner.setEditor(new JSpinner.NumberEditor(finishMinuteSpinner, "00"));
        finishMinuteSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setMinutesToDate(this._puceResult.getPuce().getFinishTime(), (Integer)finishMinuteSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return finishMinuteSpinner;
    }

    private JSpinner _createFinishSecondSpinner() {
        JSpinner finishSecondSpinner = new JSpinner(new SpinnerNumberModel(DateTimeUtils.getSecondsFromDate(this._puceResult.getPuce().getFinishTime()), 0, 59, 1));
        finishSecondSpinner.setEditor(new JSpinner.NumberEditor(finishSecondSpinner, "00"));
        finishSecondSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setSecondsToDate(this._puceResult.getPuce().getFinishTime(), (Integer)finishSecondSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return finishSecondSpinner;
    }

    private JPanel _createPunchesPanel() {
        JPanel punchesPanel = new JPanel(new BorderLayout());
        punchesPanel.setBorder(new TitledBorder(null, L10n.getString("random_result_editor.control_panel.title"), 4, 2));
        punchesPanel.add((Component)this._createButtonsPanel(), "North");
        punchesPanel.add((Component)this._createJScrollPane(), "Center");
        punchesPanel.add((Component)this._createSortButtonsPanel(), "West");
        return punchesPanel;
    }

    private JPanel _createButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this._createAddControlButton());
        panel.add(this._createEditControlButton());
        panel.add(this._createDeleteControlButton());
        return panel;
    }

    private JButton _createAddControlButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("random_result_editor.control_panel.add.tooltip"));
        button.addActionListener(event -> {
            AtomicInteger index = new AtomicInteger(0);
            PartialEditorDialog dialog = PartialEditorDialog.buildCreator(this, new Partiel(), partiel -> {
                Puce puce = this._puceResult.getPuce();
                index.set(puce.addPartiel((Partiel)partiel));
                this._baliseList.setSelectedIndex(index.get());
            });
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
            this._baliseList.setSelectedIndex(index.get());
            this._baliseList.ensureIndexIsVisible(index.get());
        });
        return button;
    }

    private JButton _createEditControlButton() {
        IconButton button = new IconButton("edit-24.png");
        button.setToolTipText(L10n.getString("random_result_editor.control_panel.edit.tooltip"));
        button.addActionListener(event -> {
            AtomicInteger index = new AtomicInteger(0);
            if (this._baliseList.getModel().getSize() > 0) {
                PartialEditorDialog dialog = PartialEditorDialog.buildEditor(this, this._baliseList.getSelectedValue(), partiel -> {
                    Puce puce = this._puceResult.getPuce();
                    index.set(puce.movePartiel((Partiel)partiel));
                });
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(index.get());
                this._baliseList.ensureIndexIsVisible(index.get());
            }
        });
        return button;
    }

    private JButton _createDeleteControlButton() {
        IconButton button = new IconButton("delete-24.png");
        button.setToolTipText(L10n.getString("random_result_editor.control_panel.delete.tooltip"));
        button.addActionListener(event -> this._deleteBalise());
        return button;
    }

    private void _deleteBalise() {
        if (this._baliseList.getModel().getSize() > 0) {
            String message = this._baliseList.getSelectedIndices().length == 1 ? L10n.getString("random_result_editor.delete.confirmation_message1") : L10n.getString("random_result_editor.delete.confirmation_message2");
            int reply = JOptionPane.showConfirmDialog(this.rootPane, message, L10n.getString("random_result_editor.result_panel.confirmation_title"), 0, 3);
            if (reply == 0) {
                for (Partiel partiel : this._baliseList.getSelectedValuesList()) {
                    this._puceResult.getPuce().removePartiel(partiel);
                }
            }
            this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
            this._baliseList.repaint();
            this._baliseList.setSelectedIndex(0);
        }
    }

    private JPanel _createSortButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createMoveUpButton());
        panel.add(this._createMoveDownButton());
        return panel;
    }

    private JButton _createMoveUpButton() {
        IconButton button = new IconButton("up-24.png");
        button.setToolTipText(L10n.getString("random_result_editor.control_panel.up.tooltip"));
        button.addActionListener(event -> {
            int selectedIndex = this._baliseList.getSelectedIndex();
            if (selectedIndex >= 0) {
                this._puceResult.getPuce().moveUpPartiel(selectedIndex);
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(selectedIndex - 1);
                this._baliseList.ensureIndexIsVisible(selectedIndex - 1);
            }
        });
        return button;
    }

    private JButton _createMoveDownButton() {
        IconButton button = new IconButton("down-24.png");
        button.setMnemonic(0);
        button.setToolTipText(L10n.getString("random_result_editor.control_panel.down.tooltip"));
        button.addActionListener(event -> {
            int selectedIndex = this._baliseList.getSelectedIndex();
            if (selectedIndex >= 0) {
                this._puceResult.getPuce().moveDownPartiel(selectedIndex);
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(selectedIndex + 1);
                this._baliseList.ensureIndexIsVisible(selectedIndex + 1);
            }
        });
        return button;
    }

    private JScrollPane _createJScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this._baliseList = new JList();
        this._baliseList.setSelectionMode(2);
        final RandomResultEditor parent = this;
        this._baliseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                AtomicInteger index = new AtomicInteger(0);
                if (event.getClickCount() > 1 && RandomResultEditor.this._baliseList.getModel().getSize() > 0) {
                    PartialEditorDialog dialog = PartialEditorDialog.buildEditor(parent, RandomResultEditor.this._baliseList.getSelectedValue(), partiel -> {
                        Puce puce = RandomResultEditor.this._puceResult.getPuce();
                        index.set(puce.movePartiel((Partiel)partiel));
                    });
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                    RandomResultEditor.this._baliseList.setListData((Partiel[])RandomResultEditor.this._puceResult.getPuce().getPartielsAsArray());
                    RandomResultEditor.this._baliseList.setSelectedIndex(index.get());
                    RandomResultEditor.this._baliseList.ensureIndexIsVisible(index.get());
                }
            }
        });
        SwingUtils.addDeleteShortcut(this._baliseList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomResultEditor.this._deleteBalise();
            }
        });
        scrollPane.setViewportView(this._baliseList);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        return scrollPane;
    }
}

