/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.simulation.SimulationPresenter;
import fr.geraidv3.desktop.simulation.SimulationView;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

@ExcludeFromJacocoGeneratedReport
final class RandomResultGeneratorDialog
extends GDialog {
    private final transient SimulationPresenter _presenter;
    private final DefaultListModel<Integer> _pmListModel = new DefaultListModel();
    private JList<Integer> _pmList;
    private JSpinner _resultCountSpinner;
    private JSpinner _pmCountSpinner;
    private JSpinner _startHourSpinner;
    private JSpinner _startMinuteSpinner;
    private JSpinner _startSecondSpinner;
    private JLabel _errorLabel;
    private JSpinner _gapMinuteSpinner;
    private JSpinner _gapSecondSpinner;
    private JButton _deleteBaliseButton;

    RandomResultGeneratorDialog(SimulationView parent, SimulationPresenter presenter) {
        super(parent);
        this._presenter = presenter;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("random_result_generator_dialog.title"));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this._getContentPanel(), "Center");
        pane.add((Component)this._getButtonPanel(), "South");
        this.setContentPane(pane);
        this.pack();
        this._updateButtonState();
    }

    private JPanel _getContentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(this._getParamsPanel());
        contentPanel.add(this._getErrorPanel());
        return contentPanel;
    }

    private JScrollPane _getParamsPanel() {
        JScrollPane scrollPane = new JScrollPane();
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 1));
        paramsPanel.add(this._createResultsButton());
        paramsPanel.add(this._createAveragePMPanel());
        paramsPanel.add(this._createPMPanel());
        paramsPanel.add(this._createGapPanel());
        paramsPanel.add(this._createStartPanel());
        scrollPane.setViewportView(paramsPanel);
        scrollPane.setPreferredSize(new Dimension(400, 400));
        return scrollPane;
    }

    private JPanel _getErrorPanel() {
        JPanel errorPanel = new JPanel(new FlowLayout(0));
        this._errorLabel = new JLabel(" ");
        this._errorLabel.setForeground(Color.red);
        errorPanel.add(this._errorLabel);
        return errorPanel;
    }

    private JPanel _createResultsButton() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("random_result_generator_dialog.total_results")));
        panel.add(this._createTotalResultsSpinner());
        return panel;
    }

    private JSpinner _createTotalResultsSpinner() {
        this._resultCountSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        return this._resultCountSpinner;
    }

    private JPanel _createAveragePMPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("random_result_generator_dialog.random_PM"), 4, 2));
        panel.add(new JLabel(L10n.getString("random_result_generator_dialog.total_PM")));
        panel.add(this._createAverageNbPMSpinner());
        return panel;
    }

    private JSpinner _createAverageNbPMSpinner() {
        this._pmCountSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        return this._pmCountSpinner;
    }

    private JPanel _createPMPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("random_result_generator_dialog.custom_PM"), 4, 2));
        panel.add(this._createControlPanel());
        panel.add(this._createPMList());
        return panel;
    }

    private JPanel _createControlPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createAddPMButton());
        panel.add(this._createDeletePMButton());
        return panel;
    }

    private JButton _createAddPMButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("random_result_generator_dialog.add.tooltip"));
        button.addActionListener(event -> {
            JSpinner codeSpinner = RandomResultGeneratorDialog._createCodeSpinner();
            int option = JOptionPane.showOptionDialog(this.rootPane, codeSpinner, L10n.getString("random_result_generator_dialog.add.title"), 2, 3, null, null, null);
            if (option == 0) {
                int code = (Integer)codeSpinner.getValue();
                if (((DefaultListModel)this._pmList.getModel()).contains(code)) {
                    this._errorLabel.setText(L10n.getString("random_result_generator_dialog.error1"));
                } else {
                    this._errorLabel.setText("");
                    this._pmListModel.addElement(code);
                    this._updateButtonState();
                }
            }
        });
        return button;
    }

    private static JSpinner _createCodeSpinner() {
        JSpinner codeSpinner = new JSpinner(new SpinnerNumberModel(31, 31, 800, 1));
        codeSpinner.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                event.getComponent().requestFocusInWindow();
            }
        });
        return codeSpinner;
    }

    private JButton _createDeletePMButton() {
        this._deleteBaliseButton = new IconButton("delete-24.png");
        this._deleteBaliseButton.setToolTipText(L10n.getString("random_result_generator_dialog.delete.tooltip"));
        this._deleteBaliseButton.addActionListener(event -> {
            if (this._pmList.getSelectedIndex() != -1) {
                this._pmListModel.removeElement(this._pmList.getSelectedValue());
            }
            this._pmList.repaint();
            this._updateButtonState();
        });
        return this._deleteBaliseButton;
    }

    private void _updateButtonState() {
        this._deleteBaliseButton.setEnabled(this._pmList.getSelectedIndex() > -1);
    }

    private JPanel _createGapPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("random_result_generator_dialog.gap")));
        panel.add(this._createGapMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createGapSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JSpinner _createGapMinuteSpinner() {
        this._gapMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._gapMinuteSpinner.setEditor(new JSpinner.NumberEditor(this._gapMinuteSpinner, "00"));
        return this._gapMinuteSpinner;
    }

    private JSpinner _createGapSecondSpinner() {
        this._gapSecondSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 59, 1));
        this._gapSecondSpinner.setEditor(new JSpinner.NumberEditor(this._gapSecondSpinner, "00"));
        return this._gapSecondSpinner;
    }

    private JScrollPane _createPMList() {
        this._pmList = new JList();
        this._pmList.setModel(this._pmListModel);
        this._pmList.setSelectionMode(0);
        this._pmList.addListSelectionListener(e -> this._updateButtonState());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this._pmList);
        scrollPane.setPreferredSize(new Dimension(100, 100));
        return scrollPane;
    }

    private JPanel _createStartPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("random_result_generator_dialog.start")));
        panel.add(this._createStartHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createStartMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createStartSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JSpinner _createStartHourSpinner() {
        this._startHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        this._startHourSpinner.setEditor(new JSpinner.NumberEditor(this._startHourSpinner, "00"));
        return this._startHourSpinner;
    }

    private JSpinner _createStartMinuteSpinner() {
        this._startMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._startMinuteSpinner.setEditor(new JSpinner.NumberEditor(this._startMinuteSpinner, "00"));
        return this._startMinuteSpinner;
    }

    private JSpinner _createStartSecondSpinner() {
        this._startSecondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._startSecondSpinner.setEditor(new JSpinner.NumberEditor(this._startSecondSpinner, "00"));
        return this._startSecondSpinner;
    }

    private JPanel _getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this._createValidateButton());
        buttonPanel.add(this._createCancelButton());
        return buttonPanel;
    }

    private JButton _createValidateButton() {
        JButton validateButton = new JButton(L10n.getString("random_result_generator_dialog.validate"));
        validateButton.addActionListener(event -> {
            this._generateRandomResults();
            this.dispose();
        });
        return validateButton;
    }

    private void _generateRandomResults() {
        Date startTime = DateTimeUtils.setHoursToDate(new Date(0L), (Integer)this._startHourSpinner.getValue());
        startTime = DateTimeUtils.setMinutesToDate(startTime, (Integer)this._startMinuteSpinner.getValue());
        startTime = DateTimeUtils.setSecondsToDate(startTime, (Integer)this._startSecondSpinner.getValue());
        Date timeGapBetweenBalises = DateTimeUtils.setMinutesToDate(new Date(0L), (Integer)this._gapMinuteSpinner.getValue());
        timeGapBetweenBalises = DateTimeUtils.setSecondsToDate(timeGapBetweenBalises, (Integer)this._gapSecondSpinner.getValue());
        int totalEquipesToGenerate = (Integer)this._resultCountSpinner.getValue();
        int totalRandomPmToGenerate = (Integer)this._pmCountSpinner.getValue();
        HashSet<Integer> codesToBeSetAsPm = new HashSet<Integer>();
        for (int i = 0; i < this._pmListModel.getSize(); ++i) {
            codesToBeSetAsPm.add(this._pmListModel.getElementAt(i));
        }
        this._presenter.generateRandomResults(totalEquipesToGenerate, totalRandomPmToGenerate, codesToBeSetAsPm, startTime, timeGapBetweenBalises);
    }

    private JButton _createCancelButton() {
        JButton cancelButton = new JButton(L10n.getString("cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        this.setCancelButton(cancelButton);
        return cancelButton;
    }
}

