/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.sportident_panel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JEditorPane;
import javax.swing.text.View;

public class DocumentRenderer
implements Printable {
    private final JEditorPane _editorPane = new JEditorPane();
    private double _scale;
    private int _currentPage = -1;
    private double _pageEndY = 0.0;
    private double _pageStartY = 0.0;

    public DocumentRenderer(JEditorPane editorPane) {
        this._editorPane.setContentType(editorPane.getContentType());
        this._editorPane.setDocument(editorPane.getDocument());
    }

    public void setScale(double scale) {
        this._scale = scale;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this._editorPane.setMinimumSize(new Dimension((int)(pageFormat.getImageableWidth() / this._scale), Integer.MAX_VALUE));
        this._editorPane.setSize((int)(pageFormat.getImageableWidth() / this._scale), Integer.MAX_VALUE);
        this._editorPane.validate();
        View rootView = this._editorPane.getUI().getRootView(this._editorPane);
        graphics2D.scale(this._scale, this._scale);
        graphics2D.setClip((int)(pageFormat.getImageableX() / this._scale), (int)(pageFormat.getImageableY() / this._scale), (int)(pageFormat.getImageableWidth() / this._scale), (int)(pageFormat.getImageableHeight() / this._scale));
        if (pageIndex > this._currentPage) {
            this._currentPage = pageIndex;
            this._pageStartY += this._pageEndY;
            this._pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this._pageStartY), (int)this._editorPane.getMinimumSize().getWidth(), (int)this._editorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this._pageStartY = 0.0;
        this._pageEndY = 0.0;
        this._currentPage = -1;
        return 1;
    }

    private boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        Rectangle clipRectangle = graphics2D.getClipBounds();
        boolean pageExists = false;
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this._pageEndY) {
                    this._pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }
}

