/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.swing_ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private final List<List<Integer>> _rowColHeight = new ArrayList<List<Integer>>();

    public MultiLineCellRenderer() {
        this.setLineWrap(false);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(this._copyColor(table.getSelectionForeground()));
            this.setBackground(this._copyColor(table.getSelectionBackground()));
        } else {
            if (row % 2 == 0) {
                this.setBackground(this._copyColor(table.getBackground()));
            } else {
                Color color = (Color)UIManager.get("Table.alternateRowColor");
                this.setBackground(this._copyColor(color));
            }
            this.setForeground(this._copyColor(table.getForeground()));
        }
        this.setFont(table.getFont());
        this.setText(value == null ? "" : value.toString());
        this.adjustRowHeight(table, row, column);
        return this;
    }

    private Color _copyColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        int columnWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        this.setSize(new Dimension(columnWidth, 1000));
        int preferredHeight = this.getPreferredSize().height;
        while (this._rowColHeight.size() <= row) {
            this._rowColHeight.add(new ArrayList(column));
        }
        List<Integer> columnHeights = this._rowColHeight.get(row);
        while (columnHeights.size() <= column) {
            columnHeights.add(0);
        }
        columnHeights.set(column, preferredHeight);
        int maxHeight = preferredHeight;
        for (Integer colHeight : columnHeights) {
            if (colHeight <= maxHeight) continue;
            maxHeight = colHeight;
        }
        if (table.getRowHeight(row) != maxHeight) {
            table.setRowHeight(row, maxHeight);
        }
    }
}

