/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.tools_menu;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.result_panel.HtmlWriter;
import fr.geraidv3.model.GlobalSettings;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

class Presenter {
    public static final int IMAGE_SIZE = 350;
    private final GlobalSettings _globalSettings;
    private final JDialog _view;

    public Presenter(JDialog view, GlobalSettings globalSettings) {
        this._view = view;
        this._globalSettings = globalSettings;
    }

    public boolean generateQrCodes(String url, List<String> selectedParcoursNames, String raidName) {
        if (!this._generateQrCodes(url, selectedParcoursNames, raidName)) {
            return false;
        }
        String oldUrl = this._globalSettings.getPublicationUrl();
        if (!url.equals(oldUrl)) {
            this._globalSettings.setPublicationUrl(url);
        }
        return true;
    }

    private boolean _generateQrCodes(String url, List<String> selectedParcoursNames, String raidName) {
        if (url == null || url.isEmpty()) {
            JOptionPane.showMessageDialog(this._view, L10n.getString("qr_code.error.empty_text"), "Error", 0);
            return false;
        }
        if (selectedParcoursNames.isEmpty()) {
            JOptionPane.showMessageDialog(this._view, L10n.getString("qr_code.error.empty_parcours"), "Error", 0);
            return false;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(L10n.getString("qr_code.save.title"));
        fileChooser.setFileFilter(new FileNameExtensionFilter("ZIP Archive", "zip"));
        int userSelection = fileChooser.showSaveDialog(this._view);
        if (userSelection == 0) {
            boolean bl;
            File fileToSave = fileChooser.getSelectedFile();
            if (!fileToSave.getName().toLowerCase().endsWith(".zip")) {
                fileToSave = new File(fileToSave.getParentFile(), fileToSave.getName() + ".zip");
            }
            Object baseUrl = url.endsWith("/") ? url : url + "/";
            StringBuilder htmlFiles = new StringBuilder();
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(fileToSave));
            try {
                for (String selectedParcoursName : selectedParcoursNames) {
                    String htmlFileName = HtmlWriter.createParcoursHtmlFilename(raidName, selectedParcoursName, L10n.getString("result_view.detailed_result.categorie.label2"));
                    String encodedFileName = URLEncoder.encode(htmlFileName, StandardCharsets.UTF_8).replace("+", "%20");
                    String fullUrl = (String)baseUrl + encodedFileName;
                    htmlFiles.append("\n- ").append(fullUrl);
                    byte[] qrCodeImage = Presenter._generateQRCodeByteArray(fullUrl);
                    ZipEntry entry = new ZipEntry(raidName + "_" + selectedParcoursName + ".png");
                    zos.putNextEntry(entry);
                    zos.write(qrCodeImage);
                    zos.closeEntry();
                }
                JOptionPane.showMessageDialog(this._view, Presenter._copyableJLabel(htmlFiles));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this._view, L10n.getString("qr_code.error.generation_failed") + " : " + ex.getMessage(), "Error", 0);
                    return false;
                }
            }
            zos.close();
            return bl;
        }
        return false;
    }

    private static byte[] _generateQRCodeByteArray(String text) throws Exception {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, 350, 350);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    private static JTextArea _copyableJLabel(StringBuilder htmlFiles) {
        JTextArea textField = new JTextArea(L10n.getString("qr_code.success.message") + String.valueOf(htmlFiles));
        textField.setBorder(null);
        textField.setOpaque(false);
        textField.setEditable(false);
        textField.setCaretColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        return textField;
    }
}

